<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DocumentosScawattCompartidosMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @param  array  $payload  Datos con claves: 'scawatt_serial', 'propietario', 'solicitante', 'enlaces'.
     */
    public function __construct(
        public array $payload
    ) {
    }

    public function build(): self
    {
        return $this->subject('Documentos autorizados de ScaWatt')
            ->view('emails.scawatt.documentos_autorizados')
            ->with($this->payload);
    }
}
