<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Scawatt extends Model
{
    protected $table = 'scawatts';
    protected $primaryKey = 'id';
    
    protected $fillable = [
        'scawatt_id',
        'usuario_id',
        'granja_id',
        'kwh_asignados',
        'valor_actual',
        'valor_inicial',
        'valorizaciones',
        'fecha_inicio',
        'fecha_final',
        'estado',
        'tipo'
    ];

    protected $casts = [
        'kwh_asignados' => 'decimal:2',
        'valor_actual' => 'decimal:2',
        'valor_inicial' => 'decimal:2',
        'valorizaciones' => 'array',
        'fecha_inicio' => 'date',
        'fecha_final' => 'date'
    ];

    protected $appends = ['valorizacion_total'];

    /**
     * Calcular valorización total
     */
    public function getValorizacionTotalAttribute()
    {
        return $this->valor_actual - $this->valor_inicial;
    }

    public function usuario(): BelongsTo
    {
        return $this->belongsTo(Usuario::class, 'usuario_id');
    }

    public function granja(): BelongsTo
    {
        return $this->belongsTo(Granja::class, 'granja_id');
    }

    public function trazabilidad(): HasMany
    {
        return $this->hasMany(Trazabilidad::class, 'scawatt_id');
    }

    public function propietarios(): HasMany
    {
        return $this->hasMany(Propietario::class, 'scawatt_id');
    }
}
