<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('solicitudes_contacto_scawatt', function (Blueprint $table) {
            $table->id();
            $table->foreignId('usuario_id')->constrained('usuarios')->onDelete('cascade');
            $table->string('nombre_completo', 200);
            $table->string('cedula', 50);
            $table->string('email', 200);
            $table->string('telefono', 50)->nullable();
            $table->integer('cantidad_scawatts')->default(1);
            $table->decimal('presupuesto_aproximado', 15, 2)->nullable();
            $table->text('mensaje')->nullable();
            $table->enum('estado', ['pendiente', 'contactado', 'completado', 'cancelado'])->default('pendiente');
            $table->timestamp('fecha_contacto')->nullable();
            $table->foreignId('atendido_por')->nullable()->constrained('usuarios')->onDelete('set null');
            $table->text('notas_admin')->nullable();
            $table->timestamps();
            
            $table->index('usuario_id');
            $table->index('cedula');
            $table->index('estado');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('solicitudes_contacto_scawatt');
    }
};
