<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Ajustar columnas existentes mediante SQL directo para evitar dependencias adicionales
        DB::statement("ALTER TABLE notificaciones CHANGE contenido mensaje TEXT NOT NULL");
        DB::statement("ALTER TABLE notificaciones MODIFY tipo VARCHAR(50) NOT NULL DEFAULT 'info'");

        Schema::table('notificaciones', function (Blueprint $table) {
            if (!Schema::hasColumn('notificaciones', 'prioridad')) {
                $table->string('prioridad', 20)->default('media')->after('tipo');
            }

            if (!Schema::hasColumn('notificaciones', 'datos_adicionales')) {
                $table->json('datos_adicionales')->nullable()->after('icono');
            }
        });
    }

    public function down(): void
    {
        Schema::table('notificaciones', function (Blueprint $table) {
            if (Schema::hasColumn('notificaciones', 'datos_adicionales')) {
                $table->dropColumn('datos_adicionales');
            }

            if (Schema::hasColumn('notificaciones', 'prioridad')) {
                $table->dropColumn('prioridad');
            }
        });

        DB::statement("ALTER TABLE notificaciones MODIFY tipo ENUM('valorizacion','deposito','retiro','marketplace','sistema','custom') NOT NULL DEFAULT 'sistema'");
        DB::statement("ALTER TABLE notificaciones CHANGE mensaje contenido TEXT NOT NULL");
    }
};
