<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        DB::statement('ALTER TABLE retiros CHANGE fecha_completado fecha_procesado TIMESTAMP NULL DEFAULT NULL');

        Schema::table('retiros', function (Blueprint $table) {
            if (!Schema::hasColumn('retiros', 'notas_usuario')) {
                $table->text('notas_usuario')->nullable()->after('notas_admin');
            }

            if (!Schema::hasColumn('retiros', 'comprobante_ruta')) {
                $table->string('comprobante_ruta')->nullable()->after('referencia_transaccion');
            }
        });
    }

    public function down(): void
    {
        Schema::table('retiros', function (Blueprint $table) {
            if (Schema::hasColumn('retiros', 'comprobante_ruta')) {
                $table->dropColumn('comprobante_ruta');
            }

            if (Schema::hasColumn('retiros', 'notas_usuario')) {
                $table->dropColumn('notas_usuario');
            }
        });

        DB::statement('ALTER TABLE retiros CHANGE fecha_procesado fecha_completado TIMESTAMP NULL DEFAULT NULL');
    }
};
