<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('solicitudes_documentos_scawatt', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('scawatt_id')->nullable();
            $table->unsignedBigInteger('propietario_id')->nullable();
            $table->string('codigo_hash', 120);
            $table->string('codigo_preview', 8)->nullable();
            $table->string('estado', 32)->default('pendiente');
            $table->unsignedInteger('intentos')->default(0);
            $table->string('solicitante_nombre', 120)->nullable();
            $table->string('solicitante_email', 160)->nullable();
            $table->string('solicitante_telefono', 40)->nullable();
            $table->text('motivo')->nullable();
            $table->timestamp('expires_at')->nullable();
            $table->timestamp('enviado_at')->nullable();
            $table->timestamp('autorizado_at')->nullable();
            $table->timestamp('finalizado_at')->nullable();
            $table->timestamps();

            $table->foreign('scawatt_id')->references('id')->on('scawatts')->nullOnDelete();
            $table->foreign('propietario_id')->references('id')->on('usuarios')->nullOnDelete();

            $table->index(['scawatt_id', 'estado']);
            $table->index(['propietario_id', 'estado']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('solicitudes_documentos_scawatt');
    }
};
