<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('marketplace')) {
            return;
        }

        Schema::table('marketplace', function (Blueprint $table) {
            if (!Schema::hasColumn('marketplace', 'destacado')) {
                $table->boolean('destacado')->default(false)->after('descripcion');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('marketplace')) {
            return;
        }

        Schema::table('marketplace', function (Blueprint $table) {
            if (Schema::hasColumn('marketplace', 'destacado')) {
                $table->dropColumn('destacado');
            }
        });
    }
};
