@extends('layouts.app')

@section('title', 'Gestión de usuarios')
@section('page-title', 'Usuarios')
@section('page-subtitle', 'Monitorea saldos, verificaciones y actividad de toda la base de clientes')

@section('page-actions')
<div class="d-flex gap-2">
    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#modalCrearUsuario">
        <i class="fas fa-user-plus me-1"></i> Nuevo usuario
    </button>
    <a href="{{ route('admin.transacciones') }}" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-coins me-1"></i> Transacciones
    </a>
    <a href="{{ route('admin.monitor') }}" class="btn btn-sm btn-secondary">
        <i class="fas fa-wave-square me-1"></i> Monitor
    </a>
</div>
@endsection

@php
    $estadoModalOptions = [
        'activo' => 'Activo',
        'inactivo' => 'Inactivo',
        'bloqueado' => 'Bloqueado',
        'admin' => 'Administrador',
    ];
@endphp

<div class="modal fade" id="modalCrearUsuario" tabindex="-1" aria-labelledby="modalCrearUsuarioLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <form method="post" action="{{ route('admin.usuarios.store') }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="modalCrearUsuarioLabel">
                        <i class="fas fa-user-plus me-2"></i>Registrar nuevo usuario
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="nuevo-nombre" class="form-label">Nombre completo</label>
                            <input type="text" id="nuevo-nombre" name="nombre" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="nuevo-email" class="form-label">Correo electrónico</label>
                            <input type="email" id="nuevo-email" name="email" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="nuevo-telefono" class="form-label">Teléfono</label>
                            <input type="text" id="nuevo-telefono" name="telefono" class="form-control" placeholder="Opcional">
                        </div>
                        <div class="col-md-3">
                            <label for="nuevo-estado" class="form-label">Estado inicial</label>
                            <select id="nuevo-estado" name="estado" class="form-select" required>
                                @foreach($estadoModalOptions as $value => $label)
                                    <option value="{{ $value }}" @selected($value === 'activo')>{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="nuevo-password" class="form-label">Contraseña</label>
                            <input type="text" id="nuevo-password" name="password" class="form-control" placeholder="Generar automática">
                            <div class="form-text">Déjalo vacío para generar una clave temporal.</div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar usuario</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditarUsuario" tabindex="-1" aria-labelledby="modalEditarUsuarioLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <form method="post" action="#" id="formEditarUsuario">
                @csrf
                @method('PUT')
                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditarUsuarioLabel">
                        <i class="fas fa-user-gear me-2"></i>Editar usuario <span class="text-primary" id="editarUsuarioNombre"></span>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="editar-nombre" class="form-label">Nombre completo</label>
                            <input type="text" id="editar-nombre" name="nombre" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="editar-email" class="form-label">Correo electrónico</label>
                            <input type="email" id="editar-email" name="email" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="editar-telefono" class="form-label">Teléfono</label>
                            <input type="text" id="editar-telefono" name="telefono" class="form-control" placeholder="Opcional">
                        </div>
                        <div class="col-md-3">
                            <label for="editar-estado" class="form-label">Estado</label>
                            <select id="editar-estado" name="estado" class="form-select" required>
                                @foreach($estadoModalOptions as $value => $label)
                                    <option value="{{ $value }}">{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="editar-password" class="form-label">Nueva contraseña</label>
                            <input type="text" id="editar-password" name="password" class="form-control" placeholder="No cambiar">
                            <div class="form-text">Déjalo vacío para mantener la actual.</div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary">Actualizar usuario</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.estado-trigger').forEach(item => {
        item.addEventListener('click', event => {
            event.preventDefault();
            const userId = item.dataset.userId;
            const estado = item.dataset.estadoTarget;
            const form = document.getElementById(`estado-form-${userId}`);

            if (!form) {
                return;
            }

            const input = form.querySelector('input[name="estado"]');
            input.value = estado;
            form.submit();
        });
    });

    const editarModal = document.getElementById('modalEditarUsuario');
    if (editarModal) {
        editarModal.addEventListener('show.bs.modal', event => {
            const button = event.relatedTarget;
            if (!button) {
                return;
            }

            const form = editarModal.querySelector('form');
            form.action = button.getAttribute('data-action');

            editarModal.querySelector('#editar-nombre').value = button.getAttribute('data-nombre') || '';
            editarModal.querySelector('#editar-email').value = button.getAttribute('data-email') || '';
            editarModal.querySelector('#editar-telefono').value = button.getAttribute('data-telefono') || '';
            editarModal.querySelector('#editar-estado').value = button.getAttribute('data-estado') || 'activo';
            editarModal.querySelector('#editar-password').value = '';
            editarModal.querySelector('#editarUsuarioNombre').textContent = button.getAttribute('data-nombre') || '';
        });

        editarModal.addEventListener('hidden.bs.modal', () => {
            const form = editarModal.querySelector('form');
            form.action = '#';
            editarModal.querySelector('#editar-nombre').value = '';
            editarModal.querySelector('#editar-email').value = '';
            editarModal.querySelector('#editar-telefono').value = '';
            editarModal.querySelector('#editar-estado').value = 'activo';
            editarModal.querySelector('#editar-password').value = '';
            editarModal.querySelector('#editarUsuarioNombre').textContent = '';
        });
    }
});
</script>
@endpush

@section('content')
@php
    $estadoOptions = [
        'todos' => 'Todos los estados',
        'activo' => 'Activos',
        'inactivo' => 'Inactivos',
        'bloqueado' => 'Bloqueados',
        'admin' => 'Administradores',
    ];

    $verificacionOptions = [
        'todos' => 'Todas las verificaciones',
        'completos' => 'Verificación completa',
        'cedula' => 'Solo cédula aprobada',
        'bancarios' => 'Solo datos bancarios',
        'pendientes' => 'Con verificaciones pendientes',
    ];

    $ordenOptions = [
        'recientes' => 'Más recientes',
        'actividad' => 'Última actividad',
        'nombre' => 'Orden alfabético',
        'saldo_desc' => 'Saldo mayor a menor',
        'saldo_asc' => 'Saldo menor a mayor',
    ];

    $estadoLabels = [
        'activo' => ['label' => 'Activar', 'class' => 'text-success'],
        'inactivo' => ['label' => 'Marcar inactivo', 'class' => 'text-muted'],
        'bloqueado' => ['label' => 'Bloquear acceso', 'class' => 'text-danger'],
        'admin' => ['label' => 'Asignar admin', 'class' => 'text-primary'],
    ];

    $estadoModalOptions = collect($estadoOptions)->except('todos')->toArray();
@endphp

<div class="row g-3 mb-1">
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Total usuarios</p>
                        <h4 class="fw-semibold mb-0">{{ number_format($stats['total']) }}</h4>
                    </div>
                    <span class="icon-circle bg-primary-subtle text-primary"><i class="fas fa-users"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Activos</p>
                        <h4 class="fw-semibold mb-0">{{ number_format($stats['activos']) }}</h4>
                    </div>
                    <span class="icon-circle bg-success-subtle text-success"><i class="fas fa-user-check"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Nuevos 30 días</p>
                        <h4 class="fw-semibold mb-0">{{ number_format($stats['nuevos_mes']) }}</h4>
                    </div>
                    <span class="icon-circle bg-info-subtle text-info"><i class="fas fa-user-plus"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Verificados</p>
                        <h4 class="fw-semibold mb-0">{{ number_format($stats['verificados']) }}</h4>
                    </div>
                    <span class="icon-circle bg-warning-subtle text-warning"><i class="fas fa-id-card"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Saldo total</p>
                        <h4 class="fw-semibold mb-0">{{ $stats['saldo_total'] }}</h4>
                    </div>
                    <span class="icon-circle bg-secondary-subtle text-secondary"><i class="fas fa-wallet"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Saldo pendiente</p>
                        <h4 class="fw-semibold mb-0">{{ $stats['saldo_pendiente'] }}</h4>
                    </div>
                    <span class="icon-circle bg-danger-subtle text-danger"><i class="fas fa-clock"></i></span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="get" class="row g-3 align-items-end">
            <div class="col-xl-3 col-md-4">
                <label for="estado" class="form-label small text-uppercase text-muted mb-1">Estado</label>
                <select id="estado" name="estado" class="form-select form-select-sm">
                    @foreach($estadoOptions as $value => $label)
                        <option value="{{ $value }}" @selected($filtros['estado'] === $value)>{{ $label }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-xl-3 col-md-4">
                <label for="verificacion" class="form-label small text-uppercase text-muted mb-1">Verificación</label>
                <select id="verificacion" name="verificacion" class="form-select form-select-sm">
                    @foreach($verificacionOptions as $value => $label)
                        <option value="{{ $value }}" @selected($filtros['verificacion'] === $value)>{{ $label }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="orden" class="form-label small text-uppercase text-muted mb-1">Orden</label>
                <select id="orden" name="orden" class="form-select form-select-sm">
                    @foreach($ordenOptions as $value => $label)
                        <option value="{{ $value }}" @selected($filtros['orden'] === $value)>{{ $label }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="por_pagina" class="form-label small text-uppercase text-muted mb-1">Por página</label>
                <input type="number" min="5" max="100" id="por_pagina" name="por_pagina" value="{{ $filtros['por_pagina'] }}" class="form-control form-control-sm">
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="q" class="form-label small text-uppercase text-muted mb-1">Buscar</label>
                <input type="search" id="q" name="q" value="{{ $filtros['q'] }}" class="form-control form-control-sm" placeholder="Nombre, correo, cédula...">
            </div>
            <div class="col-12 col-xl-2 col-md-4 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary flex-fill">
                    <i class="fas fa-filter me-1"></i> Aplicar
                </button>
                <a href="{{ route('admin.usuarios') }}" class="btn btn-sm btn-outline-secondary" title="Limpiar filtros">
                    <i class="fas fa-rotate-right"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<div class="row g-3">
    <div class="col-xxl-9">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="mb-0">Listado de usuarios</h6>
                    <small class="text-muted">Mostrando {{ $usuarios->firstItem() ?? 0 }}-{{ $usuarios->lastItem() ?? 0 }} de {{ $usuarios->total() }} registros</small>
                </div>
                <span class="badge bg-primary-subtle text-primary">{{ strtoupper($filtros['estado']) }}</span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Usuario</th>
                                <th>Identificación</th>
                                <th>Saldos</th>
                                <th>ScaWatts</th>
                                <th>Verificación</th>
                                <th class="text-center">Estado</th>
                                <th>Registro</th>
                                <th class="text-end">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                        @forelse($usuarios as $usuario)
                            <tr>
                                <td>
                                    <div class="fw-semibold">{{ $usuario->nombre ?? 'Sin nombre' }}</div>
                                    <small class="text-muted">{{ $usuario->email ?? 'Sin correo' }}</small>
                                </td>
                                <td>
                                    <div class="fw-semibold">{{ $usuario->cedula ?? 'N/D' }}</div>
                                    <small class="text-muted">Tel: {{ $usuario->telefono ?? 'N/D' }}</small>
                                </td>
                                <td>
                                    <div class="fw-semibold">Disp: ${{ number_format((float) ($usuario->saldo_disponible ?? 0), 0, ',', '.') }}</div>
                                    <small class="text-muted">Pend: ${{ number_format((float) ($usuario->saldo_pendiente ?? 0), 0, ',', '.') }} · Total: ${{ number_format((float) ($usuario->saldo_total ?? 0), 0, ',', '.') }}</small>
                                </td>
                                <td>
                                    <div class="fw-semibold">{{ number_format($usuario->scawatts_count) }} unidades</div>
                                    <small class="text-muted">Valor portafolio: ${{ number_format((float) ($usuario->valor_portafolio ?? 0), 0, ',', '.') }}</small>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $usuario->cedula_verificada_at ? 'success' : 'warning' }} text-{{ $usuario->cedula_verificada_at ? 'white' : 'dark' }}">Cédula</span>
                                    <span class="badge bg-{{ $usuario->datos_bancarios_verificados_at ? 'success' : 'warning' }} text-{{ $usuario->datos_bancarios_verificados_at ? 'white' : 'dark' }} ms-1">Bancarios</span>
                                    <div class="text-muted small mt-1">Dep: ${{ number_format((float) ($usuario->total_depositos ?? 0), 0, ',', '.') }} · Ret: ${{ number_format((float) ($usuario->total_retiros ?? 0), 0, ',', '.') }}</div>
                                </td>
                                <td class="text-center">
                                    <span class="badge {{ $usuario->estado === 'activo' ? 'bg-success' : ($usuario->estado === 'bloqueado' ? 'bg-danger' : 'bg-secondary') }}">
                                        {{ ucfirst($usuario->estado ?? 'N/D') }}
                                    </span>
                                </td>
                                <td>
                                    <div class="fw-semibold">{{ $usuario->created_at?->format('d M Y') ?? 'N/D' }}</div>
                                    <small class="text-muted">Último movimiento: {{ $usuario->updated_at?->diffForHumans() ?? 'N/D' }}</small>
                                </td>
                                <td class="text-end">
                                    <div class="btn-group">
                                        <button type="button"
                                            class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                            data-bs-toggle="dropdown" aria-expanded="false"
                                            data-user-id="{{ $usuario->id }}"
                                            data-nombre="{{ $usuario->nombre }}"
                                            data-email="{{ $usuario->email }}"
                                            data-telefono="{{ $usuario->telefono }}"
                                            data-estado="{{ $usuario->estado }}">
                                            <i class="fas fa-ellipsis-h"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li>
                                                <button type="button" class="dropdown-item"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#modalEditarUsuario"
                                                    data-action="{{ route('admin.usuarios.update', $usuario) }}"
                                                    data-nombre="{{ $usuario->nombre }}"
                                                    data-email="{{ $usuario->email }}"
                                                    data-telefono="{{ $usuario->telefono }}"
                                                    data-estado="{{ $usuario->estado }}">
                                                    <i class="fas fa-pen me-2"></i>Editar perfil
                                                </button>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="{{ url('/api/admin/usuarios/' . $usuario->id . '/detalle') }}" target="_blank" rel="noopener">
                                                    <i class="fas fa-up-right-from-square me-2"></i>Ver detalle API
                                                </a>
                                            </li>
                                            <li><hr class="dropdown-divider"></li>
                                            @foreach($estadoLabels as $estadoKey => $config)
                                                @continue($estadoKey === ($usuario->estado ?? ''))
                                                <li>
                                                    <a href="#" class="dropdown-item estado-trigger {{ $config['class'] }}"
                                                        data-user-id="{{ $usuario->id }}"
                                                        data-estado-target="{{ $estadoKey }}">
                                                        <i class="fas fa-user-gear me-2"></i>{{ $config['label'] }}
                                                    </a>
                                                </li>
                                            @endforeach
                                            <li><hr class="dropdown-divider"></li>
                                            <li>
                                                <a class="dropdown-item text-danger" href="mailto:{{ $usuario->email }}">
                                                    <i class="fas fa-envelope me-2"></i>Enviar correo directo
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <form id="estado-form-{{ $usuario->id }}" action="{{ route('admin.usuarios.estado', $usuario) }}" method="post" class="d-none">
                                        @csrf
                                        @method('PATCH')
                                        <input type="hidden" name="estado" value="">
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center text-muted py-5">No se encontraron usuarios con los filtros aplicados.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white border-0">
                <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-2">
                    <small class="text-muted">Verificaciones pendientes: {{ number_format($verificaciones['pendientes']) }}</small>
                    {{ $usuarios->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-3">
        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Segmentación por estado</h6>
                <span class="badge bg-dark-subtle text-dark">{{ number_format($stats['total']) }}</span>
            </div>
            <div class="card-body">
                @forelse($segmentacionEstados as $segmento)
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <span class="fw-semibold">{{ ucfirst(str_replace('_', ' ', $segmento['estado'])) }}</span>
                        <span class="badge bg-light text-dark">{{ number_format($segmento['total']) }}</span>
                    </div>
                @empty
                    <p class="text-muted mb-0">Sin datos disponibles.</p>
                @endforelse
            </div>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Top saldos disponibles</h6>
                <span class="badge bg-info-subtle text-info">{{ $topClientes->count() }}</span>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    @forelse($topClientes as $cliente)
                        <li class="list-group-item d-flex justify-content-between align-items-start">
                            <div>
                                <div class="fw-semibold">{{ $cliente->nombre ?? 'Usuario' }}</div>
                                <small class="text-muted">{{ $cliente->email ?? 'Sin correo' }}</small>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-primary">${{ number_format((float) ($cliente->saldo_disponible ?? 0), 0, ',', '.') }}</span>
                                <div><small class="text-muted">Total: ${{ number_format((float) ($cliente->saldo_total ?? 0), 0, ',', '.') }}</small></div>
                            </div>
                        </li>
                    @empty
                        <li class="list-group-item text-center text-muted py-4">Sin información disponible</li>
                    @endforelse
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection
