<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="x-apple-disable-message-reformatting" content="true">
    <title>Documentos autorizados</title>
    <style>
        body { font-family: Arial, Helvetica, sans-serif; color: #1f2937; margin: 0; padding: 0; background: #f9fafb; }
        .wrapper { padding: 32px 12px; }
        .container { max-width: 560px; margin: 0 auto; padding: 28px; border-radius: 16px; background: #ffffff; border: 1px solid #e5e7eb; box-shadow: 0 20px 40px rgba(15, 23, 42, 0.08); }
        .brand { text-align: center; margin-bottom: 22px; }
        .brand img { height: 48px; }
        .title { font-size: 22px; font-weight: 700; margin: 0 0 12px; color: #111827; text-align: center; }
        .lead { font-size: 16px; line-height: 1.6; margin-bottom: 20px; }
        .meta { font-size: 14px; color: #4b5563; margin-top: 24px; }
        .card { border-radius: 12px; border: 1px solid #e5e7eb; padding: 16px 18px; margin-bottom: 16px; background: #f9fafb; }
        .card strong { color: #111827; }
        .link-list { list-style: none; padding: 0; margin: 0; }
        .link-list li { margin-bottom: 12px; }
        .link { display: inline-block; font-size: 15px; font-weight: 600; color: #2563eb; text-decoration: none; }
        .link span { display: inline-flex; align-items: center; gap: 8px; }
        .badge { display: inline-block; padding: 2px 8px; border-radius: 999px; font-size: 12px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px; background: #dbeafe; color: #1d4ed8; }
    </style>
</head>
<body>
    <div class="wrapper">
        <div class="container">
            <div class="brand">
                <img src="https://escalar.app/brand/Logo%20Scalar%202025.png" alt="Scalar Energía Renovable">
            </div>

            <h1 class="title">Documentos autorizados</h1>

            @if(!empty($solicitante['nombre']))
                <p class="lead">Hola {{ $solicitante['nombre'] }},</p>
            @endif

            <p class="lead">
                El propietario <strong>{{ $propietario['nombre'] ?? 'Propietario' }}</strong> autorizó tu acceso al ScaWatt
                <strong>{{ $scawatt_serial }}</strong>. Puedes descargar los archivos habilitados a continuación.
            </p>

            @if(!empty($enlaces['certificado']))
                <div class="card">
                    <div class="badge">Certificado</div>
                    <p style="margin: 10px 0 14px;">Descarga el certificado de propiedad y características del ScaWatt.</p>
                    <a class="link" href="{{ $enlaces['certificado'] }}" target="_blank" rel="noopener">
                        <span>
                            Descargar certificado
                        </span>
                    </a>
                </div>
            @endif

            @if(!empty($enlaces['contrato']))
                <div class="card">
                    <div class="badge" style="background:#fee2e2;color:#b91c1c;">Contrato</div>
                    <p style="margin: 10px 0 14px;">Contrato original del ScaWatt (el propietario decidió compartirlo contigo).</p>
                    <a class="link" href="{{ $enlaces['contrato'] }}" target="_blank" rel="noopener">
                        <span>
                            Descargar contrato
                        </span>
                    </a>
                </div>
            @endif

            <p class="meta">
                Este acceso se otorgó el {{ now()->format('d/m/Y \a \l\a\s H:i') }}. Si necesitas el contrato u otros documentos adicionales, coordina directamente con el propietario o responde a este correo.
            </p>
        </div>
    </div>
</body>
</html>
