  @extends('layouts.app')

@section('title', 'Monitor Servidor - ScaWatts')

@section('page-title', 'Monitor Servidor')

@section('content')
<div class="d-flex justify-content-end mb-3">
    <button class="btn btn-outline-secondary btn-sm" onclick="resetMasterToken()">
        <i class="fas fa-key"></i> Cambiar token Master
    </button>
</div>
<!-- Banner de Estado General -->
<div class="alert alert-success alert-dismissible fade show mb-4" role="alert" id="banner-estado" style="display:none;">
    <div class="d-flex align-items-center">
        <i class="fas fa-check-circle fa-2x me-3"></i>
        <div class="flex-grow-1">
            <h5 class="alert-heading mb-1">✅ Todos los Sistemas Operativos</h5>
            <p class="mb-0"><small id="banner-detalle">Monitor activo, sincronización OK, base de datos conectada</small></p>
        </div>
        <small class="text-muted" id="banner-tiempo">Actualizado hace 0s</small>
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>

<!-- Dashboard Ejecutivo -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow-lg border-0">
            <div class="card-header bg-gradient-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-chart-line"></i> Dashboard Ejecutivo - Scalar Energía Renovable
                </h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-md-2">
                        <div class="p-3">
                            <i class="fas fa-solar-panel fa-2x text-primary mb-2"></i>
                            <h3 class="mb-0" id="dash-total-scawatts">-</h3>
                            <small class="text-muted">ScaWatts Activos</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="p-3">
                            <i class="fas fa-industry fa-2x text-success mb-2"></i>
                            <h3 class="mb-0" id="dash-total-granjas">-</h3>
                            <small class="text-muted">Granjas Solares</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="p-3">
                            <i class="fas fa-users fa-2x text-info mb-2"></i>
                            <h3 class="mb-0" id="dash-total-usuarios">-</h3>
                            <small class="text-muted">Usuarios</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="p-3">
                            <i class="fas fa-coins fa-2x text-warning mb-2"></i>
                            <h4 class="mb-0" id="dash-valor-actual">-</h4>
                            <small class="text-muted">Valor Total Actual</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="p-3">
                            <i class="fas fa-chart-line fa-2x text-success mb-2"></i>
                            <h4 class="mb-0" id="dash-valorizacion">-</h4>
                            <small class="text-muted">Valorización Total</small>
                            <br>
                            <span class="badge bg-success mt-1" id="dash-porcentaje">-</span>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <small class="text-muted">
                            <i class="fas fa-bolt"></i> Capacidad Total: <strong id="dash-capacidad">-</strong> MW
                        </small>
                    </div>
                    <div class="col-md-4">
                        <small class="text-muted">
                            <i class="fas fa-store"></i> Marketplace: <strong id="dash-marketplace">-</strong> publicaciones
                        </small>
                    </div>
                    <div class="col-md-4">
                        <small class="text-muted">
                            <i class="fas fa-clock"></i> Última actualización: <strong id="dash-ultima-sync">-</strong>
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Tarjetas de Estado -->
    <div class="col-12 mb-4">
        <div class="row">
            <!-- Solicitudes VIP NUEVA TARJETA -->
            <div class="col-md-2 mb-3">
                <div class="card border-left-danger h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                    <i class="fas fa-bell"></i> Solicitudes VIP
                                </div>
                                <div id="solicitudes-status" class="h5 mb-0">
                                    <span class="badge bg-danger" id="solicitudes-count">0</span>
                                </div>
                                <small class="text-muted">Pendientes</small>
                            </div>
                            <div class="text-danger opacity-50">
                                <i class="fas fa-user-plus fa-3x"></i>
                            </div>
                        </div>
                        <button class="btn btn-sm btn-danger w-100 mt-2" onclick="verSolicitudesVIP()">
                            <i class="fas fa-eye"></i> Ver Todas
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-md-2 mb-3">
                <div class="card border-left-primary h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    <i class="fas fa-robot"></i> Monitor ScaWatt
                                </div>
                                <div id="monitor-status" class="h5 mb-0">
                                    <span class="badge bg-secondary">Cargando...</span>
                                </div>
                                <small class="text-muted" id="monitor-uptime">-</small>
                            </div>
                            <div class="text-primary opacity-50">
                                <i class="fas fa-server fa-3x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-2 mb-3">
                <div class="card border-left-success h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    <i class="fas fa-sync-alt"></i> Sincronización
                                </div>
                                <div id="sync-status" class="h5 mb-0">
                                    <span class="badge bg-secondary">Cargando...</span>
                                </div>
                                <small class="text-muted" id="sync-last">-</small>
                            </div>
                            <div class="text-success opacity-50">
                                <i class="fas fa-exchange-alt fa-3x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-2 mb-3">
                <div class="card border-left-warning h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    <i class="fas fa-calendar-alt"></i> Tareas Cron
                                </div>
                                <div id="cron-status" class="h5 mb-0">
                                    <span class="badge bg-secondary">Cargando...</span>
                                </div>
                                <small class="text-muted" id="cron-count">-</small>
                            </div>
                            <div class="text-warning opacity-50">
                                <i class="fas fa-tasks fa-3x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-2 mb-3">
                <div class="card border-left-info h-100 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    <i class="fas fa-database"></i> MySQL
                                </div>
                                <div id="mysql-status" class="h5 mb-0">
                                    <span class="badge bg-secondary">Cargando...</span>
                                </div>
                                <small class="text-muted" id="mysql-connections">-</small>
                            </div>
                            <div class="text-info opacity-50">
                                <i class="fas fa-database fa-3x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Métricas del Sistema -->
    <div class="col-12 mb-4">
        <div class="card shadow-sm">
            <div class="card-header bg-gradient-primary text-white">
                <h6 class="mb-0"><i class="fas fa-chart-bar"></i> Métricas del Sistema en Tiempo Real</h6>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-md-2">
                        <div class="metric-box">
                            <i class="fas fa-solar-panel text-warning fa-2x mb-2"></i>
                            <h4 class="mb-0" id="metric-scawatts">-</h4>
                            <small class="text-muted">ScaWatts Total</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="metric-box">
                            <i class="fas fa-users text-primary fa-2x mb-2"></i>
                            <h4 class="mb-0" id="metric-usuarios">-</h4>
                            <small class="text-muted">Usuarios</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="metric-box">
                            <i class="fas fa-industry text-success fa-2x mb-2"></i>
                            <h4 class="mb-0" id="metric-granjas">-</h4>
                            <small class="text-muted">Granjas</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="metric-box">
                            <i class="fas fa-store text-info fa-2x mb-2"></i>
                            <h4 class="mb-0" id="metric-marketplace">-</h4>
                            <small class="text-muted">En Venta</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="metric-box">
                            <i class="fas fa-chart-line text-success fa-2x mb-2"></i>
                            <h4 class="mb-0" id="metric-valorizacion">-</h4>
                            <small class="text-muted">Valorización</small>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="metric-box">
                            <i class="fas fa-bolt text-danger fa-2x mb-2"></i>
                            <h4 class="mb-0" id="metric-energia">-</h4>
                            <small class="text-muted">Capacidad MW</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Información Servidor -->
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="mb-0"><i class="fas fa-info-circle"></i> Información del Servidor</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Servidor:</strong> <span id="servidor-name">-</span></p>
                        <p><strong>Usuario:</strong> <span id="servidor-user">-</span></p>
                        <p><strong>Última actualización:</strong> <span id="servidor-time">-</span></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Uptime:</strong> <span id="servidor-uptime">-</span></p>
                        <p><strong>PHP:</strong> <span id="php-version">-</span></p>
                        <p><strong>Laravel:</strong> <span id="laravel-version">-</span></p>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-12">
                        <p class="mb-0"><strong>Estado general:</strong> <span id="estado-general">-</span></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Logs de Procesos -->
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <h6 class="mb-0"><i class="fas fa-terminal"></i> Procesos en Ejecución</h6>
                <button class="btn btn-sm btn-outline-primary" onclick="location.reload()">
                    <i class="fas fa-sync-alt"></i> Actualizar
                </button>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Proceso</th>
                                <th>Estado</th>
                                <th>Última verificación</th>
                                <th>Acción</th>
                            </tr>
                        </thead>
                        <tbody id="procesos-table">
                            <tr>
                                <td colspan="4" class="text-center text-muted">Cargando datos...</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Archivos Recientes -->
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="mb-0"><i class="fas fa-files"></i> Archivos Monitoreados</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>base_ScaWatt_2025.json</strong></p>
                        <p class="text-muted small">Ubicación: <code>/home/scalarapp/scalar-data/scawatt-server/base_ScaWatt_2025.json</code></p>
                        <p id="file-base-status">Verificando...</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>ScaWatt.json (Público)</strong></p>
                        <p class="text-muted small">Ubicación: <code>/home/scalarapp/public_html/develop/code-test/ScaWatt.json</code></p>
                        <p id="file-public-status">Verificando...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Documentación API Endpoints -->
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="mb-0"><i class="fas fa-code"></i> API Endpoints - Documentación Completa</h6>
                    <small>80+ endpoints disponibles | Última actualización: 26 Oct 2025</small>
                </div>
                <button class="btn btn-sm btn-light" onclick="toggleAllCategories()">
                    <i class="fas fa-list"></i> Expandir/Contraer Todo
                </button>
            </div>
            <div class="card-body">
                <!-- Banner de Novedades -->
                <div class="alert alert-success mb-4">
                    <h6 class="alert-heading"><i class="fas fa-star"></i> 🆕 Novedades Implementadas Hoy (26 Oct 2025)</h6>
                    <hr>
                    <div class="row">
                        <div class="col-md-4">
                            <strong>📊 Trazabilidad de ScaWatts</strong>
                            <ul class="mb-0 mt-2">
                                <li>Historial completo por serial</li>
                                <li>Todos los ScaWatts de un usuario</li>
                                <li>Reporte global de administrador</li>
                                <li>Registro automático en cada venta</li>
                            </ul>
                        </div>
                        <div class="col-md-4">
                            <strong>🏦 Datos Bancarios de Usuarios</strong>
                            <ul class="mb-0 mt-2">
                                <li>Banco, tipo y número de cuenta</li>
                                <li>Subida de certificados (PDF/IMG)</li>
                                <li>Verificación por administrador</li>
                                <li>Seguridad: cuenta parcial (****5678)</li>
                            </ul>
                        </div>
                        <div class="col-md-4">
                            <strong>� Fotos de Cédula (KYC)</strong>
                            <ul class="mb-0 mt-2">
                                <li>Upload frente + atrás de cédula</li>
                                <li>Formatos: PNG, JPG, JPEG, HEIC</li>
                                <li>Verificación por administrador</li>
                                <li>URLs públicas para visualización</li>
                            </ul>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-4">
                            <strong>�👤 CRUD de Usuarios</strong>
                            <ul class="mb-0 mt-2">
                                <li>Ver perfil con estadísticas</li>
                                <li>Editar datos personales</li>
                                <li>Separación usuario/admin</li>
                                <li>Protección de campos sensibles</li>
                            </ul>
                        </div>
                        <div class="col-md-8">
                            <span class="badge bg-success me-2">+16 endpoints nuevos</span>
                            <span class="badge bg-info me-2">8 campos en DB</span>
                            <span class="badge bg-warning me-2">4 sistemas completos</span>
                            <span class="badge bg-primary">100% documentado</span>
                        </div>
                    </div>
                </div>
                <!-- Autenticación -->
                <div class="endpoint-category mb-3">
                    <button class="btn btn-link w-100 text-start fw-bold" data-bs-toggle="collapse" data-bs-target="#cat-auth">
                        <i class="fas fa-chevron-right"></i> 🔐 Autenticación (7 endpoints)
                    </button>
                    <div class="collapse" id="cat-auth">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 100px">Método</th>
                                        <th>Endpoint</th>
                                        <th>Descripción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/auth/login</code></td>
                                        <td>Login con email y contraseña</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/auth/register</code></td>
                                        <td>Registro de nuevo usuario</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/auth/google</code></td>
                                        <td>Autenticación con Google OAuth</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/auth/logout</code></td>
                                        <td>Cerrar sesión (requiere auth)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/auth/user</code></td>
                                        <td>Obtener datos del usuario autenticado</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/auth/forgot-password</code></td>
                                        <td>Solicitar recuperación de contraseña</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/auth/reset-password</code></td>
                                        <td>Restablecer contraseña con token</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Usuarios -->
                <div class="endpoint-category mb-3">
                    <button class="btn btn-link w-100 text-start fw-bold" data-bs-toggle="collapse" data-bs-target="#cat-usuarios">
                        <i class="fas fa-chevron-right"></i> 👥 Usuarios (17 endpoints) 🆕
                    </button>
                    <div class="collapse" id="cat-usuarios">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 100px">Método</th>
                                        <th>Endpoint</th>
                                        <th>Descripción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="3" class="bg-dark text-white fw-bold">
                                            <i class="fas fa-user"></i> PERFIL DE USUARIO (Auto-gestión)
                                        </td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/usuarios/{id}/perfil</code></td>
                                        <td>🆕 Ver perfil completo con estadísticas y datos bancarios</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/usuarios/{id}/perfil</code></td>
                                        <td>🆕 Editar perfil propio (nombre, email, teléfono, cédula, foto)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/usuarios/{id}</code></td>
                                        <td>Obtener perfil de usuario por ID</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/usuarios/{id}</code></td>
                                        <td>Actualizar datos de usuario</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" class="bg-dark text-white fw-bold">
                                            <i class="fas fa-university"></i> DATOS BANCARIOS
                                        </td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/usuarios/{id}/datos-bancarios</code></td>
                                        <td>🆕 Ver datos bancarios (cuenta parcial: ****5678)</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/usuarios/{id}/datos-bancarios</code></td>
                                        <td>🆕 Actualizar datos bancarios + subir certificado (PDF/IMG)</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/usuarios/{id}/certificado-bancario</code></td>
                                        <td>🆕 Descargar certificado bancario (PDF, PNG, JPG, HEIC)</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/admin/usuarios/{id}/verificar-datos-bancarios</code></td>
                                        <td>🆕 Verificar datos bancarios (admin, registra en auditoría)</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" class="bg-dark text-white fw-bold">
                                            <i class="fas fa-id-card"></i> FOTOS DE CÉDULA (KYC)
                                        </td>
                                    </tr>
                                    <tr class="table-info">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/usuarios/{id}/cedula-fotos</code></td>
                                        <td>🆕 Obtener URLs y estado de verificación de fotos de cédula</td>
                                    </tr>
                                    <tr class="table-info">
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/usuarios/{id}/cedula-fotos</code></td>
                                        <td>🆕 Subir fotos de cédula (frente + atrás, multipart/form-data)</td>
                                    </tr>
                                    <tr class="table-info">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/usuarios/{id}/cedula-foto/{tipo}</code></td>
                                        <td>🆕 Descargar foto específica (tipo: frente o atras)</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/admin/usuarios/{id}/verificar-cedula</code></td>
                                        <td>🆕 Verificar fotos de cédula (admin, registra en auditoría)</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" class="bg-dark text-white fw-bold">
                                            <i class="fas fa-mobile-alt"></i> NOTIFICACIONES PUSH
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/usuarios/{id}/register-token</code></td>
                                        <td>Registrar FCM token para push notifications</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-danger">DELETE</span></td>
                                        <td><code>/api/usuarios/{id}/unregister-token</code></td>
                                        <td>Eliminar FCM token (logout de notificaciones)</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" class="bg-dark text-white fw-bold">
                                            <i class="fas fa-wallet"></i> DATOS FINANCIEROS
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/usuarios/{id}/scawatts</code></td>
                                        <td>Obtener ScaWatts del usuario</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/usuarios/{id}/transacciones</code></td>
                                        <td>Historial de transacciones del usuario</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/usuarios/{id}/saldo</code></td>
                                        <td>Consultar saldo disponible</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/usuarios/{id}/actualizar-saldo</code></td>
                                        <td>Actualizar saldo de usuario (admin)</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" class="bg-light">
                                            <small><strong>📋 Campos Editables por Usuario:</strong> nombre, email, teléfono, cédula, picture<br>
                                            <strong>🔒 Campos Protegidos:</strong> saldos, estado, id_wordpress, fechas del sistema<br>
                                            <strong>🏦 Datos Bancarios:</strong> banco, tipo_cuenta (ahorros/corriente), numero_cuenta, certificado (max 5MB)<br>
                                            <strong>📸 Fotos de Cédula:</strong> cedula_frente, cedula_atras (PNG/JPG/JPEG/HEIC, max 5MB c/u), verificación admin<br>
                                            <strong>✅ Seguridad:</strong> Solo muestra últimos 4 dígitos de cuenta (****5678), verificación admin requerida</small>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- ScaWatts -->
                <div class="endpoint-category mb-3">
                    <button class="btn btn-link w-100 text-start fw-bold" data-bs-toggle="collapse" data-bs-target="#cat-scawatts">
                        <i class="fas fa-chevron-right"></i> ⚡ ScaWatts (16 endpoints)
                    </button>
                    <div class="collapse" id="cat-scawatts">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 100px">Método</th>
                                        <th>Endpoint</th>
                                        <th>Descripción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/public/scawatts</code></td>
                                        <td>Listado público de ScaWatts</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/scawatts</code></td>
                                        <td>Listado completo de ScaWatts (admin)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/admin/scawatts/crear</code></td>
                                        <td>Crear nuevo ScaWatt con granja_id, usuario_id, valor_inicial</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/scawatts/estadisticas</code></td>
                                        <td>Estadísticas generales del sistema (total, valorización, etc.)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/scawatts/sync</code></td>
                                        <td>Sincronizar datos con sistema de producción Python</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/scawatts/{id}</code></td>
                                        <td>Detalles de un ScaWatt específico por ID</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/scawatts/{id}</code></td>
                                        <td>Actualizar datos de ScaWatt</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-danger">DELETE</span></td>
                                        <td><code>/api/scawatts/{id}</code></td>
                                        <td>Eliminar ScaWatt (soft delete)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/scawatts/usuario/{id}</code></td>
                                        <td>Obtener todos los ScaWatts de un usuario específico</td>
                                    </tr>
                                    <tr class="table-warning">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/scawatts/{id}/proyeccion</code></td>
                                        <td>🆕 Proyección financiera futura con años restantes y ROI estimado</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/scawatts/{serial}/valorizacion</code></td>
                                        <td>Obtener valorización actual por serial (formato SCA-XXXX-XXXX)</td>
                                    </tr>
                                    <tr class="table-warning">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/usuarios/{id}/scawatts/estadisticas</code></td>
                                        <td>🆕 Estadísticas de ScaWatts del usuario (total invertido, valorización)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/scawatts/{id}/valorizaciones</code></td>
                                        <td>Historial completo de valorizaciones del ScaWatt</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/scawatts/{id}/transferir</code></td>
                                        <td>Transferir ScaWatt a otro usuario</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/scawatts/{id}/valorizar</code></td>
                                        <td>Crear nueva valorización manual para ScaWatt (admin)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/scawatts/{id}/historial</code></td>
                                        <td>Historial completo de transacciones y eventos</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Granjas Solares -->
                <div class="endpoint-category mb-3">
                    <button class="btn btn-link w-100 text-start fw-bold" data-bs-toggle="collapse" data-bs-target="#cat-granjas">
                        <i class="fas fa-chevron-right"></i> 🏭 Granjas Solares (8 endpoints)
                    </button>
                    <div class="collapse" id="cat-granjas">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 100px">Método</th>
                                        <th>Endpoint</th>
                                        <th>Descripción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/granjas</code></td>
                                        <td>🆕 Listar todas las granjas solares (público)</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/granjas/{id}</code></td>
                                        <td>🆕 Detalles de granja específica con ScaWatts asociados</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/granjas/categorias</code></td>
                                        <td>🆕 Listar categorías disponibles (granja_solar, parque_solar, etc.)</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/granjas/departamentos</code></td>
                                        <td>🆕 Listar departamentos únicos con granjas</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/admin/granjas</code></td>
                                        <td>🆕 Crear nueva granja solar (admin)</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/admin/granjas/{id}</code></td>
                                        <td>🆕 Actualizar datos de granja (admin)</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/granjas/estadisticas</code></td>
                                        <td>🆕 Estadísticas completas (capacidad total, por departamento, etc.)</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" class="bg-light">
                                            <small><strong>Campos de Granja:</strong> nombre, categoria, departamento, municipio, capacidad_mw, 
                                            vida_util_años (25), tasa_valorizacion_anual (3.5%), ganancia_mensual_base (696700), 
                                            fecha_inicio_operacion, estado (operativa/construccion/planificada)</small>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Transacciones -->
                <div class="endpoint-category mb-3">
                    <button class="btn btn-link w-100 text-start fw-bold" data-bs-toggle="collapse" data-bs-target="#cat-transacciones">
                        <i class="fas fa-chevron-right"></i> 💰 Transacciones (6 endpoints)
                    </button>
                    <div class="collapse" id="cat-transacciones">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 100px">Método</th>
                                        <th>Endpoint</th>
                                        <th>Descripción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/transacciones/deposito</code></td>
                                        <td>Registrar depósito de fondos</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/transacciones/retiro</code></td>
                                        <td>Solicitar retiro de fondos</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/transacciones/{id}</code></td>
                                        <td>Detalles de transacción específica</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/transacciones/{id}/aprobar</code></td>
                                        <td>Aprobar transacción pendiente (admin)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/transacciones/{id}/rechazar</code></td>
                                        <td>Rechazar transacción pendiente (admin)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/transacciones/{usuarioId}/historial</code></td>
                                        <td>Historial completo de transacciones</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Marketplace -->
                <div class="endpoint-category mb-3">
                    <button class="btn btn-link w-100 text-start fw-bold" data-bs-toggle="collapse" data-bs-target="#cat-marketplace">
                        <i class="fas fa-chevron-right"></i> 🛒 Marketplace P2P (11 endpoints)
                    </button>
                    <div class="collapse" id="cat-marketplace">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 100px">Método</th>
                                        <th>Endpoint</th>
                                        <th>Descripción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/marketplace</code></td>
                                        <td>Listar publicaciones disponibles (estado='en_venta')</td>
                                    </tr>
                                    <tr class="table-warning">
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/marketplace/publicar</code></td>
                                        <td>🔥 Publicar ScaWatt en marketplace (scawatt_serial o scawatt_id, precio_venta)</td>
                                    </tr>
                                    <tr class="table-warning">
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/marketplace/{id}/retirar</code></td>
                                        <td>🔥 Retirar publicación del marketplace</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/marketplace/{id}</code></td>
                                        <td>Detalles de publicación específica</td>
                                    </tr>
                                    <tr class="table-warning">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/marketplace/debug/seriales-disponibles/{usuarioId}</code></td>
                                        <td>🆕 Debug: Ver qué ScaWatts puede publicar un usuario</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/marketplace/{id}/comprar</code></td>
                                        <td>Comprar ScaWatt publicado (requiere saldo suficiente)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/marketplace/mis-publicaciones</code></td>
                                        <td>Publicaciones del usuario autenticado</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/marketplace/mis-compras</code></td>
                                        <td>Historial de compras del usuario</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/marketplace/estadisticas</code></td>
                                        <td>Estadísticas del marketplace (volumen, precio promedio)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/admin/marketplace/productos</code></td>
                                        <td>Crear producto canjeabl e con ScaWatts (admin)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/admin/marketplace/productos/{id}</code></td>
                                        <td>Actualizar producto canjeable (admin)</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" class="bg-light">
                                            <small><strong>Estados de Publicación:</strong> en_venta, vendido, cancelado<br>
                                            <strong>Estados de ScaWatt:</strong> activo, marketplace, vendido, finalizado</small>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Trazabilidad ScaWatts -->
                <div class="endpoint-category mb-3">
                    <button class="btn btn-link w-100 text-start fw-bold" data-bs-toggle="collapse" data-bs-target="#cat-trazabilidad">
                        <i class="fas fa-chevron-right"></i> 📊 Trazabilidad de ScaWatts (3 endpoints) 🆕
                    </button>
                    <div class="collapse" id="cat-trazabilidad">
                        <div class="alert alert-info mb-3">
                            <i class="fas fa-info-circle"></i> <strong>Sistema de Trazabilidad:</strong> 
                            Registra automáticamente cada transacción de marketplace incluyendo fechas, precios, 
                            compradores/vendedores y calcula ganancias/pérdidas de cada propietario.
                        </div>
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 100px">Método</th>
                                        <th>Endpoint</th>
                                        <th>Descripción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/marketplace/trazabilidad/{serial}</code></td>
                                        <td>🆕 Historial completo de un ScaWatt específico (todos los dueños, precios, fechas)</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/marketplace/trazabilidad/usuario/{usuarioId}</code></td>
                                        <td>🆕 Todos los ScaWatts que ha tenido un usuario (ganancia/pérdida por cada uno)</td>
                                    </tr>
                                    <tr class="table-success">
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/marketplace/trazabilidad/reporte</code></td>
                                        <td>🆕 Reporte global de administrador con estadísticas completas</td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" class="bg-light">
                                            <small>
                                                <strong>📌 Datos de Trazabilidad:</strong><br>
                                                • <strong>Propietarios:</strong> usuario_id, nombre, fecha_compra, precio_compra, fecha_venta, precio_venta, ganancia_cop, ganancia_porcentaje<br>
                                                • <strong>Eventos:</strong> fecha, tipo (creacion/venta/compra), vendedor, comprador, precio<br>
                                                • <strong>Estadísticas:</strong> total_transferencias, precio_minimo, precio_maximo, precio_promedio, ganancia_total_sistema<br>
                                                • <strong>Actualización:</strong> Automática en cada venta de marketplace (sin interrumpir transacción)<br>
                                                • <strong>Archivo:</strong> /scalar-data/scawatt-server/produccion-scawatts/data_scawatts/raiz-scawatt/trazabilidad_scawatts.json
                                            </small>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="card bg-dark text-white mt-3">
                            <div class="card-header">
                                <strong><i class="fas fa-code"></i> Ejemplo: Ver historial de ScaWatt</strong>
                            </div>
                            <div class="card-body">
                                <pre class="text-white mb-0"><code>curl -X GET "https://escalar.app/scadmin/backend/public/api/marketplace/trazabilidad/SCA-0D6D-6AE8-7065"</code></pre>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Notificaciones -->
                <div class="endpoint-category mb-3">
                    <button class="btn btn-link w-100 text-start fw-bold" data-bs-toggle="collapse" data-bs-target="#cat-notificaciones">
                        <i class="fas fa-chevron-right"></i> 🔔 Notificaciones Push (8 endpoints)
                    </button>
                    <div class="collapse" id="cat-notificaciones">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 100px">Método</th>
                                        <th>Endpoint</th>
                                        <th>Descripción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/notificaciones/{usuarioId}</code></td>
                                        <td>Listar notificaciones del usuario</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/admin/notificaciones/{usuarioId}</code></td>
                                        <td>Enviar notificación individual con push</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/admin/notificaciones/masiva</code></td>
                                        <td>Enviar notificación masiva con push</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/notificaciones/{id}/leer</code></td>
                                        <td>Marcar notificación como leída</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/notificaciones/{usuarioId}/leer-todas</code></td>
                                        <td>Marcar todas como leídas</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/notificaciones/{usuarioId}/no-leidas</code></td>
                                        <td>Contar notificaciones no leídas</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-danger">DELETE</span></td>
                                        <td><code>/api/notificaciones/{id}</code></td>
                                        <td>Eliminar notificación</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/mensajes</code></td>
                                        <td>Listar mensajes broadcast (admin)</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Mensajería -->
                <div class="endpoint-category mb-3">
                    <button class="btn btn-link w-100 text-start fw-bold" data-bs-toggle="collapse" data-bs-target="#cat-mensajes">
                        <i class="fas fa-chevron-right"></i> 📧 Mensajería Broadcast (9 endpoints)
                    </button>
                    <div class="collapse" id="cat-mensajes">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 100px">Método</th>
                                        <th>Endpoint</th>
                                        <th>Descripción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/admin/mensajes/broadcast</code></td>
                                        <td>Crear mensaje broadcast (todos/grupo/individual)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/mensajes/{id}</code></td>
                                        <td>Ver detalles de mensaje broadcast</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-danger">DELETE</span></td>
                                        <td><code>/api/admin/mensajes/{id}</code></td>
                                        <td>Eliminar mensaje broadcast</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/mensajes/{usuarioId}/bandeja-entrada</code></td>
                                        <td>Bandeja de entrada del usuario</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/mensajes/{usuarioId}/enviados</code></td>
                                        <td>Mensajes enviados por el usuario</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/mensajes</code></td>
                                        <td>Enviar mensaje 1-a-1</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/mensajes/{id}</code></td>
                                        <td>Ver mensaje específico</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/mensajes/{id}/leer</code></td>
                                        <td>Marcar mensaje como leído</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/mensajes/{usuarioId}/no-leidos</code></td>
                                        <td>Contar mensajes no leídos</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Configuración -->
                <div class="endpoint-category mb-3">
                    <button class="btn btn-link w-100 text-start fw-bold" data-bs-toggle="collapse" data-bs-target="#cat-config">
                        <i class="fas fa-chevron-right"></i> ⚙️ Configuración Sistema (9 endpoints)
                    </button>
                    <div class="collapse" id="cat-config">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 100px">Método</th>
                                        <th>Endpoint</th>
                                        <th>Descripción</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/configuracion</code></td>
                                        <td>Ver toda la configuración</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/configuracion/grupos</code></td>
                                        <td>Listar grupos de configuración</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/configuracion/grupo/{grupo}</code></td>
                                        <td>Config por grupo (sistema, valorización, etc.)</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/admin/configuracion/{clave}</code></td>
                                        <td>Obtener valor de configuración específica</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-success">POST</span></td>
                                        <td><code>/api/admin/configuracion</code></td>
                                        <td>Crear nueva configuración</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/admin/configuracion/{clave}</code></td>
                                        <td>Actualizar configuración</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-warning">PUT</span></td>
                                        <td><code>/api/admin/configuracion/actualizar-multiple</code></td>
                                        <td>Actualizar múltiples configs a la vez</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-danger">DELETE</span></td>
                                        <td><code>/api/admin/configuracion/{clave}</code></td>
                                        <td>Eliminar configuración</td>
                                    </tr>
                                    <tr>
                                        <td><span class="badge bg-info">GET</span></td>
                                        <td><code>/api/monitor/procesos</code></td>
                                        <td>Estado de procesos del sistema (monitor)</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="alert alert-info mt-3">
                    <strong><i class="fas fa-info-circle"></i> Nota:</strong>
                    Todos los endpoints de administración (<code>/api/admin/*</code>) requieren permisos de administrador.
                    Los endpoints de usuario requieren autenticación vía API token.
                    <br><strong>Base URL:</strong> <code>https://escalar.app/scadmin/backend/public/api</code>
                </div>
            </div>
        </div>
    </div>

    <!-- Documentación Interactiva -->
    <div class="col-12 mt-4">
        <div class="card shadow-sm">
            <div class="card-header bg-dark text-white">
                <h6 class="mb-0"><i class="fas fa-terminal"></i> Ejemplos de Uso - Testing API</h6>
            </div>
            <div class="card-body">
                <div class="accordion" id="ejemplosAccordion">
                    
                    <!-- Ejemplo 1: Crear ScaWatt -->
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ejemplo1">
                                <i class="fas fa-code text-success me-2"></i> Crear ScaWatt con Granja Asignada
                            </button>
                        </h2>
                        <div id="ejemplo1" class="accordion-collapse collapse" data-bs-parent="#ejemplosAccordion">
                            <div class="accordion-body">
                                <h6 class="fw-bold">Request:</h6>
                                <pre class="bg-dark text-white p-3 rounded"><code>curl -X POST "https://escalar.app/scadmin/api/admin/scawatts/crear" \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -d '{
  "usuario_id": 1,
  "granja_id": 1,
  "valor_inicial": 40000000,
  "fecha_inicio": "2025-10-24",
  "años_contrato": 25,
  "kwh_asignados": 1000,
  "tipo": "normal"
}'</code></pre>
                                <h6 class="fw-bold mt-3">Response (201 Created):</h6>
                                <pre class="bg-light p-3 rounded"><code>{
  "success": true,
  "message": "ScaWatt creado exitosamente",
  "scawatt": {
    "scawatt_id": "SCA-XXXX-XXXX-XXXX",
    "scawatt_serial": "SCA-XXXX-XXXX-XXXX",
    "valor_inicial": 40000000,
    "valorizacion": 0,
    "fecha_inicio": "2025-10-24",
    "fecha_final": "2050-10-23",
    "estado": "activo",
    "granja_id": 1
  }
}</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Ejemplo 2: Proyección de ScaWatt -->
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ejemplo2">
                                <i class="fas fa-chart-line text-warning me-2"></i> Obtener Proyección de Valorización
                            </button>
                        </h2>
                        <div id="ejemplo2" class="accordion-collapse collapse" data-bs-parent="#ejemplosAccordion">
                            <div class="accordion-body">
                                <h6 class="fw-bold">Request:</h6>
                                <pre class="bg-dark text-white p-3 rounded"><code>curl -X GET "https://escalar.app/scadmin/api/scawatts/1/proyeccion?años=10" \
  -H "Accept: application/json"</code></pre>
                                <h6 class="fw-bold mt-3">Response (200 OK):</h6>
                                <pre class="bg-light p-3 rounded"><code>{
  "success": true,
  "scawatt": {
    "id": 1,
    "scawatt_id": "SCA-0D6D-6AE8-7065",
    "valor_inicial": 40000000,
    "valor_actual": 41232538.45
  },
  "granja": {
    "nombre": "Granja Solar La Gloria",
    "departamento": "Cesar",
    "años_restantes": 24.76,
    "tasa_valorizacion_anual": "3.50%"
  },
  "proyeccion": {
    "años_proyectados": "10",
    "valor_final_estimado": 141934491.10,
    "ganancia_futura_estimada": 100702338.51,
    "roi_final_porcentaje": 254.84,
    "detalle_anual": [...]
  }
}</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Ejemplo 3: Publicar en Marketplace -->
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ejemplo3">
                                <i class="fas fa-store text-info me-2"></i> Publicar ScaWatt en Marketplace
                            </button>
                        </h2>
                        <div id="ejemplo3" class="accordion-collapse collapse" data-bs-parent="#ejemplosAccordion">
                            <div class="accordion-body">
                                <h6 class="fw-bold">Request:</h6>
                                <pre class="bg-dark text-white p-3 rounded"><code>curl -X POST "https://escalar.app/scadmin/api/marketplace/publicar" \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -d '{
  "scawatt_serial": "SCA-0D6D-6AE8-7065",
  "precio_venta": 45000000
}'</code></pre>
                                <h6 class="fw-bold mt-3">Response (201 Created):</h6>
                                <pre class="bg-light p-3 rounded"><code>{
  "success": true,
  "message": "ScaWatt publicado en el marketplace",
  "publicacion": {
    "id": 6,
    "scawatt_id": 1,
    "usuario_id": 2,
    "precio_venta": 45000000,
    "estado": "en_venta",
    "fecha_publicacion": "2025-10-24T15:30:00.000000Z"
  }
}</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Ejemplo 4: Crear Granja -->
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ejemplo4">
                                <i class="fas fa-industry text-success me-2"></i> Crear Nueva Granja Solar
                            </button>
                        </h2>
                        <div id="ejemplo4" class="accordion-collapse collapse" data-bs-parent="#ejemplosAccordion">
                            <div class="accordion-body">
                                <h6 class="fw-bold">Request:</h6>
                                <pre class="bg-dark text-white p-3 rounded"><code>curl -X POST "https://escalar.app/scadmin/api/admin/granjas" \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer ADMIN_TOKEN" \
  -d '{
  "nombre": "Parque Solar Guajira",
  "categoria": "parque_solar",
  "departamento": "La Guajira",
  "municipio": "Uribia",
  "capacidad_mw": 2.5,
  "vida_util_años": 25,
  "fecha_inicio_operacion": "2026-01-01",
  "tasa_valorizacion_anual": 3.5,
  "ganancia_mensual_base": 696700,
  "estado": "construccion"
}'</code></pre>
                                <h6 class="fw-bold mt-3">Response (201 Created):</h6>
                                <pre class="bg-light p-3 rounded"><code>{
  "success": true,
  "message": "Granja creada exitosamente",
  "granja": {
    "id": 2,
    "nombre": "Parque Solar Guajira",
    "categoria": "parque_solar",
    "departamento": "La Guajira",
    "capacidad_mw": 2.5,
    "años_restantes": 25,
    "estado": "construccion"
  }
}</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Ejemplo 5: Estadísticas -->
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ejemplo5">
                                <i class="fas fa-chart-bar text-primary me-2"></i> Obtener Estadísticas del Sistema
                            </button>
                        </h2>
                        <div id="ejemplo5" class="accordion-collapse collapse" data-bs-parent="#ejemplosAccordion">
                            <div class="accordion-body">
                                <h6 class="fw-bold">Request:</h6>
                                <pre class="bg-dark text-white p-3 rounded"><code>curl -X GET "https://escalar.app/scadmin/api/admin/scawatts/estadisticas" \
  -H "Authorization: Bearer ADMIN_TOKEN"</code></pre>
                                <h6 class="fw-bold mt-3">Response (200 OK):</h6>
                                <pre class="bg-light p-3 rounded"><code>{
  "total_scawatts": 5,
  "scawatts_activos": 3,
  "scawatts_marketplace": 2,
  "usuarios_con_scawatts": 3,
  "valor_total_invertido": 200000000,
  "valor_total_actual": 206162692.25,
  "valorizacion_total_cop": 6162692.25,
  "valoracion_porcentaje": 3.08
}</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Ejemplo 6: Ver Perfil Usuario -->
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ejemplo6">
                                <i class="fas fa-user text-info me-2"></i> Ver Perfil Completo de Usuario 🆕
                            </button>
                        </h2>
                        <div id="ejemplo6" class="accordion-collapse collapse" data-bs-parent="#ejemplosAccordion">
                            <div class="accordion-body">
                                <h6 class="fw-bold">Request:</h6>
                                <pre class="bg-dark text-white p-3 rounded"><code>curl -X GET "https://escalar.app/scadmin/backend/public/api/usuarios/2/perfil"</code></pre>
                                <h6 class="fw-bold mt-3">Response (200 OK):</h6>
                                <pre class="bg-light p-3 rounded"><code>{
  "success": true,
  "usuario": {
    "id": 2,
    "nombre": "Daniel Ortiz Penagos",
    "email": "daniel.ortiz.penagos@me.com",
    "telefono": "+573005468656",
    "saldo_disponible": "100600000.00",
    "estadisticas": {
      "total_scawatts": 2,
      "scawatts_activos": 2,
      "valor_total_scawatts": "81381414.78",
      "retiros_pendientes": 0,
      "depositos_aprobados": 3
    },
    "datos_bancarios": {
      "tiene_datos_bancarios": false,
      "banco": null,
      "verificado": false
    }
  }
}</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Ejemplo 7: Actualizar Datos Bancarios -->
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ejemplo7">
                                <i class="fas fa-university text-success me-2"></i> Actualizar Datos Bancarios + Certificado 🆕
                            </button>
                        </h2>
                        <div id="ejemplo7" class="accordion-collapse collapse" data-bs-parent="#ejemplosAccordion">
                            <div class="accordion-body">
                                <h6 class="fw-bold">Request (multipart/form-data):</h6>
                                <pre class="bg-dark text-white p-3 rounded"><code>curl -X POST "https://escalar.app/scadmin/backend/public/api/usuarios/2/datos-bancarios" \
  -F "banco=Bancolombia" \
  -F "tipo_cuenta=ahorros" \
  -F "numero_cuenta=12345678901" \
  -F "certificado_bancario=@certificado.pdf"</code></pre>
                                <h6 class="fw-bold mt-3">Response (200 OK):</h6>
                                <pre class="bg-light p-3 rounded"><code>{
  "success": true,
  "message": "Datos bancarios actualizados exitosamente",
  "datos_bancarios": {
    "banco": "Bancolombia",
    "tipo_cuenta": "ahorros",
    "numero_cuenta_parcial": "****8901",
    "tiene_certificado": true,
    "certificado_url": "/storage/certificados-bancarios/2_certificado_1234567890.pdf",
    "verificado": false,
    "updated_at": "2025-10-26T10:30:00.000000Z"
  }
}</code></pre>
                                <div class="alert alert-info mt-3">
                                    <strong><i class="fas fa-info-circle"></i> Formatos aceptados:</strong> 
                                    PDF, PNG, JPG, JPEG, HEIC (iPhone/Mac) • Tamaño máximo: 5MB
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Ejemplo 8: Subir Fotos de Cédula -->
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ejemplo8">
                                <i class="fas fa-id-card text-primary me-2"></i> Subir Fotos de Cédula (KYC) 🆕
                            </button>
                        </h2>
                        <div id="ejemplo8" class="accordion-collapse collapse" data-bs-parent="#ejemplosAccordion">
                            <div class="accordion-body">
                                <h6 class="fw-bold">Request (multipart/form-data):</h6>
                                <pre class="bg-dark text-white p-3 rounded"><code>curl -X POST "https://escalar.app/scadmin/backend/public/api/usuarios/2/cedula-fotos" \
  -F "cedula_frente=@cedula_frente.jpg" \
  -F "cedula_atras=@cedula_atras.jpg"</code></pre>
                                <h6 class="fw-bold mt-3">Response (200 OK):</h6>
                                <pre class="bg-light p-3 rounded"><code>{
  "success": true,
  "message": "Fotos de cédula subidas correctamente",
  "cedula_fotos": {
    "foto_frente_url": "https://escalar.app/scadmin/backend/storage/cedulas/cedula_frente_2_1698340123.jpg",
    "foto_atras_url": "https://escalar.app/scadmin/backend/storage/cedulas/cedula_atras_2_1698340123.jpg",
    "verificado": false,
    "fecha_subida": "2025-10-27T15:30:00.000000Z"
  }
}</code></pre>
                                <div class="alert alert-warning mt-3">
                                    <strong><i class="fas fa-exclamation-triangle"></i> Importante:</strong> 
                                    Ambas fotos (frente y atrás) son obligatorias en el mismo request. Al subir nuevas fotos, las anteriores se eliminan automáticamente.
                                </div>
                                <div class="alert alert-info mt-3">
                                    <strong><i class="fas fa-info-circle"></i> Formatos aceptados:</strong> 
                                    PNG, JPG, JPEG, HEIC (iPhone/Mac) • Tamaño máximo: 5MB por foto
                                </div>
                                <h6 class="fw-bold mt-3">Ver Estado de Fotos:</h6>
                                <pre class="bg-dark text-white p-3 rounded"><code>curl -X GET "https://escalar.app/scadmin/backend/public/api/usuarios/2/cedula-fotos"</code></pre>
                                <pre class="bg-light p-3 rounded"><code>{
  "success": true,
  "data": {
    "tiene_fotos": true,
    "foto_frente_url": "https://...",
    "foto_atras_url": "https://...",
    "verificado": false,
    "fecha_verificacion": null
  }
}</code></pre>
                            </div>
                        </div>
                    </div>

                    <!-- Ejemplo 9: Trazabilidad -->
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ejemplo9">
                                <i class="fas fa-history text-warning me-2"></i> Ver Trazabilidad de ScaWatt 🆕
                            </button>
                        </h2>
                        <div id="ejemplo9" class="accordion-collapse collapse" data-bs-parent="#ejemplosAccordion">
                            <div class="accordion-body">
                                <h6 class="fw-bold">Request:</h6>
                                <pre class="bg-dark text-white p-3 rounded"><code>curl -X GET "https://escalar.app/scadmin/backend/public/api/marketplace/trazabilidad/SCA-0D6D-6AE8-7065"</code></pre>
                                <h6 class="fw-bold mt-3">Response (200 OK):</h6>
                                <pre class="bg-light p-3 rounded"><code>{
  "success": true,
  "scawatt": {
    "serial": "SCA-0D6D-6AE8-7065",
    "estado_actual": "activo"
  },
  "historial_propietarios": [
    {
      "usuario_id": 1,
      "nombre_usuario": "Admin Scalar",
      "fecha_compra": "2025-10-24T00:00:00Z",
      "precio_compra": 40000000,
      "fecha_venta": "2025-10-25T15:30:00Z",
      "precio_venta": 45000000,
      "ganancia_cop": 5000000,
      "ganancia_porcentaje": 12.5,
      "periodo_propiedad_dias": 1.65
    },
    {
      "usuario_id": 2,
      "nombre_usuario": "Daniel Ortiz",
      "fecha_compra": "2025-10-25T15:30:00Z",
      "precio_compra": 45000000,
      "fecha_venta": null,
      "estado": "propietario_actual"
    }
  ],
  "eventos": [
    {
      "fecha": "2025-10-24T00:00:00Z",
      "tipo": "creacion",
      "usuario_id": 1,
      "precio": 40000000
    },
    {
      "fecha": "2025-10-25T15:30:00Z",
      "tipo": "venta",
      "vendedor_id": 1,
      "vendedor_nombre": "Admin Scalar",
      "comprador_id": 2,
      "comprador_nombre": "Daniel Ortiz",
      "precio": 45000000
    }
  ],
  "estadisticas": {
    "total_transferencias": 1,
    "precio_minimo": 40000000,
    "precio_maximo": 45000000,
    "precio_promedio": 42500000
  }
}</code></pre>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="alert alert-dark mt-4 mb-0">
                    <h6 class="fw-bold"><i class="fas fa-lightbulb"></i> Tips para Testing:</h6>
                    <ul class="mb-0">
                        <li>Usa <code>-v</code> con cURL para ver headers completos de respuesta</li>
                        <li>Reemplaza <code>YOUR_TOKEN</code> con un token válido de autenticación</li>
                        <li>Usa herramientas como Postman, Insomnia o Thunder Client para pruebas interactivas</li>
                        <li>Todos los endpoints que modifican datos requieren método <code>POST</code>, <code>PUT</code> o <code>DELETE</code></li>
                        <li>Los endpoints de administración requieren rol <code>admin</code> en el token</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .border-left-primary { border-left: 4px solid #4f46e5 !important; }
    .border-left-success { border-left: 4px solid #10b981 !important; }
    .border-left-warning { border-left: 4px solid #f59e0b !important; }
    .border-left-info { border-left: 4px solid #3b82f6 !important; }
    .border-left-danger { border-left: 4px solid #dc3545 !important; }
    
    .text-primary { color: #4f46e5 !important; }
    .text-success { color: #10b981 !important; }
    .text-warning { color: #f59e0b !important; }
    .text-info { color: #3b82f6 !important; }
    .text-danger { color: #dc3545 !important; }
    
    .opacity-50 { opacity: 0.5; }
    
    .bg-gradient-primary {
        background: linear-gradient(135deg, #4f46e5 0%, #6366f1 100%);
    }
    
    /* Animación de pulso para solicitudes pendientes */
    @keyframes pulse {
        0%, 100% { transform: scale(1); opacity: 1; }
        50% { transform: scale(1.1); opacity: 0.8; }
    }
    
    .pulse {
        animation: pulse 2s infinite;
    }
    
    .metric-box {
        padding: 15px;
        border-radius: 8px;
        transition: all 0.3s ease;
    }
    
    .metric-box:hover {
        background: #f8f9fa;
        transform: translateY(-2px);
    }
    
    .card {
        transition: all 0.3s ease;
    }
    
    .card:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
    }
    
    .endpoint-card {
        border-left: 3px solid #dee2e6;
        transition: all 0.2s ease;
    }
    
    .endpoint-card:hover {
        border-left-color: #4f46e5;
        background: #f8f9fa;
    }
    
    .badge-method {
        font-family: monospace;
        font-weight: 600;
        padding: 4px 8px;
        font-size: 0.75rem;
    }
    
    .endpoint-url {
        font-family: 'Courier New', monospace;
        background: #f8f9fa;
        padding: 8px 12px;
        border-radius: 4px;
        border: 1px solid #dee2e6;
        word-break: break-all;
    }
    
    .status-indicator {
        display: inline-block;
        width: 10px;
        height: 10px;
        border-radius: 50%;
        margin-right: 5px;
    }
    
    .status-ok { background: #10b981; }
    .status-warning { background: #f59e0b; }
    .status-error { background: #ef4444; }
    
    @keyframes pulse {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.5; }
    }
    
    .pulse {
        animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
    }
    
    .code-example {
        background: #1e293b;
        color: #e2e8f0;
        padding: 15px;
        border-radius: 8px;
        font-family: 'Courier New', monospace;
        font-size: 0.875rem;
        overflow-x: auto;
    }
    
    .code-example .keyword { color: #f472b6; }
    .code-example .string { color: #34d399; }
    .code-example .number { color: #fbbf24; }
    .code-example .comment { color: #94a3b8; }
    
    .card {
        transition: all 0.3s ease;
    }
    
    .card:hover {
        transform: translateY(-2px);
    }
    
    .shadow-sm {
        box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075) !important;
    }
    
    .endpoint-category .btn-link {
        text-decoration: none;
        color: #333;
        padding: 12px 15px;
        border: 1px solid #e9ecef;
        border-radius: 6px;
        background: #fff;
        transition: all 0.2s;
    }
    
    .endpoint-category .btn-link:hover {
        background: #f8f9fa;
        border-color: #4f46e5;
    }
    
    .table-warning {
        background-color: #fff3cd !important;
    }
    
    .table-success {
        background-color: #d1e7dd !important;
    }
    
    code {
        background: #f1f3f5;
        padding: 2px 6px;
        border-radius: 4px;
        color: #e03131;
        font-size: 0.9em;
    }
    
    @keyframes pulse {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.5; }
    }
    
    .loading {
        animation: pulse 1.5s ease-in-out infinite;
    }
</style>

<script>
let ultimaActualizacion = new Date();
let monitorSnapshot = null;
let masterToken = localStorage.getItem('scalarMasterToken');
let requestingMasterToken = false;

document.addEventListener('DOMContentLoaded', function() {
    loadMonitorData();
    setInterval(() => loadMonitorData(), 30000);
    setInterval(updateTiempoTranscurrido, 1000);
});

async function ensureMasterToken() {
    if (masterToken && masterToken.trim() !== '') {
        return masterToken;
    }

    if (requestingMasterToken) {
        return null;
    }

    requestingMasterToken = true;
    const tokenIngresado = prompt('Ingresa el token Master para acceder al monitor');
    requestingMasterToken = false;

    if (!tokenIngresado) {
        return null;
    }

    masterToken = tokenIngresado.trim();
    localStorage.setItem('scalarMasterToken', masterToken);

    return masterToken;
}

function clearMasterToken() {
    masterToken = null;
    localStorage.removeItem('scalarMasterToken');
}

function resetMasterToken() {
    clearMasterToken();
    alert('Token Master eliminado. Se solicitará nuevamente al actualizar los datos.');
    loadMonitorData();
}

function updateTiempoTranscurrido() {
    const ahora = new Date();
    const segundos = Math.floor((ahora - ultimaActualizacion) / 1000);
    const bannerTiempo = document.getElementById('banner-tiempo');
    if (bannerTiempo) {
        bannerTiempo.textContent = `Actualizado hace ${segundos}s`;
    }
}

function renderMetricas(metricas = {}) {
    const defaultValue = '-';
    document.getElementById('metric-scawatts').textContent = metricas.scawatts_total ?? defaultValue;
    document.getElementById('metric-usuarios').textContent = metricas.usuarios_con_scawatts ?? metricas.usuarios_total ?? defaultValue;
    document.getElementById('metric-granjas').textContent = metricas.granjas_total ?? defaultValue;

    const publicaciones = metricas.marketplace_en_venta ?? 0;
    document.getElementById('metric-marketplace').textContent = publicaciones;

    const valorizacionTotal = metricas.valorizacion_total ?? 0;
    document.getElementById('metric-valorizacion').textContent =
        valorizacionTotal >= 1_000_000
            ? '$' + (valorizacionTotal / 1_000_000).toFixed(1) + 'M'
            : '$' + Math.round(valorizacionTotal / 1_000) + 'K';

    const capacidad = metricas.capacidad_total_mw ?? 0;
    document.getElementById('metric-energia').textContent = Number(capacidad).toFixed(2);
}

async function loadMonitorData() {
    const apiUrl = `{{ url('/api/monitor/procesos') }}`;

    try {
        const token = await ensureMasterToken();

        if (!token) {
            showBannerError('Token requerido', 'Ingresa el token Master para continuar.');
            return;
        }

        const response = await fetch(apiUrl, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
                'Authorization': `Bearer ${token}`
            }
        });

        if (response.status === 401 || response.status === 403) {
            clearMasterToken();
            throw new Error('Acceso restringido a usuarios Master. Ingresa nuevamente el token.');
        }

        const data = await response.json();

        if (!data.success) {
            throw new Error(data.message || 'Respuesta inválida del monitor');
        }

        monitorSnapshot = data;
        ultimaActualizacion = new Date();

        updateStatusCards(data.procesos, data.detalles, data.dashboard, data.metricas);
        updateServerInfo(data.detalles);
        updateProcessTable(data.procesos);
        updateBanner(data.procesos);
        renderMetricas(data.metricas);
        renderDashboard(data.dashboard);
        renderSolicitudesResumen(data.solicitudes);
    } catch (error) {
        console.error('Error:', error);

        const estadoGeneral = document.getElementById('estado-general');
        if (estadoGeneral) {
            estadoGeneral.innerHTML = '<span class="badge bg-danger">Error de conexión</span>';
        }

        showBannerError('Error de Conexión', error.message || 'No se pudo obtener información del monitor.');

        if (error.message && error.message.includes('Acceso restringido')) {
            alert(error.message);
        }
    }
}

function updateBanner(procesos) {
    const banner = document.getElementById('banner-estado');
    const bannerDetalle = document.getElementById('banner-detalle');
    const todoActivo = Object.values(procesos).every(e => e === 'activo');
    
    if (todoActivo) {
        banner.classList.remove('alert-warning', 'alert-danger');
        banner.classList.add('alert-success');
        banner.querySelector('h5').innerHTML = '✅ Todos los Sistemas Operativos';
        banner.querySelector('i').className = 'fas fa-check-circle fa-2x me-3';
        bannerDetalle.textContent = 'Monitor activo, sincronización OK, base de datos conectada, tareas cron funcionando';
    } else {
        banner.classList.remove('alert-success');
        banner.classList.add('alert-warning');
        banner.querySelector('h5').innerHTML = '⚠️ Atención Requerida';
        banner.querySelector('i').className = 'fas fa-exclamation-triangle fa-2x me-3';
        const inactivos = Object.keys(procesos).filter(k => procesos[k] !== 'activo');
        bannerDetalle.textContent = `Servicios inactivos: ${inactivos.join(', ')}`;
    }
    banner.style.display = 'block';
}

function showBannerError(titulo = '❌ Error de Conexión', mensaje = 'No se puede conectar con el API de monitoreo') {
    const banner = document.getElementById('banner-estado');
    banner.classList.remove('alert-success', 'alert-warning');
    banner.classList.add('alert-danger');
    banner.querySelector('h5').innerHTML = titulo;
    banner.querySelector('i').className = 'fas fa-times-circle fa-2x me-3';
    document.getElementById('banner-detalle').textContent = mensaje;
    banner.style.display = 'block';
}

function updateStatusCards(procesos = {}, detalles = {}, dashboard = {}, metricas = {}) {
    const estados = {
        'monitor_scawatt': document.getElementById('monitor-status'),
        'sincronizacion': document.getElementById('sync-status'),
        'cron_tasks': document.getElementById('cron-status'),
        'mysql_db': document.getElementById('mysql-status')
    };
    
    const labels = {
        'monitor_scawatt': 'Monitor',
        'sincronizacion': 'Sincro',
        'cron_tasks': 'Cron',
        'mysql_db': 'MySQL'
    };
    
    for (let key in estados) {
        let estado = procesos[key];
        let badge = estado === 'activo' 
            ? '<span class="badge bg-success"><i class="fas fa-check-circle"></i> ACTIVO</span>'
            : '<span class="badge bg-danger"><i class="fas fa-times-circle"></i> INACTIVO</span>';
        estados[key].innerHTML = badge;
    }
    
    // Información adicional en las tarjetas
    document.getElementById('monitor-uptime').textContent = detalles.uptime || '-';
    const ultimaSync = dashboard.ultima_sync ? new Date(dashboard.ultima_sync).toLocaleString('es-CO') : 'Sin datos';
    document.getElementById('sync-last').textContent = `Último: ${ultimaSync}`;
    const pendientesDepositos = metricas.depositos_pendientes ?? 0;
    const pendientesRetiros = metricas.retiros_pendientes ?? 0;
    document.getElementById('cron-count').textContent = `${pendientesDepositos} depósitos · ${pendientesRetiros} retiros pendientes`;
    const conexionTexto = detalles.usuario && detalles.servidor
        ? `${detalles.usuario}@${detalles.servidor}`
        : 'Conexión activa';
    document.getElementById('mysql-connections').textContent = conexionTexto;
    
    // Estado general
    const todoActivo = Object.values(procesos).every(e => e === 'activo');
    const estadoGeneral = todoActivo 
        ? '<span class="badge bg-success">✓ TODO OK</span>'
        : '<span class="badge bg-warning">⚠ Revisar</span>';
    document.getElementById('estado-general').innerHTML = estadoGeneral;
}

function updateServerInfo(detalles) {
    document.getElementById('servidor-name').textContent = detalles.servidor || '-';
    document.getElementById('servidor-user').textContent = detalles.usuario || '-';
    document.getElementById('servidor-time').textContent = detalles.timestamp || '-';
    document.getElementById('servidor-uptime').textContent = detalles.uptime || '-';
    document.getElementById('php-version').textContent = detalles.php_version || '-';
    document.getElementById('laravel-version').textContent = detalles.laravel_version || '-';
}

function updateProcessTable(procesos) {
    const table = document.getElementById('procesos-table');
    const now = new Date().toLocaleTimeString('es-CO');
    
    const labels = {
        'monitor_scawatt': {
            nombre: 'Monitor ScaWatt v2 (Python)',
            descripcion: 'Proceso que monitorea la producción de ScaWatts en tiempo real'
        },
        'sincronizacion': {
            nombre: 'Sincronización de Datos',
            descripcion: 'ScaWatt.json sincronizado en últimas 24 horas'
        },
        'cron_tasks': {
            nombre: 'Servicio Cron (Tareas Programadas)',
            descripcion: 'Gestor de tareas automatizadas del sistema'
        },
        'mysql_db': {
            nombre: 'Base de Datos MySQL',
            descripcion: 'Conexión activa a scalarapp_sc4watt'
        }
    };
    
    let html = '';
    for (let key in procesos) {
        let estado = procesos[key];
        let badge = estado === 'activo' 
            ? '<span class="badge bg-success"><i class="fas fa-check-circle"></i> ACTIVO</span>'
            : '<span class="badge bg-danger"><i class="fas fa-times-circle"></i> INACTIVO</span>';
        let icon = estado === 'activo' 
            ? '<i class="fas fa-circle text-success me-2" style="font-size: 8px;"></i>'
            : '<i class="fas fa-circle text-danger me-2" style="font-size: 8px;"></i>';
        
        html += `
            <tr>
                <td>
                    ${icon}
                    <strong>${labels[key].nombre}</strong>
                    <br><small class="text-muted">${labels[key].descripcion}</small>
                </td>
                <td class="text-center">${badge}</td>
                <td><small class="text-muted"><i class="far fa-clock"></i> ${now}</small></td>
                <td class="text-center">
                    ${estado === 'activo' 
                        ? '<i class="fas fa-check text-success" title="Funcionando correctamente"></i>'
                        : '<i class="fas fa-exclamation-triangle text-warning" title="Requiere atención"></i>'
                    }
                </td>
            </tr>
        `;
    }
    table.innerHTML = html;
}

function verSolicitudesVIP() {
    if (!monitorSnapshot || !monitorSnapshot.solicitudes) {
        alert('Aún no hay datos disponibles. Intenta nuevamente en unos segundos.');
        return;
    }

    const solicitudes = monitorSnapshot.solicitudes.recientes || [];
    const puedeGestionar = monitorSnapshot.solicitudes.acciones_habilitadas === true;
    const modal = new bootstrap.Modal(document.getElementById('modalSolicitudesVIP'));
    const tbody = document.getElementById('tbody-solicitudes-vip');

    tbody.innerHTML = '';

    if (solicitudes.length === 0) {
        tbody.innerHTML = '<tr><td colspan="7" class="text-center text-muted">No hay solicitudes</td></tr>';
    } else {
        solicitudes.forEach(sol => {
            const badgeEstado = {
                'pendiente': '<span class="badge bg-warning">Pendiente</span>',
                'contactado': '<span class="badge bg-info">Contactado</span>',
                'completado': '<span class="badge bg-success">Completado</span>',
                'cancelado': '<span class="badge bg-danger">Cancelado</span>'
            };

            const fecha = sol.created_at ? new Date(sol.created_at).toLocaleString('es-CO') : '-';
            const accionesHtml = puedeGestionar && sol.estado === 'pendiente'
                ? `
                    <button class="btn btn-sm btn-success" onclick="marcarContactado(${sol.id})">
                        <i class="fas fa-phone"></i>
                    </button>
                    <button class="btn btn-sm btn-danger" onclick="marcarCompletado(${sol.id})">
                        <i class="fas fa-check"></i>
                    </button>
                  `
                : (!puedeGestionar ? '<small class="text-muted">Solo lectura</small>' : '');

            tbody.innerHTML += `
                <tr>
                    <td>${sol.id}</td>
                    <td>
                        <strong>${sol.nombre_completo}</strong><br>
                        <small class="text-muted">CC: ${sol.cedula || '-'}</small>
                    </td>
                    <td>
                        <a href="mailto:${sol.email}">${sol.email}</a><br>
                        <small>${sol.telefono || '-'}</small>
                    </td>
                    <td class="text-center">
                        <strong class="text-primary">${sol.cantidad_scawatts ?? '-'}</strong>
                    </td>
                    <td class="text-center">${badgeEstado[sol.estado] || sol.estado}</td>
                    <td><small>${fecha}</small></td>
                    <td>
                        <button class="btn btn-sm btn-primary" onclick="verDetalleSolicitud(${sol.id})">
                            <i class="fas fa-eye"></i>
                        </button>
                        ${accionesHtml}
                    </td>
                </tr>
            `;
        });
    }

    modal.show();
}
            <div class="toast show" role="alert">
                <div class="toast-header bg-success text-white">
                    <i class="fas fa-check-circle me-2"></i>
                    <strong class="me-auto">Copiado</strong>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
                </div>
                <div class="toast-body">
                    Comando copiado al portapapeles
                </div>
            </div>
        `;
        document.body.appendChild(toast);
        setTimeout(() => toast.remove(), 3000);
    }).catch(err => {
        console.error('Error al copiar:', err);
        alert('No se pudo copiar al portapapeles');
    });
}

// Agregar botones de copiar a todos los bloques de código
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('pre code').forEach(block => {
        const pre = block.parentElement;
        if (!pre.querySelector('.btn-copy')) {
            const btnCopy = document.createElement('button');
            btnCopy.className = 'btn btn-sm btn-outline-light btn-copy position-absolute top-0 end-0 m-2';
            btnCopy.innerHTML = '<i class="fas fa-copy"></i> Copiar';
            btnCopy.onclick = () => copiarAlPortapapeles(block.textContent);
            pre.style.position = 'relative';
            pre.appendChild(btnCopy);
        }
    });
});

// Rotar icono de chevron al expandir/contraer
document.addEventListener('DOMContentLoaded', function() {
    const collapseButtons = document.querySelectorAll('[data-bs-toggle="collapse"]');
    collapseButtons.forEach(btn => {
        const target = btn.getAttribute('data-bs-target');
        const collapse = document.querySelector(target);
        
        collapse.addEventListener('show.bs.collapse', function() {
            btn.querySelector('i').classList.remove('fa-chevron-right');
            btn.querySelector('i').classList.add('fa-chevron-down');
        });
        
        collapse.addEventListener('hide.bs.collapse', function() {
            btn.querySelector('i').classList.remove('fa-chevron-down');
            btn.querySelector('i').classList.add('fa-chevron-right');
        });
    });

    // Cargar solicitudes VIP pendientes al inicio
    cargarSolicitudesVIPPendientes();
});

// ==================================================
// SOLICITUDES VIP - NUEVAS FUNCIONES
// ==================================================

        modal.show();
        
    } catch (error) {
        console.error('Error:', error);
        alert('Error al cargar solicitudes');
    }
}

// Ver detalle de una solicitud
function verDetalleSolicitud(id) {
    if (!monitorSnapshot || !monitorSnapshot.solicitudes) {
        alert('Sin datos de solicitudes disponibles.');
        return;
    }

    const solicitud = (monitorSnapshot.solicitudes.recientes || []).find(s => s.id === id);

    if (!solicitud) {
        alert('Solicitud no encontrada');
        return;
    }

    const detalleHTML = `
        <div class="row">
            <div class="col-md-6">
                <p><strong>Nombre:</strong> ${solicitud.nombre_completo}</p>
                <p><strong>Cédula:</strong> ${solicitud.cedula ?? '-'}</p>
                <p><strong>Email:</strong> <a href="mailto:${solicitud.email}">${solicitud.email}</a></p>
                <p><strong>Teléfono:</strong> <a href="tel:${solicitud.telefono}">${solicitud.telefono || 'N/A'}</a></p>
            </div>
            <div class="col-md-6">
                <p><strong>Cantidad ScaWatts:</strong> ${solicitud.cantidad_scawatts ?? '-'}</p>
                <p><strong>Presupuesto:</strong> $${Number(solicitud.presupuesto_aproximado || 0).toLocaleString('es-CO')}</p>
                <p><strong>Estado:</strong> ${solicitud.estado}</p>
                <p><strong>Fecha:</strong> ${solicitud.created_at ? new Date(solicitud.created_at).toLocaleString('es-CO') : '-'}</p>
            </div>
            ${solicitud.mensaje ? `
                <div class="col-12 mt-3">
                    <strong>Mensaje del cliente:</strong>
                    <div class="alert alert-info mt-2">${solicitud.mensaje}</div>
                </div>
            ` : ''}
        </div>
    `;

    document.getElementById('detalle-solicitud-content').innerHTML = detalleHTML;
    const modalDetalle = new bootstrap.Modal(document.getElementById('modalDetalleSolicitud'));
    modalDetalle.show();
}

// Marcar como contactado
function marcarContactado() {
    alert('Esta acción solo está disponible desde el panel administrativo con sesión iniciada.');
}

// Marcar como completado
function marcarCompletado() {
    alert('Esta acción solo está disponible desde el panel administrativo con sesión iniciada.');
}

// Actualizar contador cada 30 segundos
setInterval(cargarSolicitudesVIPPendientes, 30000);
</script>

<!-- Modal: Listado de Solicitudes VIP -->
<div class="modal fade" id="modalSolicitudesVIP" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">
                    <i class="fas fa-bell"></i> Solicitudes de Contacto VIP
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Cliente</th>
                            <th>Contacto</th>
                            <th>Cantidad</th>
                            <th>Estado</th>
                            <th>Fecha</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody id="tbody-solicitudes-vip">
                        <tr><td colspan="7" class="text-center">Cargando...</td></tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal: Detalle de Solicitud -->
<div class="modal fade" id="modalDetalleSolicitud" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">
                    <i class="fas fa-info-circle"></i> Detalle de Solicitud
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="detalle-solicitud-content">
                Cargando...
            </div>
        </div>
    </div>
</div>

@endsection
