<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\AdminDashboardController;
use App\Http\Controllers\AdminMarketplaceController;
use App\Http\Controllers\AdminUsuariosController;
use App\Http\Controllers\AdminScawattsController;
use App\Http\Controllers\AdminGranjasController;
use App\Http\Controllers\AdminTransaccionesController;
use App\Http\Controllers\AdminNotificacionesController;
use App\Http\Controllers\AdminMensajesController;
use App\Http\Controllers\AdminCorreosController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::middleware('guest')->group(function () {
	Route::get('/login', [AdminAuthController::class, 'showLoginForm'])->name('login');
	Route::post('/login', [AdminAuthController::class, 'login']);
});

Route::post('/logout', [AdminAuthController::class, 'logout'])->middleware('auth')->name('logout');
Route::post('/perfil/master/password', [AdminAuthController::class, 'updatePassword'])
	->middleware(['auth', 'auth.master'])
	->name('master.password.update');

Route::middleware(['auth', 'auth.master'])->group(function () {
	Route::get('/', [AdminDashboardController::class, 'index'])->name('admin.dashboard');

	Route::get('/usuarios', [AdminUsuariosController::class, 'index'])->name('admin.usuarios');
	Route::post('/usuarios', [AdminUsuariosController::class, 'store'])->name('admin.usuarios.store');
	Route::put('/usuarios/{usuario}', [AdminUsuariosController::class, 'update'])->name('admin.usuarios.update');
	Route::patch('/usuarios/{usuario}/estado', [AdminUsuariosController::class, 'actualizarEstado'])->name('admin.usuarios.estado');
	Route::get('/scawatts', [AdminScawattsController::class, 'index'])->name('admin.scawatts');
	Route::get('/granjas', [AdminGranjasController::class, 'index'])->name('admin.granjas');
	Route::get('/transacciones', [AdminTransaccionesController::class, 'index'])->name('admin.transacciones');
	Route::patch('/transacciones/depositos/{deposito}/aprobar', [AdminTransaccionesController::class, 'aprobarDeposito'])->name('admin.transacciones.depositos.aprobar');
	Route::patch('/transacciones/depositos/{deposito}/rechazar', [AdminTransaccionesController::class, 'rechazarDeposito'])->name('admin.transacciones.depositos.rechazar');
	Route::patch('/transacciones/retiros/{retiro}/proceso', [AdminTransaccionesController::class, 'marcarRetiroEnProceso'])->name('admin.transacciones.retiros.proceso');
	Route::patch('/transacciones/retiros/{retiro}/aprobar', [AdminTransaccionesController::class, 'aprobarRetiro'])->name('admin.transacciones.retiros.aprobar');
	Route::patch('/transacciones/retiros/{retiro}/rechazar', [AdminTransaccionesController::class, 'rechazarRetiro'])->name('admin.transacciones.retiros.rechazar');
	Route::get('/marketplace', [AdminMarketplaceController::class, 'index'])->name('admin.marketplace');
	Route::get('/notificaciones', [AdminNotificacionesController::class, 'index'])->name('admin.notificaciones');
	Route::get('/mensajes', [AdminMensajesController::class, 'index'])->name('admin.mensajes');
	Route::get('/correos', [AdminCorreosController::class, 'index'])->name('admin.correos');

	Route::view('/monitor', 'monitor.index')->name('admin.monitor');
});
