<?php $__env->startSection('title', 'Mensajes internos'); ?>
<?php $__env->startSection('page-title', 'Mensajes'); ?>

<?php $__env->startSection('page-actions'); ?>
<div class="d-flex gap-2">
    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-sm btn-outline-secondary">
        <i class="fas fa-arrow-left me-1"></i> Dashboard
    </a>
    <a href="<?php echo e(route('admin.notificaciones')); ?>" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-bell me-1"></i> Notificaciones
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php use Illuminate\Support\Str; ?>
<?php
    $estadoOptions = [
        'todos' => 'Todos',
        'enviados' => 'Enviados',
        'pendientes' => 'Pendientes',
    ];

    $ordenOptions = [
        'recientes' => 'Más recientes',
        'programados' => 'Programados',
        'enviados' => 'Fecha envío',
    ];

    $tipoOptions = collect($resumenTipos)
        ->pluck('tipo')
        ->filter()
        ->unique()
        ->mapWithKeys(fn($tipo) => [$tipo => ucfirst($tipo)])
        ->prepend('Todos', 'todos')
        ->toArray();

    if (!isset($tipoOptions['todos'])) {
        $tipoOptions = ['todos' => 'Todos'] + $tipoOptions;
    }

    $destinatarioOptions = collect($resumenDestinatarios)
        ->pluck('destinatario')
        ->filter()
        ->unique()
        ->mapWithKeys(fn($destino) => [$destino => ucfirst($destino)])
        ->prepend('Todos', 'todos')
        ->toArray();

    if (!isset($destinatarioOptions['todos'])) {
        $destinatarioOptions = ['todos' => 'Todos'] + $destinatarioOptions;
    }
?>

<div class="row g-3 mb-1">
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Total mensajes</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['total'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-dark-subtle text-dark"><i class="fas fa-inbox"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Enviados</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['enviados'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-success-subtle text-success"><i class="fas fa-paper-plane"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Pendientes</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['pendientes'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-warning-subtle text-warning"><i class="fas fa-clock"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Programados hoy</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['programados_hoy'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-info-subtle text-info"><i class="fas fa-calendar-day"></i></span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="get" class="row g-3 align-items-end">
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="estado" class="form-label small text-uppercase text-muted mb-1">Estado</label>
                <select id="estado" name="estado" class="form-select form-select-sm">
                    <?php $__currentLoopData = $estadoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['estado'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="tipo" class="form-label small text-uppercase text-muted mb-1">Tipo</label>
                <select id="tipo" name="tipo" class="form-select form-select-sm">
                    <?php $__currentLoopData = $tipoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['tipo'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="destinatario" class="form-label small text-uppercase text-muted mb-1">Destinatario</label>
                <select id="destinatario" name="destinatario" class="form-select form-select-sm">
                    <?php $__currentLoopData = $destinatarioOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['destinatario'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="orden" class="form-label small text-uppercase text-muted mb-1">Orden</label>
                <select id="orden" name="orden" class="form-select form-select-sm">
                    <?php $__currentLoopData = $ordenOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['orden'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="q" class="form-label small text-uppercase text-muted mb-1">Buscar</label>
                <input type="search" id="q" name="q" value="<?php echo e($filtros['q']); ?>" class="form-control form-control-sm" placeholder="Título, contenido o usuario">
            </div>
            <div class="col-xxl-1 col-md-2">
                <label for="por_pagina" class="form-label small text-uppercase text-muted mb-1">Por página</label>
                <input type="number" min="5" max="100" id="por_pagina" name="por_pagina" value="<?php echo e($filtros['por_pagina']); ?>" class="form-control form-control-sm">
            </div>
            <div class="col-xxl-1 col-md-2 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary flex-fill">
                    <i class="fas fa-filter me-1"></i> Aplicar
                </button>
                <a href="<?php echo e(route('admin.mensajes')); ?>" class="btn btn-sm btn-outline-secondary" title="Limpiar filtros">
                    <i class="fas fa-rotate-right"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<div class="row g-3">
    <div class="col-xxl-9">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="mb-0">Historial de mensajes</h6>
                    <small class="text-muted">Mostrando <?php echo e($mensajes->firstItem() ?? 0); ?>-<?php echo e($mensajes->lastItem() ?? 0); ?> de <?php echo e($mensajes->total()); ?> registros</small>
                </div>
                <span class="badge bg-dark-subtle text-dark"><?php echo e(strtoupper($filtros['estado'])); ?></span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Mensaje</th>
                                <th>Usuario</th>
                                <th class="text-center">Tipo</th>
                                <th class="text-center">Estado</th>
                                <th class="text-end">Fechas</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $mensajes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mensaje): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $esEnviado = (bool) $mensaje->enviado;
                                $estadoBadge = $esEnviado ? 'bg-success' : 'bg-warning text-dark';
                                $estadoTexto = $esEnviado ? 'Enviado' : 'Pendiente';
                                $tipoTexto = $mensaje->tipo ? ucfirst($mensaje->tipo) : 'General';
                                $destinatarioTexto = $mensaje->destinatario ? ucfirst($mensaje->destinatario) : 'General';
                            ?>
                            <tr>
                                <td>
                                    <div class="fw-semibold"><?php echo e($mensaje->titulo ?? 'Sin título'); ?></div>
                                    <small class="text-muted d-block"><?php echo e(Str::limit($mensaje->contenido ?? '', 140)); ?></small>
                                    <div class="small mt-1">
                                        <span class="badge bg-light text-dark me-1"><?php echo e($destinatarioTexto); ?></span>
                                        <?php if($mensaje->creador): ?>
                                            <span class="text-muted">Creado por <?php echo e($mensaje->creador->nombre); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($mensaje->usuario->nombre ?? 'Sistema'); ?></div>
                                    <small class="text-muted"><?php echo e($mensaje->usuario->email ?? '—'); ?></small>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-secondary text-uppercase"><?php echo e($tipoTexto); ?></span>
                                </td>
                                <td class="text-center">
                                    <span class="badge <?php echo e($estadoBadge); ?>"><?php echo e($estadoTexto); ?></span>
                                </td>
                                <td class="text-end">
                                    <div class="fw-semibold"><?php echo e($mensaje->created_at?->format('d M Y H:i') ?? 'N/D'); ?></div>
                                    <small class="text-muted d-block">Programado: <?php echo e($mensaje->fecha_programada?->format('d M Y H:i') ?? '—'); ?></small>
                                    <small class="text-muted">Enviado: <?php echo e($mensaje->fecha_enviado?->format('d M Y H:i') ?? '—'); ?></small>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-5">No hay registros que coincidan con los filtros.</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white border-0">
                <?php echo e($mensajes->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>
    <div class="col-xxl-3">
        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Pendientes próximos</h6>
                <span class="badge bg-warning-subtle text-warning"><?php echo e($pendientes->count()); ?></span>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $pendientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pendiente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-group-item">
                            <div class="fw-semibold"><?php echo e($pendiente->titulo ?? 'Sin título'); ?></div>
                            <small class="text-muted d-block"><?php echo e($pendiente->fecha_programada?->diffForHumans() ?? 'Sin fecha'); ?></small>
                            <small class="text-muted">Destino <?php echo e(ucfirst($pendiente->destinatario ?? 'general')); ?></small>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="list-group-item text-center text-muted py-4">Sin envíos pendientes.</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>

        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Resumen por tipo</h6>
                <span class="badge bg-dark-subtle text-dark"><?php echo e($resumenTipos->sum('total')); ?></span>
            </div>
            <div class="card-body">
                <?php $__empty_1 = true; $__currentLoopData = $resumenTipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resumen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <div class="fw-semibold"><?php echo e(ucfirst($resumen->tipo ?? 'Sin tipo')); ?></div>
                        <span class="badge bg-light text-dark"><?php echo e($resumen->total); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-muted mb-0">Sin registros.</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Resumen por destinatario</h6>
                <span class="badge bg-dark-subtle text-dark"><?php echo e($resumenDestinatarios->sum('total')); ?></span>
            </div>
            <div class="card-body">
                <?php $__empty_1 = true; $__currentLoopData = $resumenDestinatarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resumen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <div class="fw-semibold"><?php echo e(ucfirst($resumen->destinatario ?? 'Sin datos')); ?></div>
                        <span class="badge bg-light text-dark"><?php echo e($resumen->total); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-muted mb-0">Sin registros.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/admin/mensajes/index.blade.php ENDPATH**/ ?>