<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Iniciar sesión · Scalar Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet" />
    <style>
        body {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: radial-gradient(circle at top, #1f2937, #020617 65%);
            font-family: 'Inter', system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            color: #fff;
        }
        .login-card {
            width: min(420px, 92vw);
            background: rgba(15, 23, 42, 0.82);
            border-radius: 18px;
            border: 1px solid rgba(148, 163, 184, 0.18);
            box-shadow: 0 28px 60px rgba(15, 23, 42, 0.45);
            backdrop-filter: blur(18px);
            padding: 2.5rem 2.25rem;
        }
        .login-card .brand-icon {
            width: 64px;
            height: 64px;
            border-radius: 18px;
            display: grid;
            place-items: center;
            margin: 0 auto 1.25rem;
            background: linear-gradient(135deg, #38bdf8, #6366f1);
            font-size: 1.65rem;
        }
        .form-label {
            font-weight: 600;
            color: #cbd5f5;
        }
        .form-control {
            background: rgba(15, 23, 42, 0.6);
            border: 1px solid rgba(99, 102, 241, 0.35);
            color: #f8fafc;
            border-radius: 12px;
            padding: 0.65rem 1rem;
        }
        .form-control:focus {
            border-color: #38bdf8;
            box-shadow: 0 0 0 0.2rem rgba(56, 189, 248, 0.25);
        }
        .btn-login {
            background: linear-gradient(135deg, #38bdf8, #6366f1);
            border: none;
            border-radius: 999px;
            padding: 0.75rem;
            font-weight: 600;
            letter-spacing: 0.02em;
        }
        .alert {
            border-radius: 14px;
            border: none;
        }
        .footer-note {
            font-size: 0.85rem;
            color: #94a3b8;
        }
    </style>
</head>
<body>
    <div class="login-card">
        <div class="brand-icon text-white">
            <i class="fas fa-bolt"></i>
        </div>
        <h1 class="h4 text-center mb-1">Panel Master · Scalar</h1>
        <p class="text-center text-secondary mb-4">Acceso exclusivo para el usuario Master</p>

        <?php if(session('status')): ?>
            <div class="alert alert-success d-flex align-items-center" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                <span><?php echo e(session('status')); ?></span>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger d-flex align-items-center" role="alert">
                <i class="fas fa-exclamation-triangle me-2"></i>
                <span><?php echo e(session('error')); ?></span>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger" role="alert">
                <i class="fas fa-triangle-exclamation me-2"></i>
                Corrige los campos marcados para continuar.
            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('login')); ?>" novalidate>
            <?php echo csrf_field(); ?>
            <div class="mb-3">
                <label for="email" class="form-label">Correo electrónico</label>
                <input type="email" name="email" id="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('email', 'desarrollo@wosh.com.co')); ?>" required autofocus autocomplete="email">
                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Contraseña</label>
                <input type="password" name="password" id="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required autocomplete="current-password">
                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" value="1" id="remember" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="remember">Mantener sesión</label>
                </div>
                <button type="submit" class="btn btn-login text-white">
                    <i class="fas fa-lock-open me-2"></i>Entrar al panel
                </button>
            </div>
        </form>

        <p class="footer-note text-center mb-0">
            Si olvidaste la contraseña, restablécela desde el servidor usando <code>php artisan tinker</code> y <code>$u->password = Hash::make('nueva')</code>.
        </p>
    </div>
</body>
</html>
<?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/auth/login.blade.php ENDPATH**/ ?>