<?php $__env->startSection('title', 'Marketplace ScaWatt'); ?>
<?php $__env->startSection('page-title', 'Marketplace'); ?>
<?php $__env->startSection('page-subtitle', 'Control maestro de publicaciones, ventas y métricas del marketplace ScaWatt'); ?>

<?php $__env->startSection('page-actions'); ?>
<div class="d-flex gap-2">
    <a href="<?php echo e(route('admin.transacciones')); ?>" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-coins me-1"></i> Operaciones financieras
    </a>
    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-sm btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Dashboard
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php
    $estadoOptions = [
        'todos' => 'Todos',
        'en_venta' => 'En venta',
        'reservado' => 'Reservado',
        'vendido' => 'Vendido',
        'cancelado' => 'Cancelado',
    ];

    $ordenOptions = [
        'recientes' => 'Más recientes',
        'precio_desc' => 'Precio (alto a bajo)',
        'precio_asc' => 'Precio (bajo a alto)',
        'antiguedad' => 'Antigüedad de publicación',
    ];

    $badgeEstado = [
        'en_venta' => 'bg-primary',
        'vendido' => 'bg-success',
        'reservado' => 'bg-warning text-dark',
        'cancelado' => 'bg-secondary',
    ];
?>

<div class="row g-3 mb-1">
    <div class="col-xxl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Publicaciones activas</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['activos'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-primary-subtle text-primary"><i class="fas fa-store"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Valor listado</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['valor_activos']); ?></h4>
                    </div>
                    <span class="icon-circle bg-success-subtle text-success"><i class="fas fa-hand-holding-dollar"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Precio promedio</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['promedio_precio']); ?></h4>
                    </div>
                    <span class="icon-circle bg-warning-subtle text-warning"><i class="fas fa-tags"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Ventas del mes</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['vendidos_mes'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-info-subtle text-info"><i class="fas fa-cart-shopping"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Comisión del mes</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['comision_mes']); ?></h4>
                    </div>
                    <span class="icon-circle bg-secondary-subtle text-secondary"><i class="fas fa-medal"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Tiempo promedio venta</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['tiempo_promedio_venta']); ?></h4>
                    </div>
                    <span class="icon-circle bg-dark-subtle text-dark"><i class="fas fa-clock"></i></span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="get" class="row g-3 align-items-end">
            <div class="col-xl-3 col-md-4">
                <label for="estado" class="form-label small text-uppercase text-muted mb-1">Estado</label>
                <select id="estado" name="estado" class="form-select form-select-sm">
                    <?php $__currentLoopData = $estadoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['estado'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-3 col-md-4">
                <label for="orden" class="form-label small text-uppercase text-muted mb-1">Ordenar por</label>
                <select id="orden" name="orden" class="form-select form-select-sm">
                    <?php $__currentLoopData = $ordenOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['orden'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-3 col-md-4">
                <label for="q" class="form-label small text-uppercase text-muted mb-1">Buscar</label>
                <input type="search" id="q" name="q" value="<?php echo e($filtros['q']); ?>" class="form-control form-control-sm" placeholder="ID, vendedor, ScaWatt...">
            </div>
            <div class="col-xl-2 col-md-3 d-flex align-items-center">
                <div class="form-check form-switch mt-3">
                    <input class="form-check-input" type="checkbox" role="switch" id="destacados" name="destacados" value="1" <?php if($filtros['destacados']): echo 'checked'; endif; ?>>
                    <label class="form-check-label" for="destacados">Solo destacados</label>
                </div>
            </div>
            <div class="col-xl-1 col-md-3 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary flex-fill">
                    <i class="fas fa-filter me-1"></i> Aplicar
                </button>
                <a href="<?php echo e(route('admin.marketplace')); ?>" class="btn btn-sm btn-outline-secondary" title="Limpiar filtros">
                    <i class="fas fa-rotate-right"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<div class="row g-3">
    <div class="col-xxl-9 col-xl-8">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="mb-0">Publicaciones del marketplace</h6>
                    <small class="text-muted">Mostrando <?php echo e($publicaciones->firstItem() ?? 0); ?>-<?php echo e($publicaciones->lastItem() ?? 0); ?> de <?php echo e($publicaciones->total()); ?> registros</small>
                </div>
                <span class="badge bg-primary-subtle text-primary"><?php echo e(strtoupper($filtros['estado'])); ?></span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-nowrap">Publicación</th>
                                <th>ScaWatt</th>
                                <th>Precio</th>
                                <th>Vendedor</th>
                                <th>Comprador</th>
                                <th class="text-center">Estado</th>
                                <th class="text-center">Destacado</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $publicaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $publicacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $scawatt = $publicacion->scawatt;
                                $vendedor = $publicacion->vendedor;
                                $comprador = $publicacion->comprador;
                                $badgeClass = $badgeEstado[$publicacion->estado] ?? 'bg-dark';
                                $estadoTexto = \Illuminate\Support\Str::of($publicacion->estado)->replace('_', ' ')->headline();
                            ?>
                            <tr>
                                <td class="text-nowrap">
                                    <div class="fw-semibold">#<?php echo e($publicacion->id); ?></div>
                                    <small class="text-muted"><?php echo e($publicacion->fecha_publicacion?->format('d M Y H:i') ?? $publicacion->created_at?->format('d M Y H:i') ?? 'N/D'); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($scawatt->scawatt_id ?? 'Sin asignar'); ?></div>
                                    <small class="text-muted"><?php echo e($scawatt?->granja?->nombre ?? 'Granja N/D'); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold">$<?php echo e(number_format((float) $publicacion->precio_venta, 0, ',', '.')); ?></div>
                                    <small class="text-muted">Val. actual: $<?php echo e(number_format((float) ($scawatt->valor_actual ?? 0), 0, ',', '.')); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($vendedor->nombre ?? 'Sin vendedor'); ?></div>
                                    <small class="text-muted"><?php echo e($vendedor->email ?? '—'); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($comprador->nombre ?? 'Sin comprador'); ?></div>
                                    <small class="text-muted"><?php echo e($comprador->email ?? '—'); ?></small>
                                </td>
                                <td class="text-center">
                                    <span class="badge <?php echo e($badgeClass); ?>"><?php echo e($estadoTexto); ?></span>
                                </td>
                                <td class="text-center">
                                    <?php if($publicacion->destacado): ?>
                                        <i class="fas fa-star text-warning"></i>
                                    <?php else: ?>
                                        <span class="text-muted">—</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted py-5">
                                    No encontramos publicaciones con los filtros seleccionados.
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white border-0">
                <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-2">
                    <small class="text-muted">Valor total en historial: <span class="fw-semibold"><?php echo e($totales['valor_estimado']); ?></span></small>
                    <div>
                        <?php echo e($publicaciones->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-3 col-xl-4">
        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Destacados activos</h6>
                <span class="badge bg-info-subtle text-info"><?php echo e($destacados->count()); ?></span>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $destacados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-group-item">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <div class="fw-semibold"><?php echo e($item->scawatt->scawatt_id ?? 'ScaWatt N/D'); ?></div>
                                    <small class="text-muted"><?php echo e($item->vendedor->nombre ?? 'Vendedor N/D'); ?></small>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-primary">$<?php echo e(number_format((float) $item->precio_venta, 0, ',', '.')); ?></span>
                                    <div><small class="text-muted"><?php echo e($item->fecha_publicacion?->diffForHumans() ?? 'N/D'); ?></small></div>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="list-group-item text-center text-muted py-4">Sin publicaciones destacadas</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>

        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0">
                <h6 class="mb-0">Ventas recientes</h6>
                <small class="text-muted">Últimas 6 transacciones cerradas</small>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $ventasRecientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-group-item">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <div class="fw-semibold"><?php echo e($venta->scawatt->scawatt_id ?? 'ScaWatt N/D'); ?></div>
                                    <small class="text-muted">Vendedor: <?php echo e($venta->vendedor->nombre ?? 'N/D'); ?></small>
                                    <div><small class="text-muted">Comprador: <?php echo e($venta->comprador->nombre ?? 'N/D'); ?></small></div>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-success">$<?php echo e(number_format((float) $venta->precio_venta, 0, ',', '.')); ?></span>
                                    <div><small class="text-muted"><?php echo e($venta->fecha_venta?->format('d M Y') ?? 'N/D'); ?></small></div>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="list-group-item text-center text-muted py-4">Sin ventas registradas</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Resumen por estado</h6>
                <span class="badge bg-dark-subtle text-dark"><?php echo e($totales['publicaciones']); ?> total</span>
            </div>
            <div class="card-body">
                <?php $__empty_1 = true; $__currentLoopData = $resumenEstados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resumen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <div>
                            <div class="fw-semibold"><?php echo e(\Illuminate\Support\Str::of($resumen['estado'])->replace('_', ' ')->headline()); ?></div>
                            <small class="text-muted"><?php echo e($resumen['valor']); ?></small>
                        </div>
                        <span class="badge bg-light text-dark"><?php echo e($resumen['total']); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-muted mb-0">Sin datos disponibles.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/admin/marketplace/index.blade.php ENDPATH**/ ?>