<?php $__env->startSection('title', 'ScaWatts'); ?>
<?php $__env->startSection('page-title', 'Inventario de ScaWatts'); ?>
<?php $__env->startSection('page-subtitle', 'Controla seriales, valorizaciones y asignaciones por granja en tiempo real'); ?>

<?php $__env->startSection('page-actions'); ?>
<div class="d-flex gap-2">
    <a href="<?php echo e(route('admin.marketplace')); ?>" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-store me-1"></i> Marketplace
    </a>
    <a href="<?php echo e(route('admin.granjas')); ?>" class="btn btn-sm btn-secondary">
        <i class="fas fa-seedling me-1"></i> Granjas
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php
    $estadoOptions = [
        'todos' => 'Todos los estados',
        'activo' => 'Activos',
        'marketplace' => 'En marketplace',
        'reservado' => 'Reservados',
        'vendido' => 'Vendidos',
        'bloqueado' => 'Bloqueados',
    ];

    $tipoOptions = ['todos' => 'Todos los tipos'];
    foreach ($porTipo as $tipoRow) {
        $clave = $tipoRow->tipo ?: 'sin_tipo';
        $tipoOptions[$clave] = ucfirst(str_replace('_', ' ', $clave));
    }

    $ordenOptions = [
        'recientes' => 'Más recientes',
        'valor_desc' => 'Valor mayor a menor',
        'valor_asc' => 'Valor menor a mayor',
        'kwh_desc' => 'kWh mayor a menor',
        'kwh_asc' => 'kWh menor a mayor',
        'valorizacion' => 'Mayor valorización',
    ];
?>

<div class="row g-3 mb-1">
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Total ScaWatts</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['total'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-warning-subtle text-warning"><i class="fas fa-solar-panel"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Activos</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['activos'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-success-subtle text-success"><i class="fas fa-bolt"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">En marketplace</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['marketplace'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-info-subtle text-info"><i class="fas fa-store"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Valor actual</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['valor_actual']); ?></h4>
                    </div>
                    <span class="icon-circle bg-secondary-subtle text-secondary"><i class="fas fa-coins"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Valorización</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['valorizacion']); ?></h4>
                    </div>
                    <span class="icon-circle bg-dark-subtle text-dark"><i class="fas fa-chart-line"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">kWh administrados</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['kwh_total']); ?> kWh</h4>
                    </div>
                    <span class="icon-circle bg-primary-subtle text-primary"><i class="fas fa-battery-full"></i></span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="get" class="row g-3 align-items-end">
            <div class="col-xl-3 col-md-4">
                <label for="estado" class="form-label small text-uppercase text-muted mb-1">Estado</label>
                <select id="estado" name="estado" class="form-select form-select-sm">
                    <?php $__currentLoopData = $estadoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['estado'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-3 col-md-4">
                <label for="granja" class="form-label small text-uppercase text-muted mb-1">Granja</label>
                <select id="granja" name="granja" class="form-select form-select-sm">
                    <option value="todas" <?php if($filtros['granja'] === 'todas'): echo 'selected'; endif; ?>>Todas las granjas</option>
                    <?php $__currentLoopData = $granjas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $granja): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($granja->id); ?>" <?php if($filtros['granja'] == $granja->id): echo 'selected'; endif; ?>><?php echo e($granja->nombre); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="tipo" class="form-label small text-uppercase text-muted mb-1">Tipo</label>
                <select id="tipo" name="tipo" class="form-select form-select-sm">
                    <?php $__currentLoopData = $tipoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['tipo'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="orden" class="form-label small text-uppercase text-muted mb-1">Orden</label>
                <select id="orden" name="orden" class="form-select form-select-sm">
                    <?php $__currentLoopData = $ordenOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['orden'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-1 col-md-4">
                <label for="por_pagina" class="form-label small text-uppercase text-muted mb-1">Por página</label>
                <input type="number" min="10" max="100" id="por_pagina" name="por_pagina" value="<?php echo e($filtros['por_pagina']); ?>" class="form-control form-control-sm">
            </div>
            <div class="col-xl-3 col-md-4">
                <label for="q" class="form-label small text-uppercase text-muted mb-1">Buscar</label>
                <input type="search" id="q" name="q" value="<?php echo e($filtros['q']); ?>" class="form-control form-control-sm" placeholder="Serial, usuario, correo...">
            </div>
            <div class="col-xl-1 col-md-3 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary flex-fill">
                    <i class="fas fa-filter me-1"></i> Aplicar
                </button>
                <a href="<?php echo e(route('admin.scawatts')); ?>" class="btn btn-sm btn-outline-secondary" title="Limpiar filtros">
                    <i class="fas fa-rotate-right"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<div class="row g-3">
    <div class="col-xxl-9 col-xl-8">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="mb-0">Inventario detallado</h6>
                    <small class="text-muted">Mostrando <?php echo e($scawatts->firstItem() ?? 0); ?>-<?php echo e($scawatts->lastItem() ?? 0); ?> de <?php echo e($scawatts->total()); ?> registros</small>
                </div>
                <span class="badge bg-primary-subtle text-primary"><?php echo e(strtoupper($filtros['estado'])); ?></span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>ScaWatt</th>
                                <th>Propietario</th>
                                <th>Granja</th>
                                <th>kWh</th>
                                <th>Valor</th>
                                <th class="text-center">Estado</th>
                                <th>Inicio</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $scawatts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scawatt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="fw-semibold"><?php echo e($scawatt->scawatt_id ?? 'Sin serial'); ?></div>
                                    <small class="text-muted">Tipo: <?php echo e(ucfirst($scawatt->tipo ?? 'N/D')); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($scawatt->usuario?->nombre ?? 'Sin asignar'); ?></div>
                                    <small class="text-muted"><?php echo e($scawatt->usuario?->email ?? 'Sin correo'); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($scawatt->granja?->nombre ?? 'Sin granja'); ?></div>
                                    <small class="text-muted"><?php echo e($scawatt->granja?->departamento ?? 'N/D'); ?> · <?php echo e($scawatt->granja?->municipio ?? 'N/D'); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e(number_format((float) ($scawatt->kwh_asignados ?? 0), 2, ',', '.')); ?> kWh</div>
                                </td>
                                <td>
                                    <div class="fw-semibold">Actual: $<?php echo e(number_format((float) ($scawatt->valor_actual ?? 0), 0, ',', '.')); ?></div>
                                    <small class="text-muted">Inicial: $<?php echo e(number_format((float) ($scawatt->valor_inicial ?? 0), 0, ',', '.')); ?></small>
                                </td>
                                <td class="text-center">
                                    <span class="badge <?php echo e($scawatt->estado === 'activo' ? 'bg-success' : ($scawatt->estado === 'marketplace' ? 'bg-info' : ($scawatt->estado === 'vendido' ? 'bg-secondary' : 'bg-warning text-dark'))); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $scawatt->estado ?? 'N/D'))); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($scawatt->fecha_inicio?->format('d M Y') ?? $scawatt->created_at?->format('d M Y') ?? 'N/D'); ?></div>
                                    <small class="text-muted">Actualización: <?php echo e($scawatt->updated_at?->diffForHumans() ?? 'N/D'); ?></small>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted py-5">No se encontraron ScaWatts con los filtros seleccionados.</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white border-0">
                <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-2">
                    <small class="text-muted">Valor inicial histórico: <?php echo e($stats['valor_inicial']); ?></small>
                    <?php echo e($scawatts->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-3 col-xl-4">
        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Distribución por estado</h6>
                <span class="badge bg-dark-subtle text-dark"><?php echo e(number_format($stats['total'])); ?></span>
            </div>
            <div class="card-body">
                <?php $__empty_1 = true; $__currentLoopData = $porEstado; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fila): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <div>
                            <div class="fw-semibold"><?php echo e(ucfirst(str_replace('_', ' ', $fila['estado']))); ?></div>
                            <small class="text-muted"><?php echo e($fila['valor']); ?></small>
                        </div>
                        <span class="badge bg-light text-dark"><?php echo e(number_format($fila['total'])); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-muted mb-0">Sin datos para mostrar.</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Granjas más activas</h6>
                <span class="badge bg-info-subtle text-info"><?php echo e($topGranjas->count()); ?></span>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $topGranjas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $granja): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-group-item d-flex justify-content-between align-items-start">
                            <div>
                                <div class="fw-semibold"><?php echo e($granja->nombre); ?></div>
                                <small class="text-muted">ScaWatts: <?php echo e(number_format($granja->scawatts_count)); ?></small>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-primary">$<?php echo e(number_format((float) $granja->scawatts_sum_valor_actual, 0, ',', '.')); ?></span>
                                <div><small class="text-muted">kWh: <?php echo e(number_format((float) ($granja->kwh_total ?? 0), 2, ',', '.')); ?></small></div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="list-group-item text-center text-muted py-4">Sin información disponible</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/admin/scawatts/index.blade.php ENDPATH**/ ?>