<?php $__env->startSection('title', 'Campañas de correo'); ?>
<?php $__env->startSection('page-title', 'Correo y automatizaciones'); ?>

<?php $__env->startSection('page-actions'); ?>
<div class="d-flex gap-2">
    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-sm btn-outline-secondary">
        <i class="fas fa-arrow-left me-1"></i> Dashboard
    </a>
    <a href="<?php echo e(route('admin.mensajes')); ?>" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-inbox me-1"></i> Mensajes
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php use Illuminate\Support\Str; ?>
<?php
    $estadoOptions = collect($resumenEstados)
        ->pluck('estado')
        ->filter()
        ->unique()
        ->mapWithKeys(fn($estado) => [$estado => ucfirst($estado)])
        ->toArray();

    $estadoOptions = ['todos' => 'Todos'] + $estadoOptions + ['pendiente' => 'Pendiente', 'contactado' => 'Contactado', 'completado' => 'Completado'];
    $estadoOptions = collect($estadoOptions)
        ->mapWithKeys(fn($label, $value) => [$value => ucfirst($label)])
        ->unique()
        ->toArray();

    if (!array_key_exists('todos', $estadoOptions)) {
        $estadoOptions = ['todos' => 'Todos'] + $estadoOptions;
    }

    $ordenOptions = [
        'recientes' => 'Más recientes',
        'presupuesto' => 'Mayor presupuesto',
        'cantidad' => 'Mayor cantidad de scawatts',
        'antiguedad' => 'Más antiguas',
    ];
?>

<div class="row g-3 mb-1">
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Solicitudes totales</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['total'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-secondary-subtle text-secondary"><i class="fas fa-envelope-open-text"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Pendientes por contactar</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['pendientes'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-warning-subtle text-warning"><i class="fas fa-phone-volume"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Contactadas</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['contactadas'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-success-subtle text-success"><i class="fas fa-handshake"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Presupuesto proyectado</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['presupuesto_total']); ?></h4>
                    </div>
                    <span class="icon-circle bg-info-subtle text-info"><i class="fas fa-coins"></i></span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="get" class="row g-3 align-items-end">
            <div class="col-xxl-3 col-lg-4 col-md-4">
                <label for="estado" class="form-label small text-uppercase text-muted mb-1">Estado</label>
                <select id="estado" name="estado" class="form-select form-select-sm">
                    <?php $__currentLoopData = $estadoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['estado'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xxl-3 col-lg-4 col-md-4">
                <label for="orden" class="form-label small text-uppercase text-muted mb-1">Ordenar por</label>
                <select id="orden" name="orden" class="form-select form-select-sm">
                    <?php $__currentLoopData = $ordenOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['orden'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xxl-3 col-lg-4 col-md-4">
                <label for="q" class="form-label small text-uppercase text-muted mb-1">Buscar</label>
                <input type="search" id="q" name="q" value="<?php echo e($filtros['q']); ?>" class="form-control form-control-sm" placeholder="Nombre, correo, teléfono o mensaje">
            </div>
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="por_pagina" class="form-label small text-uppercase text-muted mb-1">Por página</label>
                <input type="number" min="5" max="80" id="por_pagina" name="por_pagina" value="<?php echo e($filtros['por_pagina']); ?>" class="form-control form-control-sm">
            </div>
            <div class="col-xxl-1 col-lg-2 col-md-4 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary flex-fill">
                    <i class="fas fa-filter me-1"></i> Aplicar
                </button>
                <a href="<?php echo e(route('admin.correos')); ?>" class="btn btn-sm btn-outline-secondary" title="Limpiar filtros">
                    <i class="fas fa-rotate-right"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<div class="row g-3">
    <div class="col-xxl-9">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="mb-0">Solicitudes recibidas</h6>
                    <small class="text-muted">Mostrando <?php echo e($solicitudes->firstItem() ?? 0); ?>-<?php echo e($solicitudes->lastItem() ?? 0); ?> de <?php echo e($solicitudes->total()); ?> registros</small>
                </div>
                <span class="badge bg-secondary-subtle text-secondary"><?php echo e(strtoupper($filtros['estado'])); ?></span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Solicitante</th>
                                <th class="text-center">Scawatts</th>
                                <th class="text-center">Presupuesto</th>
                                <th class="text-center">Estado</th>
                                <th>Seguimiento</th>
                                <th class="text-end">Registro</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $solicitudes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $solicitud): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $estado = $solicitud->estado ?? 'pendiente';
                                $badgeClass = match ($estado) {
                                    'contactado' => 'bg-info',
                                    'completado' => 'bg-success',
                                    'cancelado' => 'bg-danger',
                                    default => 'bg-warning text-dark',
                                };
                                $presupuesto = $solicitud->presupuesto_aproximado !== null
                                    ? '$' . number_format((float) $solicitud->presupuesto_aproximado, 0, ',', '.')
                                    : '—';
                            ?>
                            <tr>
                                <td>
                                    <div class="fw-semibold"><?php echo e($solicitud->nombre_completo ?? 'Sin nombre'); ?></div>
                                    <small class="text-muted d-block"><?php echo e($solicitud->email ?? '—'); ?> · <?php echo e($solicitud->telefono ?? '—'); ?></small>
                                    <?php if($solicitud->mensaje): ?>
                                        <small class="text-muted d-block"><?php echo e(Str::limit($solicitud->mensaje, 120)); ?></small>
                                    <?php endif; ?>
                                    <?php if($solicitud->usuario): ?>
                                        <div class="small mt-1 text-muted">Usuario: <?php echo e($solicitud->usuario->nombre); ?> (<?php echo e($solicitud->usuario->email); ?>)</div>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-light text-dark"><?php echo e(number_format($solicitud->cantidad_scawatts ?? 0)); ?></span>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-light text-dark"><?php echo e($presupuesto); ?></span>
                                </td>
                                <td class="text-center">
                                    <span class="badge <?php echo e($badgeClass); ?> text-uppercase"><?php echo e(ucfirst($estado)); ?></span>
                                </td>
                                <td>
                                    <small class="text-muted d-block">Atiende: <?php echo e($solicitud->adminAtendio->nombre ?? '—'); ?></small>
                                    <small class="text-muted d-block">Contacto: <?php echo e($solicitud->fecha_contacto?->format('d M Y H:i') ?? 'No registrado'); ?></small>
                                    <?php if($solicitud->notas_admin): ?>
                                        <small class="text-muted d-block">Notas: <?php echo e(Str::limit($solicitud->notas_admin, 100)); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end">
                                    <div class="fw-semibold"><?php echo e($solicitud->created_at?->format('d M Y H:i') ?? 'N/D'); ?></div>
                                    <small class="text-muted"><?php echo e($solicitud->created_at?->diffForHumans() ?? '—'); ?></small>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted py-5">No encontramos registros para los filtros seleccionados.</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white border-0">
                <?php echo e($solicitudes->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>
    <div class="col-xxl-3">
        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Últimas solicitudes</h6>
                <span class="badge bg-secondary-subtle text-secondary"><?php echo e($ultimas->count()); ?></span>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $ultimas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reciente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-group-item">
                            <div class="fw-semibold"><?php echo e($reciente->nombre_completo ?? 'Sin nombre'); ?></div>
                            <small class="text-muted d-block"><?php echo e($reciente->created_at?->diffForHumans() ?? '—'); ?></small>
                            <small class="text-muted">Solicita <?php echo e(number_format($reciente->cantidad_scawatts ?? 0)); ?> scawatts</small>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="list-group-item text-center text-muted py-4">Sin movimientos recientes.</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Estado de solicitudes</h6>
                <span class="badge bg-dark-subtle text-dark"><?php echo e($resumenEstados->sum('total')); ?></span>
            </div>
            <div class="card-body">
                <?php $__empty_1 = true; $__currentLoopData = $resumenEstados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resumen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <div class="fw-semibold"><?php echo e(ucfirst($resumen->estado ?? 'sin estado')); ?></div>
                        <span class="badge bg-light text-dark"><?php echo e($resumen->total); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-muted mb-0">Sin datos disponibles.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/admin/correos/index.blade.php ENDPATH**/ ?>