<?php

use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Interceptar y ajustar REQUEST_URI para agregar /api/ si no está presente
$requestUri = $_SERVER['REQUEST_URI'] ?? '';

// Si la URL NO contiene /api/api/ pero SÍ contiene /scadmin/api/, agregar /api/ extra
if (strpos($requestUri, '/scadmin/api/') === 0 && strpos($requestUri, '/scadmin/api/api/') !== 0) {
    // Convertir /scadmin/api/XXX a /scadmin/api/api/XXX
    $_SERVER['REQUEST_URI'] = str_replace('/scadmin/api/', '/scadmin/api/api/', $requestUri);
}

// Determine if the application is in maintenance mode...
if (file_exists($maintenance = __DIR__.'/../backend/storage/framework/maintenance.php')) {
    require $maintenance;
}

// Register the Composer autoloader...
require __DIR__.'/../backend/vendor/autoload.php';

// Bootstrap Laravel and handle the request...
(require_once __DIR__.'/../backend/bootstrap/app.php')
    ->handleRequest(Request::capture());
