# Sincronización y valorización en tiempo real

Este documento resume el flujo implementado para mantener la tabla `scawatts` alineada con `scawatts_tokens.json` y entregar valores en tiempo real (con ventana predictiva) al endpoint existente `GET /api/usuarios/{id}/valorizacion`.

## 1. Flujo general

1. **Carga nocturna (o manual)**
   - Ejecutar `php artisan scawatt:sync-valuations`.
   - Lee `scawatts_tokens.json`, replica `valor_inicial`, `valor_actual` y `valorizaciones` en MySQL.
   - Registra un *baseline* por serial en caché para futuros deltas.
2. **Durante el día**
   - El endpoint `valorizacion` consulta el servicio `ScawattValuationService`.
   - Este servicio:
     - Usa un snapshot cacheado (5 s) del JSON maestro.
     - Combina con el baseline guardado para cualquier serial ausente.
     - Adjunta una ventana de pronóstico (por defecto 10 min) basada en `ScaWatt.json` para que el cliente pueda anticipar valores sin golpear el backend.
3. **Frontend**
   - Recibe la misma estructura que antes (`total_scawatts`, `valor_actual_total`, etc.).
   - Además dispone del bloque opcional `forecast_window` para precargar 5 s de incrementos (puede ignorarlo si no lo necesita).

## 2. Comando Artisan

```
php artisan scawatt:sync-valuations           # Actualiza BD
php artisan scawatt:sync-valuations --dry-run # Solo reporte, sin escribir
```

**Salida:**
- Totales procesados / actualizados.
- Seriales presentes en JSON pero ausentes en BD (para depurar).

### Cron sugerido (medianoche Bogotá)
```
0 0 * * * cd /home/scalarapp/public_html/scadmin/backend && php artisan scawatt:sync-valuations >> storage/logs/cron-scawatt.log 2>&1
```

## 3. Configuración

Se añadieron claves nuevas en `config/scawatt.php` (todas sobre-escribibles vía `.env`):

| Clave                              | Descripción                                                       | Valor por defecto |
|------------------------------------|-------------------------------------------------------------------|-------------------|
| `SCAWATT_TOKENS_PATH`              | Ruta absoluta a `scawatts_tokens.json`.                           | `/home/scalarapp/scalar-data/.../scawatts_tokens.json` |
| `SCAWATT_FORECAST_PATH`            | Ruta a `ScaWatt.json` (pronóstico 5 s).                           | `/home/scalarapp/public_html/develop/code-test/ScaWatt.json` |
| `SCAWATT_TOKENS_CACHE_TTL`         | TTL (segundos) del snapshot en caché.                             | `5` |
| `SCAWATT_BASELINE_CACHE_TTL`       | TTL (segundos) para guardar el baseline por serial.               | `86400` |
| `SCAWATT_FORECAST_WINDOW`          | Ventana de pronóstico entregada al cliente (segundos).            | `600` |

> Para entornos alternos basta con definir las rutas en `.env` sin tocar el código.

## 4. Endpoint `/api/usuarios/{id}/valorizacion`

- Sigue respondiendo con los mismos campos principales.
- Ahora calcula cada serial contra la última lectura del JSON maestro.
- Campo adicional `forecast_window` (puede ser `null`) entrega `desde`, `hasta` y los registros de los próximos minutos para que la app los almacene temporalmente.

## 5. Validación rápida

1. Ejecutar el comando en `--dry-run` y confirmar el conteo.
2. Hacer una llamada al endpoint y verificar que `valor_actual_total` coincide con `scawatts_tokens.json`.
3. Opcional: inspeccionar `forecast_window` para asegurar que contiene timestamps dentro de los siguientes 10 min.

Con este flujo el backend mantiene el contrato existente pero sirve valores frescos en cuestión de segundos, apoyándose en el archivo predictivo cuando corresponde.
