<?php

namespace App\Http\Controllers;

use App\Models\LoginAudit;
use Illuminate\Http\Request;
use Illuminate\View\View;

class AdminAuditoriaController extends Controller
{
    public function login(Request $request): View
    {
        $evento = $request->query('evento', 'todos');
        $busqueda = trim((string) $request->query('q', ''));
        $porPagina = (int) $request->query('por_pagina', 25);
        $porPagina = $porPagina > 0 ? min($porPagina, 100) : 25;

        $auditsQuery = LoginAudit::query()->with('usuario')->latest();

        if ($evento !== 'todos') {
            $auditsQuery->where('evento', $evento);
        }

        if ($busqueda !== '') {
            $auditsQuery->where(function ($query) use ($busqueda) {
                $query->where('email', 'like', "%{$busqueda}%")
                    ->orWhere('ip_address', 'like', "%{$busqueda}%")
                    ->orWhereHas('usuario', function ($usuarioQuery) use ($busqueda) {
                        $usuarioQuery->where('nombre', 'like', "%{$busqueda}%");
                    });
            });
        }

        $audits = $auditsQuery->paginate($porPagina)->withQueryString();

        $eventosDisponibles = LoginAudit::select('evento')
            ->distinct()
            ->orderBy('evento')
            ->pluck('evento')
            ->all();

        return view('admin.auditoria.login', [
            'audits' => $audits,
            'filtros' => [
                'evento' => $evento,
                'q' => $busqueda,
                'por_pagina' => $porPagina,
            ],
            'eventosDisponibles' => $eventosDisponibles,
        ]);
    }
}
