<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class WeatherController extends Controller
{
    /**
     * Obtener datos meteorológicos actuales
     * GET /api/weather/current
     */
    public function current()
    {
        try {
            // Ruta al archivo con datos meteorológicos más recientes
            $weatherFile = '/home/scalarapp/scalar-data/api_weather_google/la-gloria-scalar/la_gloria_weather_raw.json';

            if (!file_exists($weatherFile)) {
                throw new \Exception('Archivo de datos meteorológicos no encontrado');
            }

            $weatherRaw = json_decode(file_get_contents($weatherFile), true);

            if (!$weatherRaw) {
                throw new \Exception('Error al leer datos meteorológicos');
            }

            // Extraer datos con la estructura correcta del JSON
            $weatherData = [
                'temperature' => $weatherRaw['temperature']['degrees'] ?? null,
                'feelsLike' => $weatherRaw['feelsLikeTemperature']['degrees'] ?? null,
                'humidity' => $weatherRaw['relativeHumidity'] ?? null,
                'windSpeed' => $weatherRaw['wind']['speed']['value'] ?? null,
                'windDirection' => $weatherRaw['wind']['direction']['cardinal'] ?? null,
                'precipitation' => $weatherRaw['precipitation']['probability']['percent'] ?? null,
                'cloudCover' => $weatherRaw['cloudCover'] ?? null,
                'uvIndex' => $weatherRaw['uvIndex'] ?? null,
                'visibility' => $weatherRaw['visibility']['distance']['value'] ?? null,
                'description' => $weatherRaw['weatherCondition']['description']['text'] ?? null,
                'conditionType' => $weatherRaw['weatherCondition']['type'] ?? null,
                'isDaytime' => $weatherRaw['isDaytime'] ?? null,
                'lastUpdate' => $weatherRaw['currentTime'] ?? now()->toIso8601String()
            ];

            // DEVOLVER DATOS DIRECTOS SIN WRAPPER (formato original)
            return response()->json($weatherData);
        } catch (\Exception $e) {
            \Log::error('Error al obtener datos meteorológicos', ['exception' => $e->getMessage()]);

            return response()->json([
                'success' => false,
                'message' => 'No fue posible obtener datos meteorológicos en tiempo real.',
                'error' => $e->getMessage()
            ], 503);
        }
    }
}
