<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Usuario;

class AuthApi
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Obtener token del header Authorization
        $token = $request->bearerToken();

        if (!$token) {
            return response()->json([
                'success' => false,
                'message' => 'Token no proporcionado. Por favor inicia sesión.'
            ], 401);
        }

        // Buscar usuario por token
        $usuario = Usuario::where('api_token', $token)->first();

        if (!$usuario) {
            return response()->json([
                'success' => false,
                'message' => 'Token inválido o expirado. Por favor inicia sesión nuevamente.'
            ], 401);
        }

        // Validar estado activo
        if ($usuario->estado !== 'activo') {
            return response()->json([
                'success' => false,
                'message' => 'Tu cuenta está ' . $usuario->estado . '. Contacta al administrador.'
            ], 403);
        }

        // Autenticar usuario en la request
        $request->setUserResolver(function () use ($usuario) {
            return $usuario;
        });

        return $next($request);
    }
}
