<?php

namespace App\Mail\Concerns;

use App\Models\SolicitudContactoScawatt;
use Illuminate\Support\Str;

trait InteractsWithSolicitudScawattThread
{
    protected function buildThreadSubject(SolicitudContactoScawatt $solicitud, string $etapa): string
    {
        $nombre = $solicitud->nombre_completo ?: ($solicitud->usuario?->nombre ?? 'Usuario');
        return sprintf('[Solicitud ScaWatt #%d] %s - %s', $solicitud->id, $etapa, $nombre);
    }

    protected function applyThreadHeaders(\Symfony\Component\Mime\Email $message, SolicitudContactoScawatt $solicitud, bool $root = false): void
    {
        $reference = $this->threadReference($solicitud);

        $headers = $message->getHeaders();
        $headers->remove('Message-ID');

        if ($root) {
            $headers->addIdHeader('Message-ID', $reference);
            return;
        }

        $headers->addIdHeader('Message-ID', $this->uniqueMessageId($solicitud));
        $headers->addTextHeader('In-Reply-To', $reference);
        $headers->addTextHeader('References', $reference);
    }

    protected function threadReference(SolicitudContactoScawatt $solicitud): string
    {
        $domain = $this->mailDomain();
        $token = $solicitud->mail_thread_token ?: 'thread';
        return 'solicitud-' . $solicitud->id . '-' . $token . '@' . $domain;
    }

    protected function uniqueMessageId(SolicitudContactoScawatt $solicitud): string
    {
        $domain = $this->mailDomain();
        $token = Str::uuid()->toString();
        return 'solicitud-' . $solicitud->id . '-' . $token . '@' . $domain;
    }

    protected function mailDomain(): string
    {
        $from = config('mail.from.address', 'notificaciones@scalar.com.co');

        if (strpos($from, '@') !== false) {
            return substr(strrchr($from, '@'), 1) ?: 'scalar.com.co';
        }

        return 'scalar.com.co';
    }
}
