<?php

namespace App\Mail;

use App\Mail\Concerns\InteractsWithSolicitudScawattThread;
use App\Models\SolicitudContactoScawatt;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NuevaSolicitudScawattAdminMail extends Mailable
{
    use InteractsWithSolicitudScawattThread;
    use Queueable, SerializesModels;

    public function __construct(public SolicitudContactoScawatt $solicitud, protected bool $root = false)
    {
    }

    public function build(): self
    {
        $subject = $this->buildThreadSubject($this->solicitud, 'Nueva solicitud');

        return $this
            ->subject($subject)
            ->view('emails.scawatt.nueva-solicitud-admin', [
                'solicitud' => $this->solicitud,
            ])
            ->withSymfonyMessage(function ($message) {
                $this->applyThreadHeaders($message, $this->solicitud, $this->root);
            });
    }
}
