<?php

namespace App\Mail;

use App\Models\Scawatt;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SolicitudDocumentosScawattMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Scawatt $scawatt,
        public string $codigo,
        public array $solicitante = []
    ) {
    }

    public function build(): self
    {
        return $this->subject('Código de autorización para documentos de ScaWatt')
            ->view('emails.scawatt.codigo_documentos')
            ->with([
                'scawatt' => $this->scawatt,
                'codigo' => $this->codigo,
                'solicitante' => $this->solicitante,
            ]);
    }
}
