<?php

namespace App\Mail;

use App\Mail\Concerns\InteractsWithSolicitudScawattThread;
use App\Models\SolicitudContactoScawatt;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SolicitudScawattDatosPendientesMail extends Mailable
{
    use InteractsWithSolicitudScawattThread;
    use Queueable, SerializesModels;

    public function __construct(
        public SolicitudContactoScawatt $solicitud,
        public array $pendientes = [],
        protected bool $root = false
    ) {
    }

    public function build(): self
    {
        $subject = $this->buildThreadSubject($this->solicitud, 'Completar datos');

        return $this
            ->subject($subject)
            ->view('emails.scawatt.datos-pendientes', [
                'solicitud' => $this->solicitud,
                'pendientes' => $this->pendientes,
            ])
            ->withSymfonyMessage(function ($message) {
                $this->applyThreadHeaders($message, $this->solicitud, $this->root);
            });
    }
}
