<?php

namespace App\Mail;

use App\Mail\Concerns\InteractsWithSolicitudScawattThread;
use App\Models\SolicitudContactoScawatt;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SolicitudScawattPagoConfirmadoMail extends Mailable
{
    use InteractsWithSolicitudScawattThread;
    use Queueable, SerializesModels;

    public function __construct(
        public SolicitudContactoScawatt $solicitud,
        public array $resumenScawatts = [],
        public ?string $linkContrato = null,
        public ?string $linkCertificado = null,
        protected bool $root = false
    ) {
    }

    public function build(): self
    {
        $subject = $this->buildThreadSubject($this->solicitud, 'Pago confirmado');

        return $this
            ->subject($subject)
            ->view('emails.scawatt.pago-confirmado', [
                'solicitud' => $this->solicitud,
                'resumenScawatts' => $this->resumenScawatts,
                'linkContrato' => $this->linkContrato,
                'linkCertificado' => $this->linkCertificado,
            ])
            ->withSymfonyMessage(function ($message) {
                $this->applyThreadHeaders($message, $this->solicitud, $this->root);
            });
    }
}
