<?php

namespace App\Mail;

use App\Mail\Concerns\InteractsWithSolicitudScawattThread;
use App\Models\SolicitudContactoScawatt;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SolicitudScawattPagoPendienteMail extends Mailable
{
    use InteractsWithSolicitudScawattThread;
    use Queueable, SerializesModels;

    public function __construct(
        public SolicitudContactoScawatt $solicitud,
        public string $linkPago,
        public float $monto,
        protected bool $root = false
    ) {
    }

    public function build(): self
    {
        $subject = $this->buildThreadSubject($this->solicitud, 'Pago pendiente');

        return $this
            ->subject($subject)
            ->view('emails.scawatt.pago-pendiente', [
                'solicitud' => $this->solicitud,
                'linkPago' => $this->linkPago,
                'monto' => $this->monto,
            ])
            ->withSymfonyMessage(function ($message) {
                $this->applyThreadHeaders($message, $this->solicitud, $this->root);
            });
    }
}
