<?php

namespace App\Models;

use Carbon\CarbonInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SolicitudDocumentosScawatt extends Model
{
    use HasFactory;

    protected $table = 'solicitudes_documentos_scawatt';

    protected $fillable = [
        'scawatt_id',
        'propietario_id',
        'codigo_hash',
        'codigo_preview',
        'estado',
        'intentos',
        'solicitante_nombre',
        'solicitante_email',
        'solicitante_telefono',
        'motivo',
        'expires_at',
        'enviado_at',
        'autorizado_at',
        'finalizado_at',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'enviado_at' => 'datetime',
        'autorizado_at' => 'datetime',
        'finalizado_at' => 'datetime',
    ];

    public function scawatt()
    {
        return $this->belongsTo(Scawatt::class);
    }

    public function propietario()
    {
        return $this->belongsTo(Usuario::class, 'propietario_id');
    }

    public function estaExpirada(): bool
    {
        if (!$this->expires_at instanceof CarbonInterface) {
            return false;
        }

        return now()->greaterThan($this->expires_at);
    }
}
