<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fcm_tokens', function (Blueprint $table) {
            $table->id();
            $table->foreignId('usuario_id')->constrained('usuarios')->onDelete('cascade');
            $table->string('fcm_token', 500);
            $table->string('platform', 20)->default('ios'); // ios, android, web
            $table->string('device_id', 255)->nullable(); // Identificador único del dispositivo
            $table->timestamp('last_used_at')->nullable(); // Última vez que se usó el token
            $table->timestamps();
            
            // Índices
            $table->index('usuario_id');
            $table->index('platform');
            
            // Un usuario puede tener el mismo token solo una vez (evita duplicados)
            $table->unique(['usuario_id', 'fcm_token']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fcm_tokens');
    }
};
