<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasColumn('auditoria_admin', 'modulo')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->string('modulo')->nullable()->after('accion');
            });
        }

        if (!Schema::hasColumn('auditoria_admin', 'entidad_tipo')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->string('entidad_tipo')->nullable()->after('modulo');
            });
        }

        if (!Schema::hasColumn('auditoria_admin', 'entidad_id')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->unsignedBigInteger('entidad_id')->nullable()->after('entidad_tipo');
            });
        }

        if (!Schema::hasColumn('auditoria_admin', 'datos_anteriores')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->json('datos_anteriores')->nullable()->after('entidad_id');
            });
        }

        if (!Schema::hasColumn('auditoria_admin', 'datos_nuevos')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->json('datos_nuevos')->nullable()->after('datos_anteriores');
            });
        }

        if (!Schema::hasColumn('auditoria_admin', 'descripcion')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->text('descripcion')->nullable()->after('user_agent');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'tabla_afectada')) {
            DB::table('auditoria_admin')
                ->whereNull('modulo')
                ->update(['modulo' => DB::raw("NULLIF(tabla_afectada, '')")]);

            DB::table('auditoria_admin')
                ->whereNull('entidad_tipo')
                ->update(['entidad_tipo' => DB::raw('tabla_afectada')]);
        }

        if (Schema::hasColumn('auditoria_admin', 'registro_id')) {
            DB::table('auditoria_admin')
                ->whereNull('entidad_id')
                ->update(['entidad_id' => DB::raw('registro_id')]);
        }

        if (Schema::hasColumn('auditoria_admin', 'datos_antes')) {
            DB::table('auditoria_admin')
                ->whereNull('datos_anteriores')
                ->update(['datos_anteriores' => DB::raw('datos_antes')]);
        }

        if (Schema::hasColumn('auditoria_admin', 'datos_despues')) {
            DB::table('auditoria_admin')
                ->whereNull('datos_nuevos')
                ->update(['datos_nuevos' => DB::raw('datos_despues')]);
        }

        if (Schema::hasColumn('auditoria_admin', 'fecha_accion')) {
            DB::table('auditoria_admin')
                ->whereNotNull('fecha_accion')
                ->whereNull('created_at')
                ->update(['created_at' => DB::raw('fecha_accion')]);
        }

        if (Schema::hasColumn('auditoria_admin', 'tabla_afectada')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('tabla_afectada');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'registro_id')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('registro_id');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'datos_antes')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('datos_antes');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'datos_despues')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('datos_despues');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'fecha_accion')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('fecha_accion');
            });
        }
    }

    public function down(): void
    {
        if (!Schema::hasColumn('auditoria_admin', 'tabla_afectada')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->string('tabla_afectada')->nullable()->after('accion');
            });
        }

        if (!Schema::hasColumn('auditoria_admin', 'registro_id')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->unsignedBigInteger('registro_id')->nullable()->after('tabla_afectada');
            });
        }

        if (!Schema::hasColumn('auditoria_admin', 'datos_antes')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->json('datos_antes')->nullable()->after('registro_id');
            });
        }

        if (!Schema::hasColumn('auditoria_admin', 'datos_despues')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->json('datos_despues')->nullable()->after('datos_antes');
            });
        }

        if (!Schema::hasColumn('auditoria_admin', 'fecha_accion')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->timestamp('fecha_accion')->nullable()->after('user_agent');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'entidad_tipo')) {
            DB::table('auditoria_admin')
                ->whereNull('tabla_afectada')
                ->update(['tabla_afectada' => DB::raw('entidad_tipo')]);
        }

        if (Schema::hasColumn('auditoria_admin', 'entidad_id')) {
            DB::table('auditoria_admin')
                ->whereNull('registro_id')
                ->update(['registro_id' => DB::raw('entidad_id')]);
        }

        if (Schema::hasColumn('auditoria_admin', 'datos_anteriores')) {
            DB::table('auditoria_admin')
                ->whereNull('datos_antes')
                ->update(['datos_antes' => DB::raw('datos_anteriores')]);
        }

        if (Schema::hasColumn('auditoria_admin', 'datos_nuevos')) {
            DB::table('auditoria_admin')
                ->whereNull('datos_despues')
                ->update(['datos_despues' => DB::raw('datos_nuevos')]);
        }

        if (Schema::hasColumn('auditoria_admin', 'created_at')) {
            DB::table('auditoria_admin')
                ->whereNotNull('created_at')
                ->whereNull('fecha_accion')
                ->update(['fecha_accion' => DB::raw('created_at')]);
        }

        if (Schema::hasColumn('auditoria_admin', 'modulo')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('modulo');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'entidad_tipo')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('entidad_tipo');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'entidad_id')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('entidad_id');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'datos_anteriores')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('datos_anteriores');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'datos_nuevos')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('datos_nuevos');
            });
        }

        if (Schema::hasColumn('auditoria_admin', 'descripcion')) {
            Schema::table('auditoria_admin', function (Blueprint $table) {
                $table->dropColumn('descripcion');
            });
        }
    }
};
