<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('depositos', function (Blueprint $table) {
            $table->dropForeign(['aprobado_por']);
            $table->foreign('aprobado_por')
                ->references('id')
                ->on('usuarios')
                ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('depositos', function (Blueprint $table) {
            $table->dropForeign(['aprobado_por']);
            $table->foreign('aprobado_por')
                ->references('id')
                ->on('users')
                ->nullOnDelete();
        });
    }
};
