<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('solicitudes_contacto_scawatt', function (Blueprint $table) {
            $table->unsignedBigInteger('estado_actualizado_por')->nullable()->after('atendido_por');
            $table->string('link_pago', 512)->nullable()->after('presupuesto_aproximado');
            $table->decimal('monto_pago', 12, 2)->nullable()->after('link_pago');
            $table->timestamp('fecha_pago')->nullable()->after('monto_pago');
            $table->string('mail_thread_token', 120)->nullable()->after('fecha_pago');
            $table->timestamp('ultima_notificacion_enviada_at')->nullable()->after('mail_thread_token');
            $table->json('historial_eventos')->nullable()->after('ultima_notificacion_enviada_at');

            $table->foreign('estado_actualizado_por')
                ->references('id')
                ->on('usuarios')
                ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('solicitudes_contacto_scawatt', function (Blueprint $table) {
            $table->dropForeign(['estado_actualizado_por']);
            $table->dropColumn([
                'estado_actualizado_por',
                'link_pago',
                'monto_pago',
                'fecha_pago',
                'mail_thread_token',
                'ultima_notificacion_enviada_at',
                'historial_eventos',
            ]);
        });
    }
};
