@extends('layouts.app')

@section('title', 'Auditoría de accesos')
@section('page-title', 'Auditoría de accesos')
@section('page-subtitle', 'Revisa intentos de inicio de sesión y cierres de sesión del panel maestro')

@section('page-actions')
<div class="d-flex gap-2">
    <a href="{{ route('admin.dashboard') }}" class="btn btn-sm btn-outline-secondary">
        <i class="fas fa-arrow-left me-1"></i> Volver al dashboard
    </a>
</div>
@endsection

@section('content')
@php
    $eventLabels = [
        'login_success' => 'Ingreso exitoso',
        'login_failed' => 'Intento fallido',
        'login_denied_no_master' => 'Denegado (sin permisos)',
        'logout' => 'Cierre de sesión',
    ];
@endphp

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="get" class="row g-3 align-items-end">
            <div class="col-lg-3 col-md-4">
                <label for="evento" class="form-label small text-uppercase text-muted mb-1">Evento</label>
                <select id="evento" name="evento" class="form-select form-select-sm">
                    <option value="todos" @selected($filtros['evento'] === 'todos')>Todos</option>
                    @foreach($eventosDisponibles as $evento)
                        <option value="{{ $evento }}" @selected($filtros['evento'] === $evento)>{{ $eventLabels[$evento] ?? ucfirst(str_replace('_', ' ', $evento)) }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-lg-3 col-md-4">
                <label for="q" class="form-label small text-uppercase text-muted mb-1">Buscar</label>
                <input type="search" id="q" name="q" value="{{ $filtros['q'] }}" class="form-control form-control-sm" placeholder="Nombre, correo o IP">
            </div>
            <div class="col-lg-2 col-md-4">
                <label for="por_pagina" class="form-label small text-uppercase text-muted mb-1">Por página</label>
                <input type="number" id="por_pagina" name="por_pagina" value="{{ $filtros['por_pagina'] }}" min="10" max="100" class="form-control form-control-sm">
            </div>
            <div class="col-lg-2 col-md-4 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary flex-fill">
                    <i class="fas fa-filter me-1"></i> Filtrar
                </button>
                <a href="{{ route('admin.auditoria.login') }}" class="btn btn-sm btn-outline-secondary" title="Limpiar filtros">
                    <i class="fas fa-rotate-right"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<div class="card shadow-sm border-0">
    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
        <div>
            <h6 class="mb-0">Movimientos registrados</h6>
            <small class="text-muted">{{ $audits->total() }} eventos en histórico</small>
        </div>
        <span class="badge bg-dark-subtle text-dark">
            {{ $audits->firstItem() ?? 0 }}-{{ $audits->lastItem() ?? 0 }}
        </span>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Fecha</th>
                        <th>Evento</th>
                        <th>Usuario</th>
                        <th>Correo</th>
                        <th>IP</th>
                        <th>Navegador</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($audits as $audit)
                        <tr>
                            <td>
                                <div class="fw-semibold">{{ $audit->created_at?->format('d M Y · H:i') ?? 'N/D' }}</div>
                                <small class="text-muted">{{ $audit->created_at?->diffForHumans() ?? '' }}</small>
                            </td>
                            <td>
                                <span class="badge {{ $audit->evento === 'login_success' ? 'bg-success' : ($audit->evento === 'logout' ? 'bg-secondary' : ($audit->evento === 'login_failed' ? 'bg-danger' : 'bg-warning text-dark')) }}">
                                    {{ $eventLabels[$audit->evento] ?? ucfirst(str_replace('_', ' ', $audit->evento)) }}
                                </span>
                            </td>
                            <td>
                                <div class="fw-semibold">{{ $audit->usuario?->nombre ?? 'N/D' }}</div>
                                @if($audit->usuario)
                                    <small class="text-muted">ID #{{ $audit->usuario->id }}</small>
                                @endif
                            </td>
                            <td>
                                <div class="fw-semibold">{{ $audit->email ?? 'N/D' }}</div>
                            </td>
                            <td>
                                <div class="fw-semibold">{{ $audit->ip_address ?? 'N/D' }}</div>
                            </td>
                            <td style="max-width: 260px;">
                                <small class="text-muted d-block text-truncate" title="{{ $audit->user_agent }}">{{ $audit->user_agent ?? 'Navegador no identificado' }}</small>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted py-5">No se encontraron eventos con los filtros seleccionados.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    <div class="card-footer bg-white border-0">
        <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-2">
            <small class="text-muted">Último registro: {{ optional($audits->first())->created_at?->diffForHumans() ?? 'Sin datos' }}</small>
            {{ $audits->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection
