@extends('layouts.app')

@section('title', 'Granjas solares')
@section('page-title', 'Granjas solares')
@section('page-subtitle', 'Monitorea la capacidad instalada, producción y ScaWatts vinculados por granja')

@section('page-actions')
<div class="d-flex gap-2">
    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#modalAdministrarGranja">
        <i class="fas fa-plus me-1"></i> Nueva granja
    </button>
    <a href="{{ route('admin.scawatts') }}" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-solar-panel me-1"></i> Inventario ScaWatts
    </a>
    <a href="{{ route('admin.marketplace') }}" class="btn btn-sm btn-secondary">
        <i class="fas fa-store me-1"></i> Marketplace
    </a>
</div>
@endsection

@section('content')
@php
    $estadoOptions = [
        'todas' => 'Todos los estados',
        'operativa' => 'Operativas',
        'construccion' => 'En construcción',
        'planificada' => 'Planificadas',
        'mantenimiento' => 'En mantenimiento',
    ];

    $ordenOptions = [
        'recientes' => 'Más recientes',
        'capacidad' => 'Mayor capacidad',
        'produccion' => 'Mayor producción',
        'scawatts' => 'Más ScaWatts',
        'valor' => 'Mayor valorización',
    ];

    $estadoBadges = [
        'operativa' => 'bg-success',
        'construccion' => 'bg-warning text-dark',
        'planificada' => 'bg-info text-dark',
        'mantenimiento' => 'bg-secondary',
    ];

    $estadosFormulario = [
        'operativa' => 'Operativa',
        'construccion' => 'En construcción',
        'planificada' => 'Planificada',
        'mantenimiento' => 'En mantenimiento',
    ];

    $categoriasFormulario = [
        '' => 'Sin categoría',
        'granja_solar' => 'Granja solar',
        'parque_solar' => 'Parque solar',
        'industrial' => 'Industrial',
        'domestico' => 'Doméstico',
        'vehicular' => 'Vehicular',
    ];
@endphp

@if (session('status'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-circle-check me-1"></i>{{ session('status') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
    </div>
@endif

@if ($errors->any())
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-triangle-exclamation me-1"></i>Revisa la información del formulario y vuelve a intentarlo.
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
    </div>
@endif

<div class="row g-3 mb-1">
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Granjas registradas</p>
                        <h4 class="fw-semibold mb-0">{{ number_format($stats['total']) }}</h4>
                    </div>
                    <span class="icon-circle bg-success-subtle text-success"><i class="fas fa-seedling"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Granjas operativas</p>
                        <h4 class="fw-semibold mb-0">{{ number_format($stats['operativas']) }}</h4>
                    </div>
                    <span class="icon-circle bg-primary-subtle text-primary"><i class="fas fa-sun"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Capacidad instalada</p>
                        <h4 class="fw-semibold mb-0">{{ $stats['capacidad_total'] }} MW</h4>
                    </div>
                    <span class="icon-circle bg-info-subtle text-info"><i class="fas fa-bolt"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Producción anual</p>
                        <h4 class="fw-semibold mb-0">{{ $stats['produccion_total'] }} MWh</h4>
                    </div>
                    <span class="icon-circle bg-warning-subtle text-warning"><i class="fas fa-chart-area"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">ScaWatts vinculados</p>
                        <h4 class="fw-semibold mb-0">{{ number_format($stats['scawatts']) }}</h4>
                    </div>
                    <span class="icon-circle bg-secondary-subtle text-secondary"><i class="fas fa-cubes"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Valor ScaWatts</p>
                        <h4 class="fw-semibold mb-0">{{ $stats['valor_scawatts'] }}</h4>
                    </div>
                    <span class="icon-circle bg-dark-subtle text-dark"><i class="fas fa-coins"></i></span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="get" class="row g-3 align-items-end">
            <div class="col-xl-3 col-md-4">
                <label for="estado" class="form-label small text-uppercase text-muted mb-1">Estado</label>
                <select id="estado" name="estado" class="form-select form-select-sm">
                    @foreach($estadoOptions as $value => $label)
                        <option value="{{ $value }}" @selected($filtros['estado'] === $value)>{{ $label }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-xl-3 col-md-4">
                <label for="departamento" class="form-label small text-uppercase text-muted mb-1">Departamento</label>
                <select id="departamento" name="departamento" class="form-select form-select-sm">
                    <option value="todos" @selected($filtros['departamento'] === 'todos')>Todos</option>
                    @foreach($departamentos as $dep)
                        <option value="{{ $dep }}" @selected($filtros['departamento'] === $dep)>{{ $dep }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="orden" class="form-label small text-uppercase text-muted mb-1">Orden</label>
                <select id="orden" name="orden" class="form-select form-select-sm">
                    @foreach($ordenOptions as $value => $label)
                        <option value="{{ $value }}" @selected($filtros['orden'] === $value)>{{ $label }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="por_pagina" class="form-label small text-uppercase text-muted mb-1">Por página</label>
                <input type="number" min="6" max="60" id="por_pagina" name="por_pagina" value="{{ $filtros['por_pagina'] }}" class="form-control form-control-sm">
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="q" class="form-label small text-uppercase text-muted mb-1">Buscar</label>
                <input type="search" id="q" name="q" value="{{ $filtros['q'] }}" class="form-control form-control-sm" placeholder="Nombre, municipio, categoría...">
            </div>
            <div class="col-xl-2 col-md-4 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary flex-fill">
                    <i class="fas fa-filter me-1"></i> Aplicar
                </button>
                <a href="{{ route('admin.granjas') }}" class="btn btn-sm btn-outline-secondary" title="Limpiar filtros">
                    <i class="fas fa-rotate-right"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<div class="row g-3">
    <div class="col-xxl-9 col-xl-8">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="mb-0">Listado de granjas</h6>
                    <small class="text-muted">Mostrando {{ $granjas->firstItem() ?? 0 }}-{{ $granjas->lastItem() ?? 0 }} de {{ $granjas->total() }} registros</small>
                </div>
                <span class="badge bg-primary-subtle text-primary">{{ strtoupper($filtros['estado']) }}</span>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    @forelse($granjas as $granja)
                        @php
                            $badgeClass = $estadoBadges[$granja->estado] ?? 'bg-dark';
                            $valorActual = $granja->scawatts_sum_valor_actual ?? 0;
                        @endphp
                        <div class="col-xl-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <div>
                                            <h5 class="mb-1">{{ $granja->nombre }}</h5>
                                            <div class="text-muted small">
                                                <i class="fas fa-location-dot me-1"></i>{{ $granja->municipio ?? 'Municipio N/D' }}, {{ $granja->departamento ?? 'Departamento N/D' }}
                                            </div>
                                        </div>
                                        <div class="text-end">
                                            <span class="badge {{ $badgeClass }}">{{ $granja->estado_formateado ?? ucfirst($granja->estado ?? 'N/D') }}</span>
                                            @if($granja->categoria)
                                                <div><small class="badge bg-light text-dark mt-1">{{ ucfirst(str_replace('_', ' ', $granja->categoria)) }}</small></div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="row g-2 mb-2">
                                        <div class="col-6">
                                            <div class="small text-muted">Capacidad</div>
                                            <div class="fw-semibold">{{ number_format((float) ($granja->capacidad_mw ?? 0), 2, ',', '.') }} MW</div>
                                        </div>
                                        <div class="col-6">
                                            <div class="small text-muted">Producción anual</div>
                                            <div class="fw-semibold">{{ number_format((float) ($granja->produccion_estimada_anual ?? 0), 2, ',', '.') }} MWh</div>
                                        </div>
                                        <div class="col-6">
                                            <div class="small text-muted">ScaWatts asociados</div>
                                            <div class="fw-semibold">{{ number_format($granja->scawatts_count) }}</div>
                                        </div>
                                        <div class="col-6">
                                            <div class="small text-muted">Valor portafolio</div>
                                            <div class="fw-semibold">${{ number_format((float) $valorActual, 0, ',', '.') }}</div>
                                        </div>
                                    </div>
                                    <p class="text-muted small mb-0">
                                        <i class="fas fa-calendar me-1"></i>Inicio operación: {{ $granja->fecha_inicio_operacion?->format('d M Y') ?? 'N/D' }} · Vida útil: {{ $granja->vida_util_años ? $granja->vida_util_años . ' años' : 'N/D' }}
                                    </p>
                                </div>
                                <div class="card-footer bg-white border-0 d-flex justify-content-between align-items-center">
                                    <div class="text-muted small">Actualizada {{ $granja->updated_at?->diffForHumans() ?? 'N/D' }}</div>
                                    <div class="btn-group">
                                            <a href="{{ route('admin.scawatts', ['granja' => $granja->id]) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-hashtag me-1"></i>ScaWatts
                                        </a>
                                            <button
                                                type="button"
                                                class="btn btn-sm btn-outline-secondary"
                                                data-bs-toggle="modal"
                                                data-bs-target="#modalAdministrarGranja"
                                                data-mode="edit"
                                                data-action="{{ route('admin.granjas.update', $granja) }}"
                                                data-nombre="{{ $granja->nombre }}"
                                                data-estado="{{ $granja->estado }}"
                                                data-categoria="{{ $granja->categoria }}"
                                                data-departamento="{{ $granja->departamento }}"
                                                data-municipio="{{ $granja->municipio }}"
                                                data-direccion="{{ $granja->direccion_completa }}"
                                                data-latitud="{{ $granja->latitud }}"
                                                data-longitud="{{ $granja->longitud }}"
                                                data-capacidad="{{ $granja->capacidad_mw }}"
                                                data-produccion="{{ $granja->produccion_estimada_anual }}"
                                                data-vida-util="{{ $granja->vida_util_años }}"
                                                data-tasa-valorizacion="{{ $granja->tasa_valorizacion_anual }}"
                                                data-ganancia="{{ $granja->ganancia_mensual_base }}"
                                                data-fecha-inicio="{{ optional($granja->fecha_inicio_operacion)->format('Y-m-d') }}"
                                                data-fecha-final="{{ optional($granja->fecha_final_operacion)->format('Y-m-d') }}"
                                                data-descripcion="{{ $granja->descripcion ? e($granja->descripcion) : '' }}"
                                                data-imagen-url="{{ $granja->imagen_url }}"
                                            >
                                                <i class="fas fa-pen-to-square"></i>
                                            </button>
                                        @if($granja->latitud && $granja->longitud)
                                            <a href="https://maps.google.com/?q={{ $granja->latitud }},{{ $granja->longitud }}" class="btn btn-sm btn-outline-secondary" target="_blank" rel="noopener">
                                                <i class="fas fa-map-marked-alt"></i>
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="col-12">
                            <div class="text-center text-muted py-5">
                                No encontramos granjas con los filtros seleccionados.
                            </div>
                        </div>
                    @endforelse
                </div>
            </div>
            <div class="card-footer bg-white border-0">
                <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-2">
                    <small class="text-muted">Capacidad consolidada: {{ $stats['capacidad_total'] }} MW</small>
                    {{ $granjas->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-3 col-xl-4">
        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Estados operativos</h6>
                <span class="badge bg-dark-subtle text-dark">{{ number_format($stats['total']) }}</span>
            </div>
            <div class="card-body">
                @forelse($segmentacionEstados as $segmento)
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <div class="fw-semibold">{{ ucfirst(str_replace('_', ' ', $segmento->estado ?? 'N/D')) }}</div>
                        <span class="badge bg-light text-dark">{{ number_format($segmento->total) }}</span>
                    </div>
                @empty
                    <p class="text-muted mb-0">Sin datos disponibles.</p>
                @endforelse
            </div>
        </div>

        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Top producción anual</h6>
                <span class="badge bg-info-subtle text-info">{{ $topProduccion->count() }}</span>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    @forelse($topProduccion as $item)
                        <li class="list-group-item d-flex justify-content-between align-items-start">
                            <div>
                                <div class="fw-semibold">{{ $item->nombre }}</div>
                                <small class="text-muted">Capacidad: {{ number_format((float) ($item->capacidad_mw ?? 0), 2, ',', '.') }} MW</small>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-success">{{ number_format((float) ($item->produccion_estimada_anual ?? 0), 2, ',', '.') }} MWh</span>
                            </div>
                        </li>
                    @empty
                        <li class="list-group-item text-center text-muted py-4">Sin información disponible</li>
                    @endforelse
                </ul>
            </div>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-header bg-white border-0">
                <h6 class="mb-0">Notas operativas</h6>
            </div>
            <div class="card-body">
                <p class="text-muted small mb-2"><i class="fas fa-circle-info me-1"></i>Usa el atajo <code>Alt + K</code> para filtrar rápidamente por departamento en el buscador.</p>
                <p class="text-muted small mb-2"><i class="fas fa-circle-info me-1"></i>Los valores de portafolio provienen del total de ScaWatts activos en cada granja.</p>
                <p class="text-muted small mb-0"><i class="fas fa-circle-info me-1"></i>Haz clic en el ícono de mapa para validar coordenadas en Google Maps.</p>
            </div>
        </div>
    </div>
</div>
@endsection

<div class="modal fade" id="modalAdministrarGranja" tabindex="-1" aria-labelledby="modalAdministrarGranjaLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <form method="post" action="{{ route('admin.granjas.store') }}" data-store-action="{{ route('admin.granjas.store') }}" id="formAdministrarGranja">
                @csrf
                <input type="hidden" name="_method" value="PUT" disabled>
                <div class="modal-header">
                    <h5 class="modal-title" id="modalAdministrarGranjaLabel" data-role="modal-title">
                        <i class="fas fa-seedling me-2"></i>Crear nueva granja
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="granja-nombre" class="form-label">Nombre *</label>
                            <input type="text" id="granja-nombre" name="nombre" class="form-control" maxlength="150" required>
                        </div>
                        <div class="col-md-3">
                            <label for="granja-estado" class="form-label">Estado *</label>
                            <select id="granja-estado" name="estado" class="form-select" required>
                                @foreach($estadosFormulario as $value => $label)
                                    <option value="{{ $value }}">{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="granja-categoria" class="form-label">Categoría</label>
                            <select id="granja-categoria" name="categoria" class="form-select">
                                @foreach($categoriasFormulario as $value => $label)
                                    <option value="{{ $value }}">{{ $label }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="granja-departamento" class="form-label">Departamento</label>
                            <input type="text" id="granja-departamento" name="departamento" class="form-control" maxlength="120">
                        </div>
                        <div class="col-md-4">
                            <label for="granja-municipio" class="form-label">Municipio</label>
                            <input type="text" id="granja-municipio" name="municipio" class="form-control" maxlength="120">
                        </div>
                        <div class="col-md-4">
                            <label for="granja-direccion" class="form-label">Dirección</label>
                            <input type="text" id="granja-direccion" name="direccion_completa" class="form-control" maxlength="255">
                        </div>
                        <div class="col-md-6">
                            <label for="granja-latitud" class="form-label">Latitud</label>
                            <input type="number" step="0.000001" id="granja-latitud" name="latitud" class="form-control" min="-90" max="90">
                        </div>
                        <div class="col-md-6">
                            <label for="granja-longitud" class="form-label">Longitud</label>
                            <input type="number" step="0.000001" id="granja-longitud" name="longitud" class="form-control" min="-180" max="180">
                        </div>
                        <div class="col-md-4">
                            <label for="granja-capacidad" class="form-label">Capacidad (MW)</label>
                            <input type="number" step="0.01" min="0" id="granja-capacidad" name="capacidad_mw" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label for="granja-produccion" class="form-label">Producción anual (MWh)</label>
                            <input type="number" step="0.01" min="0" id="granja-produccion" name="produccion_estimada_anual" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label for="granja-ganancia" class="form-label">Ganancia mensual base (COP)</label>
                            <input type="number" step="0.01" id="granja-ganancia" name="ganancia_mensual_base" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label for="granja-fecha-inicio" class="form-label">Inicio operación</label>
                            <input type="date" id="granja-fecha-inicio" name="fecha_inicio_operacion" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label for="granja-fecha-final" class="form-label">Fin estimado</label>
                            <input type="date" id="granja-fecha-final" name="fecha_final_operacion" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label for="granja-vida-util" class="form-label">Vida útil (años)</label>
                            <input type="number" min="0" max="100" id="granja-vida-util" name="vida_util_años" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label for="granja-tasa-valorizacion" class="form-label">Tasa valorización anual (%)</label>
                            <input type="number" step="0.01" min="-100" max="100" id="granja-tasa-valorizacion" name="tasa_valorizacion_anual" class="form-control">
                        </div>
                        <div class="col-12">
                            <label for="granja-imagen-url" class="form-label">Imagen (URL)</label>
                            <input type="url" id="granja-imagen-url" name="imagen_url" class="form-control" maxlength="255" placeholder="https://...">
                        </div>
                        <div class="col-12">
                            <label for="granja-descripcion" class="form-label">Descripción</label>
                            <textarea id="granja-descripcion" name="descripcion" class="form-control" rows="3"></textarea>
                        </div>
                    </div>
                    <p class="text-muted small mt-3 mb-0"><i class="fas fa-shield-check me-1"></i>Solo usuarios Master pueden gestionar esta información.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary" data-role="submit-text">Registrar</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', () => {
    const modalEl = document.getElementById('modalAdministrarGranja');
    if (!modalEl) {
        return;
    }

    const form = modalEl.querySelector('#formAdministrarGranja');
    const methodInput = form.querySelector('input[name="_method"]');
    const titleEl = modalEl.querySelector('[data-role="modal-title"]');
    const submitBtn = modalEl.querySelector('[data-role="submit-text"]');
    const storeAction = form.dataset.storeAction;

    const fields = {
        nombre: form.querySelector('#granja-nombre'),
        estado: form.querySelector('#granja-estado'),
        categoria: form.querySelector('#granja-categoria'),
        departamento: form.querySelector('#granja-departamento'),
        municipio: form.querySelector('#granja-municipio'),
        direccion: form.querySelector('#granja-direccion'),
        latitud: form.querySelector('#granja-latitud'),
        longitud: form.querySelector('#granja-longitud'),
        capacidad: form.querySelector('#granja-capacidad'),
        produccion: form.querySelector('#granja-produccion'),
        ganancia: form.querySelector('#granja-ganancia'),
        fechaInicio: form.querySelector('#granja-fecha-inicio'),
        fechaFinal: form.querySelector('#granja-fecha-final'),
        vidaUtil: form.querySelector('#granja-vida-util'),
        tasaValorizacion: form.querySelector('#granja-tasa-valorizacion'),
        descripcion: form.querySelector('#granja-descripcion'),
        imagenUrl: form.querySelector('#granja-imagen-url'),
    };

    modalEl.addEventListener('show.bs.modal', (event) => {
        const trigger = event.relatedTarget;
        const isEdit = trigger && trigger.getAttribute('data-mode') === 'edit';

        if (isEdit) {
            form.action = trigger.getAttribute('data-action');
            methodInput.disabled = false;
            methodInput.value = 'PUT';
            titleEl.innerHTML = '<i class="fas fa-pen-to-square me-2"></i>Editar granja';
            submitBtn.textContent = 'Guardar cambios';

            fields.nombre.value = trigger.getAttribute('data-nombre') || '';

            const estado = trigger.getAttribute('data-estado') || 'operativa';
            if (Array.from(fields.estado.options).some(option => option.value === estado)) {
                fields.estado.value = estado;
            } else {
                fields.estado.value = 'operativa';
            }

            const categoria = trigger.getAttribute('data-categoria') || '';
            if (categoria) {
                const hasOption = Array.from(fields.categoria.options).some(option => option.value === categoria);
                if (!hasOption) {
                    const option = document.createElement('option');
                    option.value = categoria;
                    option.textContent = categoria.replace(/_/g, ' ').replace(/\b\w/g, (char) => char.toUpperCase());
                    fields.categoria.insertBefore(option, fields.categoria.firstChild);
                }
                fields.categoria.value = categoria;
            } else {
                fields.categoria.value = '';
            }
            fields.departamento.value = trigger.getAttribute('data-departamento') || '';
            fields.municipio.value = trigger.getAttribute('data-municipio') || '';
            fields.direccion.value = trigger.getAttribute('data-direccion') || '';
            fields.latitud.value = trigger.getAttribute('data-latitud') || '';
            fields.longitud.value = trigger.getAttribute('data-longitud') || '';
            fields.capacidad.value = trigger.getAttribute('data-capacidad') || '';
            fields.produccion.value = trigger.getAttribute('data-produccion') || '';
            fields.ganancia.value = trigger.getAttribute('data-ganancia') || '';
            fields.fechaInicio.value = trigger.getAttribute('data-fecha-inicio') || '';
            fields.fechaFinal.value = trigger.getAttribute('data-fecha-final') || '';
            fields.vidaUtil.value = trigger.getAttribute('data-vida-util') || '';
            fields.tasaValorizacion.value = trigger.getAttribute('data-tasa-valorizacion') || '';
            fields.descripcion.value = trigger.getAttribute('data-descripcion') || '';
            fields.imagenUrl.value = trigger.getAttribute('data-imagen-url') || '';
        } else {
            form.action = storeAction;
            methodInput.disabled = true;
            form.reset();
            fields.estado.value = 'operativa';
            titleEl.innerHTML = '<i class="fas fa-seedling me-2"></i>Crear nueva granja';
            submitBtn.textContent = 'Registrar';
        }
    });

    modalEl.addEventListener('hidden.bs.modal', () => {
        form.action = storeAction;
        methodInput.disabled = true;
        form.reset();
        fields.estado.value = 'operativa';
        titleEl.innerHTML = '<i class="fas fa-seedling me-2"></i>Crear nueva granja';
        submitBtn.textContent = 'Registrar';
    });
});
</script>
@endpush
