@php
    $usuariosDisponibles = $usuariosDisponibles ?? collect();
@endphp

<div class="modal fade" id="modalDepositoManual" tabindex="-1" aria-labelledby="modalDepositoManualLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form method="post" action="{{ route('admin.transacciones.depositos.manual') }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="modalDepositoManualLabel">
                        <i class="fas fa-circle-plus text-success me-2"></i>Registrar depósito manual
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info small" role="alert">
                        <i class="fas fa-info-circle me-2"></i>El depósito se acreditará de inmediato al saldo disponible del usuario y quedará registrado en auditoría.
                    </div>
                    <div class="mb-3">
                        <label for="depositoManualUsuario" class="form-label">Usuario</label>
                        <select id="depositoManualUsuario" name="usuario_id" class="form-select" required>
                            <option value="">Selecciona un usuario</option>
                            @foreach($usuariosDisponibles as $usuario)
                                <option value="{{ $usuario->id }}">{{ $usuario->nombre ?? $usuario->email }} — {{ $usuario->email }}</option>
                            @endforeach
                        </select>
                        <div class="form-text">Escribe para filtrar por nombre o correo.</div>
                        <div class="form-text text-success d-none" data-role="usuarioSeleccionado"></div>
                    </div>
                    <div class="mb-3">
                        <label for="depositoManualMonto" class="form-label">Monto a acreditar</label>
                        <div class="input-group">
                            <span class="input-group-text">$</span>
                            <input type="number" class="form-control" id="depositoManualMonto" name="monto" min="1000" step="0.01" required placeholder="0.00">
                        </div>
                        <div class="form-text">El monto se sumará al saldo disponible y total.</div>
                    </div>
                    <div class="mb-3">
                        <label for="depositoManualMetodo" class="form-label">Método / origen del depósito</label>
                        <select id="depositoManualMetodo" name="metodo_pago" class="form-select" required>
                            <option value="">Selecciona un método</option>
                            <option value="transferencia">Transferencia bancaria</option>
                            <option value="consignacion">Consignación</option>
                            <option value="efectivo">Efectivo</option>
                            <option value="ajuste">Ajuste contable</option>
                            <option value="otro">Otro</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="depositoManualReferencia" class="form-label">Referencia bancaria (opcional)</label>
                        <input type="text" class="form-control" id="depositoManualReferencia" name="referencia" maxlength="100" placeholder="Ej: TRANS-123456">
                    </div>
                    <div class="mb-0">
                        <label for="depositoManualDescripcion" class="form-label">Notas internas (opcional)</label>
                        <textarea id="depositoManualDescripcion" name="descripcion" class="form-control" rows="3" placeholder="Detalle de conciliación o motivo del depósito"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success">Registrar y acreditar</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
if (!window.__modalDepositoManualInit) {
    window.__modalDepositoManualInit = true;

    document.addEventListener('DOMContentLoaded', () => {
        const modalDepositoManual = document.getElementById('modalDepositoManual');
        if (!modalDepositoManual) {
            return;
        }

        modalDepositoManual.addEventListener('show.bs.modal', event => {
            const button = event.relatedTarget;
            const form = modalDepositoManual.querySelector('form');
            if (form) {
                form.reset();
            }

            const helper = modalDepositoManual.querySelector('[data-role="usuarioSeleccionado"]');
            if (helper) {
                helper.textContent = '';
                helper.classList.add('d-none');
            }

            const usuarioId = button ? button.getAttribute('data-usuario-id') || '' : '';
            if (!usuarioId) {
                return;
            }

            const selectUsuario = modalDepositoManual.querySelector('#depositoManualUsuario');
            if (!selectUsuario) {
                return;
            }

            let option = Array.from(selectUsuario.options).find(opt => opt.value === usuarioId);
            if (!option) {
                const textoOpcion = button ? button.getAttribute('data-usuario-nombre') || usuarioId : usuarioId;
                option = new Option(textoOpcion, usuarioId);
                option.dataset.generated = 'true';
                selectUsuario.appendChild(option);
            }
            selectUsuario.value = usuarioId;

            if (helper) {
                const nombre = button ? button.getAttribute('data-usuario-nombre') || '' : '';
                const email = button ? button.getAttribute('data-usuario-email') || '' : '';
                const detalles = [nombre, email].filter(Boolean).join(' · ');
                helper.textContent = `Usuario seleccionado automáticamente: ${detalles || usuarioId}`;
                helper.classList.remove('d-none');
            }
        });

        modalDepositoManual.addEventListener('hidden.bs.modal', () => {
            const form = modalDepositoManual.querySelector('form');
            if (form) {
                form.reset();
            }

            const selectUsuario = modalDepositoManual.querySelector('#depositoManualUsuario');
            if (selectUsuario) {
                Array.from(selectUsuario.options).forEach(opt => {
                    if (opt.dataset.generated === 'true') {
                        opt.remove();
                    }
                });
                selectUsuario.value = '';
            }

            const helper = modalDepositoManual.querySelector('[data-role="usuarioSeleccionado"]');
            if (helper) {
                helper.textContent = '';
                helper.classList.add('d-none');
            }
        });
    });
}
</script>
@endpush
