@extends('layouts.app')

@section('title', 'Expediente de usuario')
@section('page-title', 'Expediente del usuario')
@section('page-subtitle', 'Revisa documentos, finanzas y actividad en un solo lugar')

@php use Illuminate\Support\Str; @endphp

@section('page-actions')
<div class="d-flex flex-wrap gap-2">
    <a href="{{ route('admin.usuarios') }}" class="btn btn-sm btn-outline-secondary">
        <i class="fas fa-arrow-left me-1"></i> Volver al listado
    </a>
    <a href="{{ route('admin.transacciones') }}" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-coins me-1"></i> Transacciones
    </a>
</div>
@endsection
    <div class="modal fade" id="modalSolicitudAccion" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <form class="modal-content" method="POST">
                @csrf
                @method('PATCH')
                <input type="hidden" name="accion" value="">
                <div class="modal-header">
                    <h5 class="modal-title">Accion</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3" data-field-group="link_pago" hidden>
                        <label for="campoLinkPago" class="form-label">Link de pago</label>
                        <input type="url" class="form-control" id="campoLinkPago" name="link_pago" placeholder="https://">
                    </div>
                    <div class="mb-3" data-field-group="monto_pago" hidden>
                        <label for="campoMontoPago" class="form-label">Monto</label>
                        <input type="number" step="0.01" class="form-control" id="campoMontoPago" name="monto_pago">
                    </div>
                    <div class="mb-3" data-field-group="nota" hidden>
                        <label for="campoNota" class="form-label">Nota interna</label>
                        <textarea class="form-control" id="campoNota" name="nota" rows="3"></textarea>
                    </div>
                    <div class="mb-3" data-field-group="motivo" hidden>
                        <label for="campoMotivo" class="form-label">Motivo</label>
                        <textarea class="form-control" id="campoMotivo" name="motivo" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>


@section('content')
@php
    $estadoBadges = [
        'activo' => 'bg-success',
        'inactivo' => 'bg-secondary',
        'bloqueado' => 'bg-danger',
        'admin' => 'bg-primary',
        'master' => 'bg-dark'
    ];

    $metricasFinancieras = [
        ['label' => 'Saldo disponible', 'value' => $resumenFinanciero['saldo_disponible'] ?? '$0', 'icon' => 'fas fa-wallet', 'class' => 'text-success'],
        ['label' => 'Saldo pendiente', 'value' => $resumenFinanciero['saldo_pendiente'] ?? '$0', 'icon' => 'fas fa-hourglass-half', 'class' => 'text-warning'],
        ['label' => 'Saldo total', 'value' => $resumenFinanciero['saldo_total'] ?? '$0', 'icon' => 'fas fa-piggy-bank', 'class' => 'text-primary'],
        ['label' => 'Depositos aprobados', 'value' => $resumenFinanciero['depositos_aprobados'] ?? '$0', 'icon' => 'fas fa-arrow-down', 'class' => 'text-success'],
        ['label' => 'Depositos pendientes', 'value' => $resumenFinanciero['depositos_pendientes'] ?? '$0', 'icon' => 'fas fa-hourglass', 'class' => 'text-warning'],
        ['label' => 'Retiros completados', 'value' => $resumenFinanciero['retiros_completados'] ?? '$0', 'icon' => 'fas fa-arrow-up', 'class' => 'text-danger'],
        ['label' => 'Retiros pendientes', 'value' => $resumenFinanciero['retiros_pendientes'] ?? '$0', 'icon' => 'fas fa-clock', 'class' => 'text-secondary'],
        ['label' => 'Valor portafolio', 'value' => $resumenFinanciero['valor_portafolio'] ?? '$0', 'icon' => 'fas fa-solar-panel', 'class' => 'text-info'],
        ['label' => 'Valorizacion', 'value' => $resumenFinanciero['valorizacion'] ?? '$0', 'icon' => 'fas fa-chart-line', 'class' => 'text-success'],
    ];

    $timelineIcons = [
        'deposito' => ['icon' => 'fas fa-arrow-down', 'class' => 'text-success'],
        'retiro' => ['icon' => 'fas fa-arrow-up', 'class' => 'text-danger'],
        'solicitud' => ['icon' => 'fas fa-handshake', 'class' => 'text-primary'],
        'documento' => ['icon' => 'fas fa-file-alt', 'class' => 'text-secondary'],
    ];

    $scawattEstadosPermitidos = [
        'activo' => 'Activo',
        'marketplace' => 'Marketplace',
        'reservado' => 'Reservado',
        'vendido' => 'Vendido',
        'bloqueado' => 'Bloqueado',
    ];

    $accionesSolicitudConfig = [
        'datos_pendientes' => ['label' => 'Solicitar datos', 'fields' => ['nota?'], 'icon' => 'fas fa-clipboard-list'],
        'liberar_pago' => ['label' => 'Enviar link de pago', 'fields' => ['link_pago', 'monto_pago', 'nota?'], 'icon' => 'fas fa-credit-card'],
        'pago_revision' => ['label' => 'Pago en revision', 'fields' => ['nota?'], 'icon' => 'fas fa-hourglass-half'],
        'confirmar_pago' => ['label' => 'Confirmar pago', 'fields' => ['monto_pago?', 'nota?'], 'icon' => 'fas fa-check-circle'],
        'cancelar' => ['label' => 'Cancelar solicitud', 'fields' => ['motivo'], 'icon' => 'fas fa-times-circle'],
    ];

    $accionesPorEstado = [
        'pendiente' => ['datos_pendientes', 'liberar_pago', 'cancelar'],
        'datos_pendientes' => ['liberar_pago', 'cancelar'],
        'en_revision' => ['liberar_pago', 'cancelar'],
        'pago_pendiente' => ['pago_revision', 'confirmar_pago', 'cancelar'],
        'pago_en_revision' => ['confirmar_pago', 'cancelar'],
        'completado' => [],
        'cancelado' => [],
    ];
@endphp

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-3">
            <div>
                <h3 class="fw-semibold mb-1">{{ $usuario->nombre ?? 'Sin nombre' }}</h3>
                <div class="text-muted small mb-2">
                    <span>ID #{{ $usuario->id }}</span>
                    <span class="mx-1">•</span>
                    <span>{{ $usuario->email ?? 'Sin correo' }}</span>
                    @if($usuario->telefono)
                        <span class="mx-1">•</span>
                        <span>Tel: {{ $usuario->telefono }}</span>
                    @endif
                </div>
                <div class="d-flex flex-wrap gap-2">
                    <span class="badge {{ $estadoBadges[$usuario->estado] ?? 'bg-secondary' }}">{{ ucfirst($usuario->estado ?? 'N/D') }}</span>
                    <span class="badge {{ $usuario->cedula_verificada_at ? 'bg-success' : 'bg-warning text-dark' }}">Cedula {{ $usuario->cedula_verificada_at ? 'verificada' : 'pendiente' }}</span>
                    <span class="badge {{ $usuario->datos_bancarios_verificados_at ? 'bg-success' : 'bg-warning text-dark' }}">Bancarios {{ $usuario->datos_bancarios_verificados_at ? 'verificados' : 'pendientes' }}</span>
                    <span class="badge bg-info text-dark">ScaWatts: {{ number_format($scawatts->count()) }}</span>
                </div>
            </div>
            <div class="text-muted small text-lg-end">
                <div>Registrado: {{ $usuario->created_at?->format('d M Y H:i') ?? 'N/D' }}</div>
                <div>Actualizado: {{ $usuario->updated_at?->diffForHumans() ?? 'N/D' }}</div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    @foreach($metricasFinancieras as $metrica)
        <div class="col-xxl-3 col-xl-4 col-md-6">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted text-uppercase small mb-1">{{ $metrica['label'] }}</p>
                            <h5 class="fw-semibold mb-0">{{ $metrica['value'] }}</h5>
                        </div>
                        <span class="icon-circle bg-light {{ $metrica['class'] }}"><i class="{{ $metrica['icon'] }}"></i></span>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <ul class="nav nav-pills mb-3" id="tab-expediente" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="tab-resumen-tab" data-bs-toggle="pill" data-bs-target="#tab-resumen" type="button" role="tab">Resumen</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-documentos-tab" data-bs-toggle="pill" data-bs-target="#tab-documentos" type="button" role="tab">Documentos</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-finanzas-tab" data-bs-toggle="pill" data-bs-target="#tab-finanzas" type="button" role="tab">Finanzas</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-scawatts-tab" data-bs-toggle="pill" data-bs-target="#tab-scawatts" type="button" role="tab">ScaWatts</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-solicitudes-tab" data-bs-toggle="pill" data-bs-target="#tab-solicitudes" type="button" role="tab">Solicitudes</button>
            </li>
        </ul>

        <div class="tab-content" id="tab-expediente-content">
            <div class="tab-pane fade show active" id="tab-resumen" role="tabpanel">
                <div class="row g-3">
                    <div class="col-xl-7">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-white border-0">
                                <h6 class="mb-0">Actividad reciente</h6>
                                <small class="text-muted">Eventos ordenados por fecha</small>
                            </div>
                            <div class="card-body">
                                @if($timeline->isEmpty())
                                    <p class="text-muted mb-0">Sin eventos registrados.</p>
                                @else
                                    <div class="timeline">
                                        @foreach($timeline as $evento)
                                            @php
                                                $iconData = $timelineIcons[$evento['tipo']] ?? ['icon' => 'fas fa-circle', 'class' => 'text-muted'];
                                            @endphp
                                            <div class="d-flex gap-3 mb-4">
                                                <div class="flex-shrink-0">
                                                    <span class="icon-circle bg-light {{ $iconData['class'] }}"><i class="{{ $iconData['icon'] }}"></i></span>
                                                </div>
                                                <div>
                                                    <div class="fw-semibold">{{ $evento['titulo'] }}</div>
                                                    <div class="text-muted small mb-1">{{ $evento['descripcion'] }}</div>
                                                    <div class="text-muted small">{{ $evento['fecha']?->format('d M Y H:i') ?? 'Sin fecha' }} • {{ $evento['fecha']?->diffForHumans() ?? '---' }}</div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-5">
                        <div class="card border-0 shadow-sm mb-3">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Perfil</h6>
                                <span class="badge bg-light text-dark">ID {{ $usuario->id }}</span>
                            </div>
                            <div class="card-body">
                                <dl class="row mb-0">
                                    <dt class="col-sm-5">Nombre</dt>
                                    <dd class="col-sm-7">{{ $usuario->nombre ?? 'N/D' }}</dd>
                                    <dt class="col-sm-5">Correo</dt>
                                    <dd class="col-sm-7">{{ $usuario->email ?? 'N/D' }}</dd>
                                    <dt class="col-sm-5">Telefono</dt>
                                    <dd class="col-sm-7">{{ $usuario->telefono ?? 'N/D' }}</dd>
                                    <dt class="col-sm-5">Cedula</dt>
                                    <dd class="col-sm-7">{{ $usuario->cedula ?? 'N/D' }}</dd>
                                    <dt class="col-sm-5">Saldo disponible</dt>
                                    <dd class="col-sm-7">{{ $resumenFinanciero['saldo_disponible'] ?? '$0' }}</dd>
                                    <dt class="col-sm-5">Saldo pendiente</dt>
                                    <dd class="col-sm-7">{{ $resumenFinanciero['saldo_pendiente'] ?? '$0' }}</dd>
                                </dl>
                            </div>
                        </div>

                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Notificaciones recientes</h6>
                                <span class="badge bg-secondary-subtle text-secondary">{{ $notificaciones->count() }}</span>
                            </div>
                            <div class="card-body">
                                @if($notificaciones->isEmpty())
                                    <p class="text-muted mb-0">Sin notificaciones asociadas.</p>
                                @else
                                    <ul class="list-group list-group-flush">
                                        @foreach($notificaciones as $notificacion)
                                            <li class="list-group-item px-0">
                                                <div class="fw-semibold">{{ $notificacion->titulo ?? 'Sin titulo' }}</div>
                                                <div class="text-muted small">{{ Str::limit($notificacion->mensaje ?? '', 120) }}</div>
                                                <div class="text-muted small">{{ $notificacion->created_at?->diffForHumans() ?? 'N/D' }}</div>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="tab-documentos" role="tabpanel">
                <div class="row g-3">
                    <div class="col-xl-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Documento de identidad</h6>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="badge {{ $documentosIdentidad['verificada'] ? 'bg-success' : 'bg-warning text-dark' }}">{{ $documentosIdentidad['verificada'] ? 'Verificada' : 'Pendiente' }}</span>
                                    <form method="POST" action="{{ route('admin.usuarios.verificacion.cedula', $usuario) }}">
                                        @csrf
                                        @method('PATCH')
                                        <input type="hidden" name="accion" value="{{ $documentosIdentidad['verificada'] ? 'revertir' : 'verificar' }}">
                                        @if($documentosIdentidad['verificada'])
                                            <button type="submit" class="btn btn-sm btn-outline-warning text-dark">Marcar pendiente</button>
                                        @else
                                            <button type="submit" class="btn btn-sm btn-outline-success">Marcar verificada</button>
                                        @endif
                                    </form>
                                </div>
                            </div>
                            <div class="card-body">
                                @if(!$documentosIdentidad['frente_url'] && !$documentosIdentidad['atras_url'])
                                    <p class="text-muted mb-0">Sin imagenes de cedula registradas.</p>
                                @else
                                    <div class="row g-3">
                                        <div class="col-sm-6">
                                            <div class="border rounded position-relative overflow-hidden">
                                                @if($documentosIdentidad['frente_url'])
                                                    <img src="{{ $documentosIdentidad['frente_url'] }}" alt="Cedula frente" class="img-fluid">
                                                @else
                                                    <div class="p-4 text-center text-muted">Sin imagen frente</div>
                                                @endif
                                            </div>
                                            <small class="text-muted d-block mt-2">Frente</small>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="border rounded position-relative overflow-hidden">
                                                @if($documentosIdentidad['atras_url'])
                                                    <img src="{{ $documentosIdentidad['atras_url'] }}" alt="Cedula reverso" class="img-fluid">
                                                @else
                                                    <div class="p-4 text-center text-muted">Sin imagen reverso</div>
                                                @endif
                                            </div>
                                            <small class="text-muted d-block mt-2">Reverso</small>
                                        </div>
                                    </div>
                                @endif
                                <div class="text-muted small mt-3">Fecha verificacion: {{ $documentosIdentidad['fecha_verificacion']?->format('d M Y H:i') ?? 'Pendiente' }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Cuenta bancaria</h6>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="badge {{ $documentosBancarios['verificada'] ? 'bg-success' : 'bg-warning text-dark' }}">{{ $documentosBancarios['verificada'] ? 'Verificada' : 'Pendiente' }}</span>
                                    <form method="POST" action="{{ route('admin.usuarios.verificacion.bancaria', $usuario) }}">
                                        @csrf
                                        @method('PATCH')
                                        <input type="hidden" name="accion" value="{{ $documentosBancarios['verificada'] ? 'revertir' : 'verificar' }}">
                                        @if($documentosBancarios['verificada'])
                                            <button type="submit" class="btn btn-sm btn-outline-warning text-dark">Marcar pendiente</button>
                                        @else
                                            <button type="submit" class="btn btn-sm btn-outline-success">Marcar verificada</button>
                                        @endif
                                    </form>
                                </div>
                            </div>
                            <div class="card-body">
                                <dl class="row mb-0">
                                    <dt class="col-sm-5">Banco</dt>
                                    <dd class="col-sm-7">{{ $documentosBancarios['banco'] ?? 'N/D' }}</dd>
                                    <dt class="col-sm-5">Tipo de cuenta</dt>
                                    <dd class="col-sm-7">{{ $documentosBancarios['tipo_cuenta'] ?? 'N/D' }}</dd>
                                    <dt class="col-sm-5">Cuenta</dt>
                                    <dd class="col-sm-7">
                                        @if(!empty($documentosBancarios['numero_cuenta']))
                                            @php
                                                $identificadorCuenta = 'numero-cuenta-' . $usuario->id;
                                            @endphp
                                            <span
                                                id="{{ $identificadorCuenta }}"
                                                data-state="partial"
                                                data-partial="{{ $documentosBancarios['numero_cuenta_parcial'] }}"
                                                data-full="{{ $documentosBancarios['numero_cuenta'] }}"
                                            >{{ $documentosBancarios['numero_cuenta_parcial'] }}</span>
                                            <button
                                                type="button"
                                                class="btn btn-link btn-sm px-1 text-decoration-none toggle-numero-cuenta"
                                                data-target="#{{ $identificadorCuenta }}"
                                            >Mostrar completa</button>
                                        @else
                                            N/D
                                        @endif
                                    </dd>
                                </dl>
                                <div class="mt-3">
                                    @if($documentosBancarios['certificado_url'])
                                        <a href="{{ $documentosBancarios['certificado_url'] }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-file-download me-1"></i> Ver certificado
                                        </a>
                                    @else
                                        <span class="text-muted small">Sin certificado bancario registrado.</span>
                                    @endif
                                </div>
                                <div class="text-muted small mt-3">Fecha verificacion: {{ $documentosBancarios['fecha_verificacion']?->format('d M Y H:i') ?? 'Pendiente' }}</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mt-3">
                    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Documentos registrados</h6>
                        <span class="badge bg-secondary-subtle text-secondary">{{ $documentosAdicionales->count() }}</span>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Tipo</th>
                                        <th>Nombre</th>
                                        <th class="text-center">Registrado</th>
                                        <th class="text-end">Accion</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @forelse($documentosAdicionales as $doc)
                                    <tr>
                                        <td class="text-uppercase text-muted small">{{ $doc['tipo'] ?? 'N/D' }}</td>
                                        <td>{{ $doc['nombre'] ?? 'Sin nombre' }}</td>
                                        <td class="text-center">{{ $doc['fecha']?->format('d M Y H:i') ?? 'N/D' }}</td>
                                        <td class="text-end">
                                            <a href="{{ $doc['url'] }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center text-muted py-4">Sin documentos registrados.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="tab-finanzas" role="tabpanel">
                <div class="row g-3">
                    <div class="col-xl-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Depositos recientes</h6>
                                <span class="badge bg-secondary-subtle text-secondary">{{ $depositos->count() }}</span>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Fecha</th>
                                                <th>Monto</th>
                                                <th>Estado</th>
                                                <th>Referencia</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @forelse($depositos as $deposito)
                                            <tr>
                                                <td>{{ $deposito->created_at?->format('d M Y H:i') ?? 'N/D' }}</td>
                                                <td>${{ number_format((float) $deposito->monto, 0, ',', '.') }}</td>
                                                <td>
                                                    <span class="badge {{ $deposito->estado === 'aprobado' ? 'bg-success' : ($deposito->estado === 'rechazado' ? 'bg-danger' : 'bg-warning text-dark') }}">{{ ucfirst($deposito->estado ?? 'pendiente') }}</span>
                                                </td>
                                                <td>{{ $deposito->referencia ?? $deposito->referencia_pago ?? '—' }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="4" class="text-center text-muted py-4">Sin depositos asociados.</td>
                                            </tr>
                                        @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Retiros recientes</h6>
                                <span class="badge bg-secondary-subtle text-secondary">{{ $retiros->count() }}</span>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Fecha</th>
                                                <th>Monto</th>
                                                <th>Estado</th>
                                                <th>Referencia</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @forelse($retiros as $retiro)
                                            <tr>
                                                <td>{{ $retiro->created_at?->format('d M Y H:i') ?? 'N/D' }}</td>
                                                <td>${{ number_format((float) $retiro->monto, 0, ',', '.') }}</td>
                                                <td>
                                                    @php
                                                        $retiroBadge = match ($retiro->estado) {
                                                            'completado' => 'bg-success',
                                                            'rechazado' => 'bg-danger',
                                                            'proceso' => 'bg-info',
                                                            default => 'bg-warning text-dark',
                                                        };
                                                    @endphp
                                                    <span class="badge {{ $retiroBadge }}">{{ ucfirst($retiro->estado ?? 'pendiente') }}</span>
                                                </td>
                                                <td>{{ $retiro->referencia_transaccion ?? '—' }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="4" class="text-center text-muted py-4">Sin retiros asociados.</td>
                                            </tr>
                                        @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="tab-scawatts" role="tabpanel">
                <div class="card border-0 shadow-sm mb-3">
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-3">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Total scawatts</p>
                                    <h4 class="fw-semibold mb-0">{{ number_format($estadisticasScawatt['total']) }}</h4>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Activos</p>
                                    <h4 class="fw-semibold mb-0">{{ number_format($estadisticasScawatt['activos']) }}</h4>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Inactivos</p>
                                    <h4 class="fw-semibold mb-0">{{ number_format($estadisticasScawatt['inactivos']) }}</h4>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">kWh asignados</p>
                                    <h4 class="fw-semibold mb-0">{{ $estadisticasScawatt['kwh_total'] }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="row g-3 mt-0">
                            <div class="col-md-4">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Valor actual</p>
                                    <h4 class="fw-semibold mb-0">{{ $estadisticasScawatt['valor_actual_total'] }}</h4>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Valor inicial</p>
                                    <h4 class="fw-semibold mb-0">{{ $estadisticasScawatt['valor_inicial_total'] }}</h4>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Valorizacion</p>
                                    <h4 class="fw-semibold mb-0">{{ $estadisticasScawatt['valorizacion_total'] }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Detalle de ScaWatts</h6>
                        <span class="badge bg-secondary-subtle text-secondary">{{ $scawatts->count() }}</span>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Serial</th>
                                        <th>Estado</th>
                                        <th class="text-end">Gestion</th>
                                        <th class="text-center">kWh</th>
                                        <th class="text-end">Valor inicial</th>
                                        <th class="text-end">Valor actual</th>
                                        <th class="text-end">Valorizacion</th>
                                        <th>Granja</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @forelse($scawatts as $scawatt)
                                    <tr>
                                        <td>{{ $scawatt->scawatt_id ?? 'N/D' }}</td>
                                        <td><span class="badge {{ $scawatt->estado === 'activo' ? 'bg-success' : 'bg-secondary' }}">{{ ucfirst($scawatt->estado ?? 'N/D') }}</span></td>
                                        <td class="text-end">
                                            <form method="POST" action="{{ route('admin.usuarios.scawatts.estado', [$usuario, $scawatt]) }}" class="d-flex gap-2 justify-content-end">
                                                @csrf
                                                @method('PATCH')
                                                <select name="estado" class="form-select form-select-sm w-auto">
                                                    @foreach($scawattEstadosPermitidos as $estadoKey => $estadoLabel)
                                                        <option value="{{ $estadoKey }}" @selected($scawatt->estado === $estadoKey)>{{ $estadoLabel }}</option>
                                                    @endforeach
                                                </select>
                                                <button type="submit" class="btn btn-sm btn-outline-primary">Guardar</button>
                                            </form>
                                        </td>
                                        <td class="text-center">{{ number_format((float) ($scawatt->kwh_asignados ?? 0), 2, ',', '.') }}</td>
                                        <td class="text-end">${{ number_format((float) ($scawatt->valor_inicial ?? 0), 0, ',', '.') }}</td>
                                        <td class="text-end">${{ number_format((float) ($scawatt->valor_actual ?? 0), 0, ',', '.') }}</td>
                                        <td class="text-end">${{ number_format((float) (($scawatt->valor_actual ?? 0) - ($scawatt->valor_inicial ?? 0)), 0, ',', '.') }}</td>
                                        <td>{{ $scawatt->granja?->nombre ?? 'N/D' }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center text-muted py-4">Sin ScaWatts asignados.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="tab-solicitudes" role="tabpanel">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Solicitudes de contacto</h6>
                        <span class="badge bg-secondary-subtle text-secondary">{{ $solicitudes->count() }}</span>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Fecha</th>
                                        <th>Estado</th>
                                        <th class="text-center">ScaWatts</th>
                                        <th class="text-end">Presupuesto</th>
                                        <th>Notas</th>
                                        <th>Atendio</th>
                                        <th class="text-end">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @forelse($solicitudes as $solicitud)
                                    @php
                                        $estado = $solicitud->estado ?? 'pendiente';
                                        $badgeClass = match ($estado) {
                                            'contactado' => 'bg-info',
                                            'en_revision' => 'bg-info',
                                            'datos_pendientes' => 'bg-warning text-dark',
                                            'pago_pendiente' => 'bg-primary',
                                            'pago_en_revision' => 'bg-secondary',
                                            'completado' => 'bg-success',
                                            'cancelado' => 'bg-danger',
                                            default => 'bg-warning text-dark',
                                        };
                                        $accionesDisponibles = $accionesPorEstado[$estado] ?? [];
                                    @endphp
                                    <tr>
                                        <td>{{ $solicitud->created_at?->format('d M Y H:i') ?? 'N/D' }}</td>
                                        <td><span class="badge {{ $badgeClass }}">{{ Str::of($estado)->replace('_', ' ')->title() }}</span></td>
                                        <td class="text-center">{{ number_format((int) ($solicitud->cantidad_scawatts ?? 0)) }}</td>
                                        <td class="text-end">{{ $solicitud->presupuesto_aproximado ? '$' . number_format((float) $solicitud->presupuesto_aproximado, 0, ',', '.') : '—' }}</td>
                                        <td>
                                            <div>{{ Str::limit($solicitud->notas_admin ?? $solicitud->mensaje ?? 'Sin notas', 120) }}</div>
                                            @if($solicitud->link_pago)
                                                <div class="small"><a href="{{ $solicitud->link_pago }}" target="_blank">Link de pago</a></div>
                                            @endif
                                            @if($solicitud->monto_pago)
                                                <div class="small text-muted">Monto: ${{ number_format((float) $solicitud->monto_pago, 0, ',', '.') }}</div>
                                            @endif
                                            @if($solicitud->fecha_pago)
                                                <div class="small text-muted">Pago: {{ $solicitud->fecha_pago?->format('d M Y H:i') }}</div>
                                            @endif
                                        </td>
                                        <td>
                                            <div>{{ $solicitud->adminAtendio?->nombre ?? '—' }}</div>
                                            @if($solicitud->estadoActualizadoPor)
                                                <div class="small text-muted">Ultimo cambio: {{ $solicitud->estadoActualizadoPor?->nombre ?? '—' }}</div>
                                            @endif
                                        </td>
                                        <td class="text-end">
                                            @if(!empty($accionesDisponibles))
                                                <div class="dropdown">
                                                    <button class="btn btn-sm btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">Acciones</button>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        @foreach($accionesDisponibles as $accion)
                                                            @php
                                                                $config = $accionesSolicitudConfig[$accion] ?? null;
                                                            @endphp
                                                            @if($config)
                                                                <button
                                                                    type="button"
                                                                    class="dropdown-item solicitud-action"
                                                                    data-url="{{ route('admin.usuarios.solicitudes.actualizar', [$usuario, $solicitud]) }}"
                                                                    data-accion="{{ $accion }}"
                                                                    data-label="{{ $config['label'] }}"
                                                                    data-fields="{{ implode(',', $config['fields']) }}"
                                                                    data-default-link="{{ $solicitud->link_pago }}"
                                                                    data-default-monto="{{ $solicitud->monto_pago }}"
                                                                    data-default-nota="{{ $solicitud->notas_admin }}"
                                                                >
                                                                    <i class="{{ $config['icon'] ?? 'fas fa-chevron-right' }} me-2"></i>{{ $config['label'] }}
                                                                </button>
                                                            @endif
                                                        @endforeach
                                                    </div>
                                                </div>
                                            @else
                                                <span class="text-muted small">Sin acciones</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center text-muted py-4">Sin solicitudes registradas.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.toggle-numero-cuenta').forEach(function (boton) {
        boton.addEventListener('click', function () {
            var destino = document.querySelector(boton.dataset.target);
            if (!destino) {
                return;
            }

            var estadoActual = destino.dataset.state || 'partial';
            if (estadoActual === 'partial') {
                destino.textContent = destino.dataset.full || destino.dataset.partial || 'N/D';
                destino.dataset.state = 'full';
                boton.textContent = 'Ocultar';
            } else {
                destino.textContent = destino.dataset.partial || 'N/D';
                destino.dataset.state = 'partial';
                boton.textContent = 'Mostrar completa';
            }
        });
    });

    const modalEl = document.getElementById('modalSolicitudAccion');
    if (modalEl && window.bootstrap) {
        const modal = new bootstrap.Modal(modalEl);
        const form = modalEl.querySelector('form');
        const titulo = modalEl.querySelector('.modal-title');
        const accionInput = form.querySelector('input[name="accion"]');
        const fieldGroups = Array.from(modalEl.querySelectorAll('[data-field-group]'));

        const limpiarCampos = function () {
            fieldGroups.forEach(function (group) {
                const input = group.querySelector('input, textarea');
                if (input) {
                    input.value = '';
                    input.removeAttribute('required');
                }
                group.hidden = true;
            });
        };

        document.querySelectorAll('.solicitud-action').forEach(function (boton) {
            boton.addEventListener('click', function () {
                limpiarCampos();

                form.action = boton.dataset.url || '';
                accionInput.value = boton.dataset.accion || '';
                if (titulo && boton.dataset.label) {
                    titulo.textContent = boton.dataset.label;
                }

                const fieldsRaw = (boton.dataset.fields || '').split(',').map(function (item) {
                    return item.trim();
                }).filter(Boolean);

                fieldsRaw.forEach(function (field) {
                    const optional = field.endsWith('?');
                    const key = optional ? field.slice(0, -1) : field;
                    const group = fieldGroups.find(function (g) {
                        return g.dataset.fieldGroup === key;
                    });
                    if (!group) {
                        return;
                    }

                    group.hidden = false;
                    const input = group.querySelector('input, textarea');
                    if (input) {
                        if (!optional) {
                            input.setAttribute('required', 'required');
                        }

                        if (key === 'link_pago' && boton.dataset.defaultLink) {
                            input.value = boton.dataset.defaultLink;
                        }

                        if (key === 'monto_pago' && boton.dataset.defaultMonto) {
                            input.value = boton.dataset.defaultMonto;
                        }

                        if (key === 'nota' && boton.dataset.defaultNota) {
                            input.value = boton.dataset.defaultNota;
                        }

                        if (key === 'motivo' && boton.dataset.defaultMotivo) {
                            input.value = boton.dataset.defaultMotivo;
                        }
                    }
                });

                modal.show();
            });
        });
    }
});
</script>
@endpush
