<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Confirmación de compra ScaWatt - Admin</title>
    <style>
        body { margin: 0; padding: 0; background: #EEF3F6; font-family: 'Helvetica Neue', Arial, sans-serif; color: #0F1D2B; }
        .wrapper { width: 100%; padding: 32px 0; }
        .container { max-width: 600px; margin: 0 auto; background: #ffffff; border-radius: 20px; overflow: hidden; box-shadow: 0 18px 38px rgba(15, 29, 43, 0.12); }
        .header { background: linear-gradient(135deg, #8B0000, #DC143C); padding: 28px; text-align: center; }
        .header img { max-width: 200px; height: auto; }
        .admin-badge { display: inline-block; padding: 8px 16px; border-radius: 999px; background: rgba(220, 20, 60, 0.15); color: #DC143C; font-weight: 700; letter-spacing: 0.5px; margin-bottom: 12px; font-size: 11px; text-transform: uppercase; }
        .content { padding: 36px 40px; }
        .token { display: flex; align-items: center; gap: 16px; margin-bottom: 24px; }
        .token img { width: 56px; height: 56px; }
        .title { font-size: 24px; font-weight: 700; margin: 0 0 12px; color: #163A5F; }
        .lead { margin: 0 0 18px; line-height: 1.6; }
        .badge { display: inline-block; padding: 8px 16px; border-radius: 999px; background: rgba(28, 90, 140, 0.12); color: #1C5A8C; font-weight: 600; letter-spacing: 0.4px; margin-bottom: 24px; }
        .card { background: #F7FAFC; border-radius: 16px; padding: 24px; margin: 24px 0; border: 1px solid rgba(22, 58, 95, 0.08); }
        .card h3 { margin: 0 0 16px; font-size: 18px; color: #163A5F; }
        .grid { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; font-size: 14px; }
        .grid strong { display: block; font-size: 12px; text-transform: uppercase; letter-spacing: 0.5px; color: #5A768F; margin-bottom: 4px; }
        .highlight { background: rgba(220, 20, 60, 0.08); padding: 12px 16px; border-radius: 8px; border-left: 4px solid #DC143C; }
        .highlight strong { color: #DC143C; }
        .cta { display: inline-block; margin-top: 28px; padding: 14px 32px; border-radius: 999px; background: linear-gradient(135deg, #1C5A8C, #37B5FF); color: #ffffff; font-weight: 600; text-decoration: none; }
        .note { margin: 24px 0 0; font-size: 13px; line-height: 1.6; color: #35536D; }
        .footer { padding: 24px 40px 36px; background: #F2F6F9; font-size: 12px; color: #5A768F; line-height: 1.6; }
        @media (max-width: 620px) {
            .content { padding: 28px; }
            .grid { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <div class="container">
            <div class="header">
                <img src="{{ $logo_url }}" alt="Scalar" />
            </div>
            <div class="content">
                <span class="admin-badge">🔒 Vista Administrativa</span>
                <div class="token">
                    <img src="{{ $token_icon }}" alt="Token ScaWatt" />
                    <div>
                        <span class="badge">Compra completada</span>
                        <h1 class="title">Nueva venta en Marketplace</h1>
                    </div>
                </div>
                <p class="lead">Se ha registrado una nueva compra en el marketplace de ScaWatts.</p>

                <div class="card">
                    <h3>Resumen de la operación</h3>
                    <div class="grid">
                        <div>
                            <strong>Serial ScaWatt</strong>
                            <span>{{ $scawatt_serial }}</span>
                        </div>
                        <div>
                            <strong>ID marketplace</strong>
                            <span>#{{ $marketplace_id }}</span>
                        </div>
                        <div>
                            <strong>Monto pagado</strong>
                            <span>$ {{ $precio }}</span>
                        </div>
                        <div class="highlight">
                            <strong>Comisión plataforma</strong>
                            <span>$ {{ $comision }}</span>
                        </div>
                        <div>
                            <strong>Fecha de compra</strong>
                            <span>{{ $fecha_venta ?? '—' }}</span>
                        </div>
                        <div>
                            <strong>Comprador</strong>
                            <span>{{ $comprador }}</span>
                        </div>
                        <div>
                            <strong>Vendedor</strong>
                            <span>{{ $vendedor ?? 'Marketplace ScaWatts' }}</span>
                        </div>
                    </div>
                </div>

                <p class="note"><strong>Nota:</strong> Este correo contiene información administrativa. El comprador recibe una versión sin datos de comisión.</p>
            </div>
            <div class="footer">
                © {{ date('Y') }} Scalar. Todos los derechos reservados.<br>
                Este correo fue enviado automáticamente al equipo administrativo para seguimiento de transacciones.
            </div>
        </div>
    </div>
</body>
</html>
