<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Recupera tu contraseña</title>
    <style>
        body { margin: 0; padding: 0; background: #E8EDF1; font-family: 'Helvetica Neue', Arial, sans-serif; color: #142936; }
        .wrapper { width: 100%; padding: 32px 0; }
        .container { max-width: 520px; margin: 0 auto; background: #ffffff; border-radius: 12px; overflow: hidden; box-shadow: 0 12px 28px rgba(20, 41, 54, 0.12); }
        .header { background: linear-gradient(135deg, #3B686E, #142936); padding: 24px; text-align: center; }
        .header img { max-width: 180px; height: auto; }
        .content { padding: 32px; }
        .heading { font-size: 22px; margin: 0 0 16px; color: #3B686E; }
        .intro { margin: 0 0 16px; line-height: 1.6; }
        .code-box { background: #F7F9FB; border: 1px solid #C8E1E4; border-radius: 10px; padding: 24px; margin: 24px 0; text-align: center; }
        .code-text { font-size: 32px; font-weight: 700; letter-spacing: 8px; color: #142936; }
        .info { margin: 16px 0; line-height: 1.6; }
        .cta { display: inline-block; margin-top: 24px; padding: 14px 32px; border-radius: 999px; background: #E9D48C; color: #142936; font-weight: 600; text-decoration: none; }
        .footer { padding: 24px 32px 32px; background: #F7F9FB; font-size: 12px; color: #3B686E; line-height: 1.6; }
        @media (max-width: 600px) {
            .content { padding: 24px; }
            .code-text { font-size: 28px; letter-spacing: 6px; }
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <div class="container">
            <div class="header">
                <img src="https://escalar.app/brand/Logo%20Scalar%202025.png" alt="ScaWatts" />
            </div>
            <div class="content">
                <h1 class="heading">Recupera tu acceso</h1>
                <p class="intro">Hola {{ $nombre ?? 'usuario' }},</p>
                <p class="intro">Recibimos una solicitud para restablecer tu contraseña de ScaWatts. Usa este código único para continuar con el proceso:</p>
                <div class="code-box">
                    <div class="code-text">{{ $code }}</div>
                </div>
                <p class="info">El código expira en 15 minutos. Si no solicitaste un restablecimiento, puedes ignorar este mensaje y tu contraseña seguirá siendo la misma.</p>
                <a class="cta" href="{{ url('/recuperar-contrasena') }}" target="_blank">Ir a recuperar contraseña</a>
                <p class="info">¿Necesitas ayuda? Escríbenos a soporte@escalar.app y estaremos encantados de asistirte.</p>
            </div>
            <div class="footer">
                © {{ date('Y') }} ScaWatts. Todos los derechos reservados.<br>
                Este mensaje se envió automáticamente. No respondas a este correo.
            </div>
        </div>
    </div>
</body>
</html>
