<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="x-apple-disable-message-reformatting" content="true">
    <title>Código de autorización</title>
    <style>
        body { font-family: Arial, Helvetica, sans-serif; color: #1f2937; }
        .container { max-width: 520px; margin: 0 auto; padding: 24px; border: 1px solid #e5e7eb; border-radius: 12px; background: #ffffff; }
        .brand { text-align: center; margin-bottom: 18px; }
        .brand img { height: 48px; }
        .code-label { font-size: 15px; color: #4b5563; margin-bottom: 6px; text-transform: uppercase; letter-spacing: 1px; }
        .code { font-size: 32px; font-weight: bold; letter-spacing: 4px; display: inline-block; padding: 16px 20px; border-radius: 10px; background: #111827; color: #ffffff; }
        .meta { margin-top: 20px; font-size: 14px; color: #4b5563; }
        .section-title { font-weight: 600; margin-top: 24px; margin-bottom: 8px; color: #111827; }
        .section { padding: 12px 14px; background: #f3f4f6; border-radius: 10px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="brand">
            <img src="https://escalar.app/brand/Logo%20Scalar%202025.png" alt="Scalar Energía Renovable">
        </div>
        <p>Hola,</p>
        <p>Se solicitó acceso a los documentos del ScaWatt <strong>{{ $scawatt->scawatt_id }}</strong>. Para autorizar la visualización y descarga, comparte el siguiente código con la persona que lo requirió:</p>

        <div class="code-label">Código de verificación</div>
        <p class="code">{{ trim($codigo) }}</p>

        <p class="meta">Este código expira en 6 horas y solo otorga acceso a los documentos de este ScaWatt.</p>

        @if(!empty($solicitante))
            <div class="section">
                <div class="section-title">Datos de la solicitud</div>
                <ul style="margin: 0; padding-left: 18px;">
                    @if(!empty($solicitante['nombre']))
                        <li><strong>Nombre:</strong> {{ $solicitante['nombre'] }}</li>
                    @endif
                    @if(!empty($solicitante['email']))
                        <li><strong>Email:</strong> {{ $solicitante['email'] }}</li>
                    @endif
                    @if(!empty($solicitante['telefono']))
                        <li><strong>Teléfono:</strong> {{ $solicitante['telefono'] }}</li>
                    @endif
                    @if(!empty($solicitante['motivo']))
                        <li><strong>Motivo:</strong> {{ $solicitante['motivo'] }}</li>
                    @endif
                </ul>
            </div>
        @endif

        <p style="margin-top: 24px;">Si tú no solicitaste esta verificación, puedes ignorar este correo. Los documentos seguirán protegidos hasta que se ingrese el código correcto.</p>

        <p style="margin-top: 32px;">Equipo Scalar Energía Renovable</p>
    </div>
</body>
</html>
