<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Nueva solicitud ScaWatt</title>
</head>
<body style="font-family: Arial, sans-serif; color: #1f2937;">
    <h2 style="margin-bottom: 12px;">Nueva solicitud de ScaWatt</h2>
    <p style="margin: 0 0 16px 0;">Se registro una nueva solicitud desde la plataforma.</p>

    <table cellpadding="6" cellspacing="0" border="0" style="background: #f3f4f6; border-radius: 6px;">
        <tr>
            <td><strong>ID solicitud</strong></td>
            <td>{{ $solicitud->id }}</td>
        </tr>
        <tr>
            <td><strong>Usuario</strong></td>
            <td>{{ $solicitud->nombre_completo ?? 'Sin nombre' }}</td>
        </tr>
        <tr>
            <td><strong>Correo</strong></td>
            <td>{{ $solicitud->email ?? 'Sin correo' }}</td>
        </tr>
        <tr>
            <td><strong>Telefono</strong></td>
            <td>{{ $solicitud->telefono ?? 'Sin telefono' }}</td>
        </tr>
        <tr>
            <td><strong>Cantidad ScaWatts</strong></td>
            <td>{{ $solicitud->cantidad_scawatts ?? 'No definida' }}</td>
        </tr>
        <tr>
            <td><strong>Presupuesto</strong></td>
            <td>{{ $solicitud->presupuesto_aproximado ? '$' . number_format((float) $solicitud->presupuesto_aproximado, 0, ',', '.') : 'No definido' }}</td>
        </tr>
        <tr>
            <td><strong>Mensaje</strong></td>
            <td>{{ $solicitud->mensaje ?? 'Sin mensaje' }}</td>
        </tr>
        <tr>
            <td><strong>Fecha</strong></td>
            <td>{{ $solicitud->created_at?->format('d/m/Y H:i') ?? 'Sin registro' }}</td>
        </tr>
    </table>

    <p style="margin-top: 16px;">Puedes revisar el expediente ingresando al panel de administracion.</p>
</body>
</html>
