<?php $__env->startSection('title', 'Expediente de usuario'); ?>
<?php $__env->startSection('page-title', 'Expediente del usuario'); ?>
<?php $__env->startSection('page-subtitle', 'Revisa documentos, finanzas y actividad en un solo lugar'); ?>

<?php use Illuminate\Support\Str; ?>

<?php $__env->startSection('page-actions'); ?>
<div class="d-flex flex-wrap gap-2">
    <a href="<?php echo e(route('admin.usuarios')); ?>" class="btn btn-sm btn-outline-secondary">
        <i class="fas fa-arrow-left me-1"></i> Volver al listado
    </a>
    <a href="<?php echo e(route('admin.transacciones')); ?>" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-coins me-1"></i> Transacciones
    </a>
</div>
<?php $__env->stopSection(); ?>
    <div class="modal fade" id="modalSolicitudAccion" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <form class="modal-content" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <input type="hidden" name="accion" value="">
                <div class="modal-header">
                    <h5 class="modal-title">Accion</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3" data-field-group="link_pago" hidden>
                        <label for="campoLinkPago" class="form-label">Link de pago</label>
                        <input type="url" class="form-control" id="campoLinkPago" name="link_pago" placeholder="https://">
                    </div>
                    <div class="mb-3" data-field-group="monto_pago" hidden>
                        <label for="campoMontoPago" class="form-label">Monto</label>
                        <input type="number" step="0.01" class="form-control" id="campoMontoPago" name="monto_pago">
                    </div>
                    <div class="mb-3" data-field-group="nota" hidden>
                        <label for="campoNota" class="form-label">Nota interna</label>
                        <textarea class="form-control" id="campoNota" name="nota" rows="3"></textarea>
                    </div>
                    <div class="mb-3" data-field-group="motivo" hidden>
                        <label for="campoMotivo" class="form-label">Motivo</label>
                        <textarea class="form-control" id="campoMotivo" name="motivo" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>


<?php $__env->startSection('content'); ?>
<?php
    $estadoBadges = [
        'activo' => 'bg-success',
        'inactivo' => 'bg-secondary',
        'bloqueado' => 'bg-danger',
        'admin' => 'bg-primary',
        'master' => 'bg-dark'
    ];

    $metricasFinancieras = [
        ['label' => 'Saldo disponible', 'value' => $resumenFinanciero['saldo_disponible'] ?? '$0', 'icon' => 'fas fa-wallet', 'class' => 'text-success'],
        ['label' => 'Saldo pendiente', 'value' => $resumenFinanciero['saldo_pendiente'] ?? '$0', 'icon' => 'fas fa-hourglass-half', 'class' => 'text-warning'],
        ['label' => 'Saldo total', 'value' => $resumenFinanciero['saldo_total'] ?? '$0', 'icon' => 'fas fa-piggy-bank', 'class' => 'text-primary'],
        ['label' => 'Depositos aprobados', 'value' => $resumenFinanciero['depositos_aprobados'] ?? '$0', 'icon' => 'fas fa-arrow-down', 'class' => 'text-success'],
        ['label' => 'Depositos pendientes', 'value' => $resumenFinanciero['depositos_pendientes'] ?? '$0', 'icon' => 'fas fa-hourglass', 'class' => 'text-warning'],
        ['label' => 'Retiros completados', 'value' => $resumenFinanciero['retiros_completados'] ?? '$0', 'icon' => 'fas fa-arrow-up', 'class' => 'text-danger'],
        ['label' => 'Retiros pendientes', 'value' => $resumenFinanciero['retiros_pendientes'] ?? '$0', 'icon' => 'fas fa-clock', 'class' => 'text-secondary'],
        ['label' => 'Valor portafolio', 'value' => $resumenFinanciero['valor_portafolio'] ?? '$0', 'icon' => 'fas fa-solar-panel', 'class' => 'text-info'],
        ['label' => 'Valorizacion', 'value' => $resumenFinanciero['valorizacion'] ?? '$0', 'icon' => 'fas fa-chart-line', 'class' => 'text-success'],
    ];

    $timelineIcons = [
        'deposito' => ['icon' => 'fas fa-arrow-down', 'class' => 'text-success'],
        'retiro' => ['icon' => 'fas fa-arrow-up', 'class' => 'text-danger'],
        'solicitud' => ['icon' => 'fas fa-handshake', 'class' => 'text-primary'],
        'documento' => ['icon' => 'fas fa-file-alt', 'class' => 'text-secondary'],
    ];

    $scawattEstadosPermitidos = [
        'activo' => 'Activo',
        'marketplace' => 'Marketplace',
        'reservado' => 'Reservado',
        'vendido' => 'Vendido',
        'bloqueado' => 'Bloqueado',
    ];

    $accionesSolicitudConfig = [
        'datos_pendientes' => ['label' => 'Solicitar datos', 'fields' => ['nota?'], 'icon' => 'fas fa-clipboard-list'],
        'liberar_pago' => ['label' => 'Enviar link de pago', 'fields' => ['link_pago', 'monto_pago', 'nota?'], 'icon' => 'fas fa-credit-card'],
        'pago_revision' => ['label' => 'Pago en revision', 'fields' => ['nota?'], 'icon' => 'fas fa-hourglass-half'],
        'confirmar_pago' => ['label' => 'Confirmar pago', 'fields' => ['monto_pago?', 'nota?'], 'icon' => 'fas fa-check-circle'],
        'cancelar' => ['label' => 'Cancelar solicitud', 'fields' => ['motivo'], 'icon' => 'fas fa-times-circle'],
    ];

    $accionesPorEstado = [
        'pendiente' => ['datos_pendientes', 'liberar_pago', 'cancelar'],
        'datos_pendientes' => ['liberar_pago', 'cancelar'],
        'en_revision' => ['liberar_pago', 'cancelar'],
        'pago_pendiente' => ['pago_revision', 'confirmar_pago', 'cancelar'],
        'pago_en_revision' => ['confirmar_pago', 'cancelar'],
        'completado' => [],
        'cancelado' => [],
    ];
?>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-3">
            <div>
                <h3 class="fw-semibold mb-1"><?php echo e($usuario->nombre ?? 'Sin nombre'); ?></h3>
                <div class="text-muted small mb-2">
                    <span>ID #<?php echo e($usuario->id); ?></span>
                    <span class="mx-1">•</span>
                    <span><?php echo e($usuario->email ?? 'Sin correo'); ?></span>
                    <?php if($usuario->telefono): ?>
                        <span class="mx-1">•</span>
                        <span>Tel: <?php echo e($usuario->telefono); ?></span>
                    <?php endif; ?>
                </div>
                <div class="d-flex flex-wrap gap-2">
                    <span class="badge <?php echo e($estadoBadges[$usuario->estado] ?? 'bg-secondary'); ?>"><?php echo e(ucfirst($usuario->estado ?? 'N/D')); ?></span>
                    <span class="badge <?php echo e($usuario->cedula_verificada_at ? 'bg-success' : 'bg-warning text-dark'); ?>">Cedula <?php echo e($usuario->cedula_verificada_at ? 'verificada' : 'pendiente'); ?></span>
                    <span class="badge <?php echo e($usuario->datos_bancarios_verificados_at ? 'bg-success' : 'bg-warning text-dark'); ?>">Bancarios <?php echo e($usuario->datos_bancarios_verificados_at ? 'verificados' : 'pendientes'); ?></span>
                    <span class="badge bg-info text-dark">ScaWatts: <?php echo e(number_format($scawatts->count())); ?></span>
                </div>
            </div>
            <div class="text-muted small text-lg-end">
                <div>Registrado: <?php echo e($usuario->created_at?->format('d M Y H:i') ?? 'N/D'); ?></div>
                <div>Actualizado: <?php echo e($usuario->updated_at?->diffForHumans() ?? 'N/D'); ?></div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <?php $__currentLoopData = $metricasFinancieras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $metrica): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-xxl-3 col-xl-4 col-md-6">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted text-uppercase small mb-1"><?php echo e($metrica['label']); ?></p>
                            <h5 class="fw-semibold mb-0"><?php echo e($metrica['value']); ?></h5>
                        </div>
                        <span class="icon-circle bg-light <?php echo e($metrica['class']); ?>"><i class="<?php echo e($metrica['icon']); ?>"></i></span>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <ul class="nav nav-pills mb-3" id="tab-expediente" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="tab-resumen-tab" data-bs-toggle="pill" data-bs-target="#tab-resumen" type="button" role="tab">Resumen</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-documentos-tab" data-bs-toggle="pill" data-bs-target="#tab-documentos" type="button" role="tab">Documentos</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-finanzas-tab" data-bs-toggle="pill" data-bs-target="#tab-finanzas" type="button" role="tab">Finanzas</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-scawatts-tab" data-bs-toggle="pill" data-bs-target="#tab-scawatts" type="button" role="tab">ScaWatts</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-solicitudes-tab" data-bs-toggle="pill" data-bs-target="#tab-solicitudes" type="button" role="tab">Solicitudes</button>
            </li>
        </ul>

        <div class="tab-content" id="tab-expediente-content">
            <div class="tab-pane fade show active" id="tab-resumen" role="tabpanel">
                <div class="row g-3">
                    <div class="col-xl-7">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-white border-0">
                                <h6 class="mb-0">Actividad reciente</h6>
                                <small class="text-muted">Eventos ordenados por fecha</small>
                            </div>
                            <div class="card-body">
                                <?php if($timeline->isEmpty()): ?>
                                    <p class="text-muted mb-0">Sin eventos registrados.</p>
                                <?php else: ?>
                                    <div class="timeline">
                                        <?php $__currentLoopData = $timeline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $iconData = $timelineIcons[$evento['tipo']] ?? ['icon' => 'fas fa-circle', 'class' => 'text-muted'];
                                            ?>
                                            <div class="d-flex gap-3 mb-4">
                                                <div class="flex-shrink-0">
                                                    <span class="icon-circle bg-light <?php echo e($iconData['class']); ?>"><i class="<?php echo e($iconData['icon']); ?>"></i></span>
                                                </div>
                                                <div>
                                                    <div class="fw-semibold"><?php echo e($evento['titulo']); ?></div>
                                                    <div class="text-muted small mb-1"><?php echo e($evento['descripcion']); ?></div>
                                                    <div class="text-muted small"><?php echo e($evento['fecha']?->format('d M Y H:i') ?? 'Sin fecha'); ?> • <?php echo e($evento['fecha']?->diffForHumans() ?? '---'); ?></div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-5">
                        <div class="card border-0 shadow-sm mb-3">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Perfil</h6>
                                <span class="badge bg-light text-dark">ID <?php echo e($usuario->id); ?></span>
                            </div>
                            <div class="card-body">
                                <dl class="row mb-0">
                                    <dt class="col-sm-5">Nombre</dt>
                                    <dd class="col-sm-7"><?php echo e($usuario->nombre ?? 'N/D'); ?></dd>
                                    <dt class="col-sm-5">Correo</dt>
                                    <dd class="col-sm-7"><?php echo e($usuario->email ?? 'N/D'); ?></dd>
                                    <dt class="col-sm-5">Telefono</dt>
                                    <dd class="col-sm-7"><?php echo e($usuario->telefono ?? 'N/D'); ?></dd>
                                    <dt class="col-sm-5">Cedula</dt>
                                    <dd class="col-sm-7"><?php echo e($usuario->cedula ?? 'N/D'); ?></dd>
                                    <dt class="col-sm-5">Saldo disponible</dt>
                                    <dd class="col-sm-7"><?php echo e($resumenFinanciero['saldo_disponible'] ?? '$0'); ?></dd>
                                    <dt class="col-sm-5">Saldo pendiente</dt>
                                    <dd class="col-sm-7"><?php echo e($resumenFinanciero['saldo_pendiente'] ?? '$0'); ?></dd>
                                </dl>
                            </div>
                        </div>

                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Notificaciones recientes</h6>
                                <span class="badge bg-secondary-subtle text-secondary"><?php echo e($notificaciones->count()); ?></span>
                            </div>
                            <div class="card-body">
                                <?php if($notificaciones->isEmpty()): ?>
                                    <p class="text-muted mb-0">Sin notificaciones asociadas.</p>
                                <?php else: ?>
                                    <ul class="list-group list-group-flush">
                                        <?php $__currentLoopData = $notificaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notificacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="list-group-item px-0">
                                                <div class="fw-semibold"><?php echo e($notificacion->titulo ?? 'Sin titulo'); ?></div>
                                                <div class="text-muted small"><?php echo e(Str::limit($notificacion->mensaje ?? '', 120)); ?></div>
                                                <div class="text-muted small"><?php echo e($notificacion->created_at?->diffForHumans() ?? 'N/D'); ?></div>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="tab-documentos" role="tabpanel">
                <div class="row g-3">
                    <div class="col-xl-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Documento de identidad</h6>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="badge <?php echo e($documentosIdentidad['verificada'] ? 'bg-success' : 'bg-warning text-dark'); ?>"><?php echo e($documentosIdentidad['verificada'] ? 'Verificada' : 'Pendiente'); ?></span>
                                    <form method="POST" action="<?php echo e(route('admin.usuarios.verificacion.cedula', $usuario)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <input type="hidden" name="accion" value="<?php echo e($documentosIdentidad['verificada'] ? 'revertir' : 'verificar'); ?>">
                                        <?php if($documentosIdentidad['verificada']): ?>
                                            <button type="submit" class="btn btn-sm btn-outline-warning text-dark">Marcar pendiente</button>
                                        <?php else: ?>
                                            <button type="submit" class="btn btn-sm btn-outline-success">Marcar verificada</button>
                                        <?php endif; ?>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body">
                                <?php if(!$documentosIdentidad['frente_url'] && !$documentosIdentidad['atras_url']): ?>
                                    <p class="text-muted mb-0">Sin imagenes de cedula registradas.</p>
                                <?php else: ?>
                                    <div class="row g-3">
                                        <div class="col-sm-6">
                                            <div class="border rounded position-relative overflow-hidden">
                                                <?php if($documentosIdentidad['frente_url']): ?>
                                                    <img src="<?php echo e($documentosIdentidad['frente_url']); ?>" alt="Cedula frente" class="img-fluid">
                                                <?php else: ?>
                                                    <div class="p-4 text-center text-muted">Sin imagen frente</div>
                                                <?php endif; ?>
                                            </div>
                                            <small class="text-muted d-block mt-2">Frente</small>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="border rounded position-relative overflow-hidden">
                                                <?php if($documentosIdentidad['atras_url']): ?>
                                                    <img src="<?php echo e($documentosIdentidad['atras_url']); ?>" alt="Cedula reverso" class="img-fluid">
                                                <?php else: ?>
                                                    <div class="p-4 text-center text-muted">Sin imagen reverso</div>
                                                <?php endif; ?>
                                            </div>
                                            <small class="text-muted d-block mt-2">Reverso</small>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="text-muted small mt-3">Fecha verificacion: <?php echo e($documentosIdentidad['fecha_verificacion']?->format('d M Y H:i') ?? 'Pendiente'); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Cuenta bancaria</h6>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="badge <?php echo e($documentosBancarios['verificada'] ? 'bg-success' : 'bg-warning text-dark'); ?>"><?php echo e($documentosBancarios['verificada'] ? 'Verificada' : 'Pendiente'); ?></span>
                                    <form method="POST" action="<?php echo e(route('admin.usuarios.verificacion.bancaria', $usuario)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <input type="hidden" name="accion" value="<?php echo e($documentosBancarios['verificada'] ? 'revertir' : 'verificar'); ?>">
                                        <?php if($documentosBancarios['verificada']): ?>
                                            <button type="submit" class="btn btn-sm btn-outline-warning text-dark">Marcar pendiente</button>
                                        <?php else: ?>
                                            <button type="submit" class="btn btn-sm btn-outline-success">Marcar verificada</button>
                                        <?php endif; ?>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body">
                                <dl class="row mb-0">
                                    <dt class="col-sm-5">Banco</dt>
                                    <dd class="col-sm-7"><?php echo e($documentosBancarios['banco'] ?? 'N/D'); ?></dd>
                                    <dt class="col-sm-5">Tipo de cuenta</dt>
                                    <dd class="col-sm-7"><?php echo e($documentosBancarios['tipo_cuenta'] ?? 'N/D'); ?></dd>
                                    <dt class="col-sm-5">Cuenta</dt>
                                    <dd class="col-sm-7">
                                        <?php if(!empty($documentosBancarios['numero_cuenta'])): ?>
                                            <?php
                                                $identificadorCuenta = 'numero-cuenta-' . $usuario->id;
                                            ?>
                                            <span
                                                id="<?php echo e($identificadorCuenta); ?>"
                                                data-state="partial"
                                                data-partial="<?php echo e($documentosBancarios['numero_cuenta_parcial']); ?>"
                                                data-full="<?php echo e($documentosBancarios['numero_cuenta']); ?>"
                                            ><?php echo e($documentosBancarios['numero_cuenta_parcial']); ?></span>
                                            <button
                                                type="button"
                                                class="btn btn-link btn-sm px-1 text-decoration-none toggle-numero-cuenta"
                                                data-target="#<?php echo e($identificadorCuenta); ?>"
                                            >Mostrar completa</button>
                                        <?php else: ?>
                                            N/D
                                        <?php endif; ?>
                                    </dd>
                                </dl>
                                <div class="mt-3">
                                    <?php if($documentosBancarios['certificado_url']): ?>
                                        <a href="<?php echo e($documentosBancarios['certificado_url']); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-file-download me-1"></i> Ver certificado
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted small">Sin certificado bancario registrado.</span>
                                    <?php endif; ?>
                                </div>
                                <div class="text-muted small mt-3">Fecha verificacion: <?php echo e($documentosBancarios['fecha_verificacion']?->format('d M Y H:i') ?? 'Pendiente'); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mt-3">
                    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Documentos registrados</h6>
                        <span class="badge bg-secondary-subtle text-secondary"><?php echo e($documentosAdicionales->count()); ?></span>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Tipo</th>
                                        <th>Nombre</th>
                                        <th class="text-center">Registrado</th>
                                        <th class="text-end">Accion</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $documentosAdicionales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="text-uppercase text-muted small"><?php echo e($doc['tipo'] ?? 'N/D'); ?></td>
                                        <td><?php echo e($doc['nombre'] ?? 'Sin nombre'); ?></td>
                                        <td class="text-center"><?php echo e($doc['fecha']?->format('d M Y H:i') ?? 'N/D'); ?></td>
                                        <td class="text-end">
                                            <a href="<?php echo e($doc['url']); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="text-center text-muted py-4">Sin documentos registrados.</td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="tab-finanzas" role="tabpanel">
                <div class="row g-3">
                    <div class="col-xl-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Depositos recientes</h6>
                                <span class="badge bg-secondary-subtle text-secondary"><?php echo e($depositos->count()); ?></span>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Fecha</th>
                                                <th>Monto</th>
                                                <th>Estado</th>
                                                <th>Referencia</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $depositos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposito): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e($deposito->created_at?->format('d M Y H:i') ?? 'N/D'); ?></td>
                                                <td>$<?php echo e(number_format((float) $deposito->monto, 0, ',', '.')); ?></td>
                                                <td>
                                                    <span class="badge <?php echo e($deposito->estado === 'aprobado' ? 'bg-success' : ($deposito->estado === 'rechazado' ? 'bg-danger' : 'bg-warning text-dark')); ?>"><?php echo e(ucfirst($deposito->estado ?? 'pendiente')); ?></span>
                                                </td>
                                                <td><?php echo e($deposito->referencia ?? $deposito->referencia_pago ?? '—'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="4" class="text-center text-muted py-4">Sin depositos asociados.</td>
                                            </tr>
                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="card border-0 shadow-sm h-100">
                            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                                <h6 class="mb-0">Retiros recientes</h6>
                                <span class="badge bg-secondary-subtle text-secondary"><?php echo e($retiros->count()); ?></span>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Fecha</th>
                                                <th>Monto</th>
                                                <th>Estado</th>
                                                <th>Referencia</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $retiros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $retiro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e($retiro->created_at?->format('d M Y H:i') ?? 'N/D'); ?></td>
                                                <td>$<?php echo e(number_format((float) $retiro->monto, 0, ',', '.')); ?></td>
                                                <td>
                                                    <?php
                                                        $retiroBadge = match ($retiro->estado) {
                                                            'completado' => 'bg-success',
                                                            'rechazado' => 'bg-danger',
                                                            'proceso' => 'bg-info',
                                                            default => 'bg-warning text-dark',
                                                        };
                                                    ?>
                                                    <span class="badge <?php echo e($retiroBadge); ?>"><?php echo e(ucfirst($retiro->estado ?? 'pendiente')); ?></span>
                                                </td>
                                                <td><?php echo e($retiro->referencia_transaccion ?? '—'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="4" class="text-center text-muted py-4">Sin retiros asociados.</td>
                                            </tr>
                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="tab-scawatts" role="tabpanel">
                <div class="card border-0 shadow-sm mb-3">
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-3">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Total scawatts</p>
                                    <h4 class="fw-semibold mb-0"><?php echo e(number_format($estadisticasScawatt['total'])); ?></h4>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Activos</p>
                                    <h4 class="fw-semibold mb-0"><?php echo e(number_format($estadisticasScawatt['activos'])); ?></h4>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Inactivos</p>
                                    <h4 class="fw-semibold mb-0"><?php echo e(number_format($estadisticasScawatt['inactivos'])); ?></h4>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">kWh asignados</p>
                                    <h4 class="fw-semibold mb-0"><?php echo e($estadisticasScawatt['kwh_total']); ?></h4>
                                </div>
                            </div>
                        </div>
                        <div class="row g-3 mt-0">
                            <div class="col-md-4">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Valor actual</p>
                                    <h4 class="fw-semibold mb-0"><?php echo e($estadisticasScawatt['valor_actual_total']); ?></h4>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Valor inicial</p>
                                    <h4 class="fw-semibold mb-0"><?php echo e($estadisticasScawatt['valor_inicial_total']); ?></h4>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="p-3 border rounded bg-light">
                                    <p class="text-muted text-uppercase small mb-1">Valorizacion</p>
                                    <h4 class="fw-semibold mb-0"><?php echo e($estadisticasScawatt['valorizacion_total']); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Detalle de ScaWatts</h6>
                        <span class="badge bg-secondary-subtle text-secondary"><?php echo e($scawatts->count()); ?></span>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Serial</th>
                                        <th>Estado</th>
                                        <th class="text-end">Gestion</th>
                                        <th class="text-center">kWh</th>
                                        <th class="text-end">Valor inicial</th>
                                        <th class="text-end">Valor actual</th>
                                        <th class="text-end">Valorizacion</th>
                                        <th>Granja</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $scawatts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scawatt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($scawatt->scawatt_id ?? 'N/D'); ?></td>
                                        <td><span class="badge <?php echo e($scawatt->estado === 'activo' ? 'bg-success' : 'bg-secondary'); ?>"><?php echo e(ucfirst($scawatt->estado ?? 'N/D')); ?></span></td>
                                        <td class="text-end">
                                            <form method="POST" action="<?php echo e(route('admin.usuarios.scawatts.estado', [$usuario, $scawatt])); ?>" class="d-flex gap-2 justify-content-end">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <select name="estado" class="form-select form-select-sm w-auto">
                                                    <?php $__currentLoopData = $scawattEstadosPermitidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estadoKey => $estadoLabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($estadoKey); ?>" <?php if($scawatt->estado === $estadoKey): echo 'selected'; endif; ?>><?php echo e($estadoLabel); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <button type="submit" class="btn btn-sm btn-outline-primary">Guardar</button>
                                            </form>
                                        </td>
                                        <td class="text-center"><?php echo e(number_format((float) ($scawatt->kwh_asignados ?? 0), 2, ',', '.')); ?></td>
                                        <td class="text-end">$<?php echo e(number_format((float) ($scawatt->valor_inicial ?? 0), 0, ',', '.')); ?></td>
                                        <td class="text-end">$<?php echo e(number_format((float) ($scawatt->valor_actual ?? 0), 0, ',', '.')); ?></td>
                                        <td class="text-end">$<?php echo e(number_format((float) (($scawatt->valor_actual ?? 0) - ($scawatt->valor_inicial ?? 0)), 0, ',', '.')); ?></td>
                                        <td><?php echo e($scawatt->granja?->nombre ?? 'N/D'); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="8" class="text-center text-muted py-4">Sin ScaWatts asignados.</td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="tab-solicitudes" role="tabpanel">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Solicitudes de contacto</h6>
                        <span class="badge bg-secondary-subtle text-secondary"><?php echo e($solicitudes->count()); ?></span>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Fecha</th>
                                        <th>Estado</th>
                                        <th class="text-center">ScaWatts</th>
                                        <th class="text-end">Presupuesto</th>
                                        <th>Notas</th>
                                        <th>Atendio</th>
                                        <th class="text-end">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $solicitudes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $solicitud): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $estado = $solicitud->estado ?? 'pendiente';
                                        $badgeClass = match ($estado) {
                                            'contactado' => 'bg-info',
                                            'en_revision' => 'bg-info',
                                            'datos_pendientes' => 'bg-warning text-dark',
                                            'pago_pendiente' => 'bg-primary',
                                            'pago_en_revision' => 'bg-secondary',
                                            'completado' => 'bg-success',
                                            'cancelado' => 'bg-danger',
                                            default => 'bg-warning text-dark',
                                        };
                                        $accionesDisponibles = $accionesPorEstado[$estado] ?? [];
                                    ?>
                                    <tr>
                                        <td><?php echo e($solicitud->created_at?->format('d M Y H:i') ?? 'N/D'); ?></td>
                                        <td><span class="badge <?php echo e($badgeClass); ?>"><?php echo e(Str::of($estado)->replace('_', ' ')->title()); ?></span></td>
                                        <td class="text-center"><?php echo e(number_format((int) ($solicitud->cantidad_scawatts ?? 0))); ?></td>
                                        <td class="text-end"><?php echo e($solicitud->presupuesto_aproximado ? '$' . number_format((float) $solicitud->presupuesto_aproximado, 0, ',', '.') : '—'); ?></td>
                                        <td>
                                            <div><?php echo e(Str::limit($solicitud->notas_admin ?? $solicitud->mensaje ?? 'Sin notas', 120)); ?></div>
                                            <?php if($solicitud->link_pago): ?>
                                                <div class="small"><a href="<?php echo e($solicitud->link_pago); ?>" target="_blank">Link de pago</a></div>
                                            <?php endif; ?>
                                            <?php if($solicitud->monto_pago): ?>
                                                <div class="small text-muted">Monto: $<?php echo e(number_format((float) $solicitud->monto_pago, 0, ',', '.')); ?></div>
                                            <?php endif; ?>
                                            <?php if($solicitud->fecha_pago): ?>
                                                <div class="small text-muted">Pago: <?php echo e($solicitud->fecha_pago?->format('d M Y H:i')); ?></div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div><?php echo e($solicitud->adminAtendio?->nombre ?? '—'); ?></div>
                                            <?php if($solicitud->estadoActualizadoPor): ?>
                                                <div class="small text-muted">Ultimo cambio: <?php echo e($solicitud->estadoActualizadoPor?->nombre ?? '—'); ?></div>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-end">
                                            <?php if(!empty($accionesDisponibles)): ?>
                                                <div class="dropdown">
                                                    <button class="btn btn-sm btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">Acciones</button>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        <?php $__currentLoopData = $accionesDisponibles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php
                                                                $config = $accionesSolicitudConfig[$accion] ?? null;
                                                            ?>
                                                            <?php if($config): ?>
                                                                <button
                                                                    type="button"
                                                                    class="dropdown-item solicitud-action"
                                                                    data-url="<?php echo e(route('admin.usuarios.solicitudes.actualizar', [$usuario, $solicitud])); ?>"
                                                                    data-accion="<?php echo e($accion); ?>"
                                                                    data-label="<?php echo e($config['label']); ?>"
                                                                    data-fields="<?php echo e(implode(',', $config['fields'])); ?>"
                                                                    data-default-link="<?php echo e($solicitud->link_pago); ?>"
                                                                    data-default-monto="<?php echo e($solicitud->monto_pago); ?>"
                                                                    data-default-nota="<?php echo e($solicitud->notas_admin); ?>"
                                                                >
                                                                    <i class="<?php echo e($config['icon'] ?? 'fas fa-chevron-right'); ?> me-2"></i><?php echo e($config['label']); ?>

                                                                </button>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <span class="text-muted small">Sin acciones</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center text-muted py-4">Sin solicitudes registradas.</td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.toggle-numero-cuenta').forEach(function (boton) {
        boton.addEventListener('click', function () {
            var destino = document.querySelector(boton.dataset.target);
            if (!destino) {
                return;
            }

            var estadoActual = destino.dataset.state || 'partial';
            if (estadoActual === 'partial') {
                destino.textContent = destino.dataset.full || destino.dataset.partial || 'N/D';
                destino.dataset.state = 'full';
                boton.textContent = 'Ocultar';
            } else {
                destino.textContent = destino.dataset.partial || 'N/D';
                destino.dataset.state = 'partial';
                boton.textContent = 'Mostrar completa';
            }
        });
    });

    const modalEl = document.getElementById('modalSolicitudAccion');
    if (modalEl && window.bootstrap) {
        const modal = new bootstrap.Modal(modalEl);
        const form = modalEl.querySelector('form');
        const titulo = modalEl.querySelector('.modal-title');
        const accionInput = form.querySelector('input[name="accion"]');
        const fieldGroups = Array.from(modalEl.querySelectorAll('[data-field-group]'));

        const limpiarCampos = function () {
            fieldGroups.forEach(function (group) {
                const input = group.querySelector('input, textarea');
                if (input) {
                    input.value = '';
                    input.removeAttribute('required');
                }
                group.hidden = true;
            });
        };

        document.querySelectorAll('.solicitud-action').forEach(function (boton) {
            boton.addEventListener('click', function () {
                limpiarCampos();

                form.action = boton.dataset.url || '';
                accionInput.value = boton.dataset.accion || '';
                if (titulo && boton.dataset.label) {
                    titulo.textContent = boton.dataset.label;
                }

                const fieldsRaw = (boton.dataset.fields || '').split(',').map(function (item) {
                    return item.trim();
                }).filter(Boolean);

                fieldsRaw.forEach(function (field) {
                    const optional = field.endsWith('?');
                    const key = optional ? field.slice(0, -1) : field;
                    const group = fieldGroups.find(function (g) {
                        return g.dataset.fieldGroup === key;
                    });
                    if (!group) {
                        return;
                    }

                    group.hidden = false;
                    const input = group.querySelector('input, textarea');
                    if (input) {
                        if (!optional) {
                            input.setAttribute('required', 'required');
                        }

                        if (key === 'link_pago' && boton.dataset.defaultLink) {
                            input.value = boton.dataset.defaultLink;
                        }

                        if (key === 'monto_pago' && boton.dataset.defaultMonto) {
                            input.value = boton.dataset.defaultMonto;
                        }

                        if (key === 'nota' && boton.dataset.defaultNota) {
                            input.value = boton.dataset.defaultNota;
                        }

                        if (key === 'motivo' && boton.dataset.defaultMotivo) {
                            input.value = boton.dataset.defaultMotivo;
                        }
                    }
                });

                modal.show();
            });
        });
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/admin/usuarios/show.blade.php ENDPATH**/ ?>