<?php $__env->startSection('title', 'Gestión de usuarios'); ?>
<?php $__env->startSection('page-title', 'Usuarios'); ?>
<?php $__env->startSection('page-subtitle', 'Monitorea saldos, verificaciones y actividad de toda la base de clientes'); ?>

<?php $__env->startSection('page-actions'); ?>
<div class="d-flex gap-2">
    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#modalCrearUsuario">
        <i class="fas fa-user-plus me-1"></i> Nuevo usuario
    </button>
    <a href="<?php echo e(route('admin.transacciones')); ?>" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-coins me-1"></i> Transacciones
    </a>
    <a href="<?php echo e(route('admin.monitor')); ?>" class="btn btn-sm btn-secondary">
        <i class="fas fa-wave-square me-1"></i> Monitor
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php
    $estadoModalOptions = [
        'activo' => 'Activo',
        'inactivo' => 'Inactivo',
        'bloqueado' => 'Bloqueado',
        'admin' => 'Administrador',
    ];
?>

<div class="modal fade" id="modalCrearUsuario" tabindex="-1" aria-labelledby="modalCrearUsuarioLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <form method="post" action="<?php echo e(route('admin.usuarios.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="modalCrearUsuarioLabel">
                        <i class="fas fa-user-plus me-2"></i>Registrar nuevo usuario
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="nuevo-nombre" class="form-label">Nombre completo</label>
                            <input type="text" id="nuevo-nombre" name="nombre" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="nuevo-email" class="form-label">Correo electrónico</label>
                            <input type="email" id="nuevo-email" name="email" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="nuevo-telefono" class="form-label">Teléfono</label>
                            <input type="text" id="nuevo-telefono" name="telefono" class="form-control" placeholder="Opcional">
                        </div>
                        <div class="col-md-3">
                            <label for="nuevo-estado" class="form-label">Estado inicial</label>
                            <select id="nuevo-estado" name="estado" class="form-select" required>
                                <?php $__currentLoopData = $estadoModalOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value); ?>" <?php if($value === 'activo'): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="nuevo-password" class="form-label">Contraseña</label>
                            <input type="text" id="nuevo-password" name="password" class="form-control" placeholder="Generar automática">
                            <div class="form-text">Déjalo vacío para generar una clave temporal.</div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar usuario</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditarUsuario" tabindex="-1" aria-labelledby="modalEditarUsuarioLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <form method="post" action="#" id="formEditarUsuario">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditarUsuarioLabel">
                        <i class="fas fa-user-gear me-2"></i>Editar usuario <span class="text-primary" id="editarUsuarioNombre"></span>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="editar-nombre" class="form-label">Nombre completo</label>
                            <input type="text" id="editar-nombre" name="nombre" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="editar-email" class="form-label">Correo electrónico</label>
                            <input type="email" id="editar-email" name="email" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="editar-telefono" class="form-label">Teléfono</label>
                            <input type="text" id="editar-telefono" name="telefono" class="form-control" placeholder="Opcional">
                        </div>
                        <div class="col-md-3">
                            <label for="editar-estado" class="form-label">Estado</label>
                            <select id="editar-estado" name="estado" class="form-select" required>
                                <?php $__currentLoopData = $estadoModalOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value); ?>"><?php echo e($label); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="editar-password" class="form-label">Nueva contraseña</label>
                            <input type="text" id="editar-password" name="password" class="form-control" placeholder="No cambiar">
                            <div class="form-text">Déjalo vacío para mantener la actual.</div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary">Actualizar usuario</button>
                </div>
            </form>
        </div>
    </div>
</div>

        <?php echo $__env->make('admin.transacciones.partials.modal-deposito-manual', ['usuariosDisponibles' => $usuariosDisponibles ?? collect()], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.estado-trigger').forEach(item => {
        item.addEventListener('click', event => {
            event.preventDefault();
            const userId = item.dataset.userId;
            const estado = item.dataset.estadoTarget;
            const form = document.getElementById(`estado-form-${userId}`);

            if (!form) {
                return;
            }

            const input = form.querySelector('input[name="estado"]');
            input.value = estado;
            form.submit();
        });
    });

    const editarModal = document.getElementById('modalEditarUsuario');
    if (editarModal) {
        editarModal.addEventListener('show.bs.modal', event => {
            const button = event.relatedTarget;
            if (!button) {
                return;
            }

            const form = editarModal.querySelector('form');
            form.action = button.getAttribute('data-action');

            editarModal.querySelector('#editar-nombre').value = button.getAttribute('data-nombre') || '';
            editarModal.querySelector('#editar-email').value = button.getAttribute('data-email') || '';
            editarModal.querySelector('#editar-telefono').value = button.getAttribute('data-telefono') || '';
            editarModal.querySelector('#editar-estado').value = button.getAttribute('data-estado') || 'activo';
            editarModal.querySelector('#editar-password').value = '';
            editarModal.querySelector('#editarUsuarioNombre').textContent = button.getAttribute('data-nombre') || '';
        });

        editarModal.addEventListener('hidden.bs.modal', () => {
            const form = editarModal.querySelector('form');
            form.action = '#';
            editarModal.querySelector('#editar-nombre').value = '';
            editarModal.querySelector('#editar-email').value = '';
            editarModal.querySelector('#editar-telefono').value = '';
            editarModal.querySelector('#editar-estado').value = 'activo';
            editarModal.querySelector('#editar-password').value = '';
            editarModal.querySelector('#editarUsuarioNombre').textContent = '';
        });
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php
    $estadoOptions = [
        'todos' => 'Todos los estados',
        'activo' => 'Activos',
        'inactivo' => 'Inactivos',
        'bloqueado' => 'Bloqueados',
        'admin' => 'Administradores',
    ];

    $verificacionOptions = [
        'todos' => 'Todas las verificaciones',
        'completos' => 'Verificación completa',
        'cedula' => 'Solo cédula aprobada',
        'bancarios' => 'Solo datos bancarios',
        'pendientes' => 'Con verificaciones pendientes',
    ];

    $ordenOptions = [
        'recientes' => 'Más recientes',
        'actividad' => 'Última actividad',
        'nombre' => 'Orden alfabético',
        'saldo_desc' => 'Saldo mayor a menor',
        'saldo_asc' => 'Saldo menor a mayor',
    ];

    $estadoLabels = [
        'activo' => ['label' => 'Activar', 'class' => 'text-success'],
        'inactivo' => ['label' => 'Marcar inactivo', 'class' => 'text-muted'],
        'bloqueado' => ['label' => 'Bloquear acceso', 'class' => 'text-danger'],
        'admin' => ['label' => 'Asignar admin', 'class' => 'text-primary'],
    ];

    $estadoModalOptions = collect($estadoOptions)->except('todos')->toArray();
?>

<div class="row g-3 mb-1">
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Total usuarios</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['total'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-primary-subtle text-primary"><i class="fas fa-users"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Activos</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['activos'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-success-subtle text-success"><i class="fas fa-user-check"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Nuevos 30 días</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['nuevos_mes'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-info-subtle text-info"><i class="fas fa-user-plus"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Verificados</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['verificados'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-warning-subtle text-warning"><i class="fas fa-id-card"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Saldo total</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['saldo_total']); ?></h4>
                    </div>
                    <span class="icon-circle bg-secondary-subtle text-secondary"><i class="fas fa-wallet"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Saldo pendiente</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['saldo_pendiente']); ?></h4>
                    </div>
                    <span class="icon-circle bg-danger-subtle text-danger"><i class="fas fa-clock"></i></span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="get" class="row g-3 align-items-end">
            <div class="col-xl-3 col-md-4">
                <label for="estado" class="form-label small text-uppercase text-muted mb-1">Estado</label>
                <select id="estado" name="estado" class="form-select form-select-sm">
                    <?php $__currentLoopData = $estadoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['estado'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-3 col-md-4">
                <label for="verificacion" class="form-label small text-uppercase text-muted mb-1">Verificación</label>
                <select id="verificacion" name="verificacion" class="form-select form-select-sm">
                    <?php $__currentLoopData = $verificacionOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['verificacion'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="orden" class="form-label small text-uppercase text-muted mb-1">Orden</label>
                <select id="orden" name="orden" class="form-select form-select-sm">
                    <?php $__currentLoopData = $ordenOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['orden'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="por_pagina" class="form-label small text-uppercase text-muted mb-1">Por página</label>
                <input type="number" min="5" max="100" id="por_pagina" name="por_pagina" value="<?php echo e($filtros['por_pagina']); ?>" class="form-control form-control-sm">
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="q" class="form-label small text-uppercase text-muted mb-1">Buscar</label>
                <input type="search" id="q" name="q" value="<?php echo e($filtros['q']); ?>" class="form-control form-control-sm" placeholder="Nombre, correo, cédula...">
            </div>
            <div class="col-12 col-xl-2 col-md-4 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary flex-fill">
                    <i class="fas fa-filter me-1"></i> Aplicar
                </button>
                <a href="<?php echo e(route('admin.usuarios')); ?>" class="btn btn-sm btn-outline-secondary" title="Limpiar filtros">
                    <i class="fas fa-rotate-right"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<div class="row g-3">
    <div class="col-xxl-9">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="mb-0">Listado de usuarios</h6>
                    <small class="text-muted">Mostrando <?php echo e($usuarios->firstItem() ?? 0); ?>-<?php echo e($usuarios->lastItem() ?? 0); ?> de <?php echo e($usuarios->total()); ?> registros</small>
                </div>
                <span class="badge bg-primary-subtle text-primary"><?php echo e(strtoupper($filtros['estado'])); ?></span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Usuario</th>
                                <th>Identificación</th>
                                <th>Saldos</th>
                                <th>ScaWatts</th>
                                <th>Verificación</th>
                                <th class="text-center">Estado</th>
                                <th>Registro</th>
                                <th class="text-end">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(route('admin.usuarios.show', $usuario)); ?>" class="text-decoration-none">
                                        <div class="fw-semibold text-primary"><?php echo e($usuario->nombre ?? 'Sin nombre'); ?></div>
                                        <small class="text-muted"><?php echo e($usuario->email ?? 'Sin correo'); ?></small>
                                    </a>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($usuario->cedula ?? 'N/D'); ?></div>
                                    <small class="text-muted">Tel: <?php echo e($usuario->telefono ?? 'N/D'); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold">Disp: $<?php echo e(number_format((float) ($usuario->saldo_disponible ?? 0), 0, ',', '.')); ?></div>
                                    <small class="text-muted">Pend: $<?php echo e(number_format((float) ($usuario->saldo_pendiente ?? 0), 0, ',', '.')); ?> · Total: $<?php echo e(number_format((float) ($usuario->saldo_total ?? 0), 0, ',', '.')); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e(number_format($usuario->scawatts_count)); ?> unidades</div>
                                    <small class="text-muted">Valor portafolio: $<?php echo e(number_format((float) ($usuario->valor_portafolio ?? 0), 0, ',', '.')); ?></small>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($usuario->cedula_verificada_at ? 'success' : 'warning'); ?> text-<?php echo e($usuario->cedula_verificada_at ? 'white' : 'dark'); ?>">Cédula</span>
                                    <span class="badge bg-<?php echo e($usuario->datos_bancarios_verificados_at ? 'success' : 'warning'); ?> text-<?php echo e($usuario->datos_bancarios_verificados_at ? 'white' : 'dark'); ?> ms-1">Bancarios</span>
                                    <div class="text-muted small mt-1">Dep: $<?php echo e(number_format((float) ($usuario->total_depositos ?? 0), 0, ',', '.')); ?> · Ret: $<?php echo e(number_format((float) ($usuario->total_retiros ?? 0), 0, ',', '.')); ?></div>
                                </td>
                                <td class="text-center">
                                    <span class="badge <?php echo e($usuario->estado === 'activo' ? 'bg-success' : ($usuario->estado === 'bloqueado' ? 'bg-danger' : 'bg-secondary')); ?>">
                                        <?php echo e(ucfirst($usuario->estado ?? 'N/D')); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($usuario->created_at?->format('d M Y') ?? 'N/D'); ?></div>
                                    <small class="text-muted">Último movimiento: <?php echo e($usuario->updated_at?->diffForHumans() ?? 'N/D'); ?></small>
                                </td>
                                <td class="text-end">
                                    <div class="btn-group">
                                        <button type="button"
                                            class="btn btn-sm btn-outline-secondary dropdown-toggle"
                                            data-bs-toggle="dropdown" aria-expanded="false"
                                            data-user-id="<?php echo e($usuario->id); ?>"
                                            data-nombre="<?php echo e($usuario->nombre); ?>"
                                            data-email="<?php echo e($usuario->email); ?>"
                                            data-telefono="<?php echo e($usuario->telefono); ?>"
                                            data-estado="<?php echo e($usuario->estado); ?>">
                                            <i class="fas fa-ellipsis-h"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li>
                                                <button type="button" class="dropdown-item"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#modalEditarUsuario"
                                                    data-action="<?php echo e(route('admin.usuarios.update', $usuario)); ?>"
                                                    data-nombre="<?php echo e($usuario->nombre); ?>"
                                                    data-email="<?php echo e($usuario->email); ?>"
                                                    data-telefono="<?php echo e($usuario->telefono); ?>"
                                                    data-estado="<?php echo e($usuario->estado); ?>">
                                                    <i class="fas fa-pen me-2"></i>Editar perfil
                                                </button>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e(url('/api/admin/usuarios/' . $usuario->id . '/detalle')); ?>" target="_blank" rel="noopener">
                                                    <i class="fas fa-up-right-from-square me-2"></i>Ver detalle API
                                                </a>
                                            </li>
                                            <li>
                                                <button type="button" class="dropdown-item accion-deposito-manual"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#modalDepositoManual"
                                                    data-usuario-id="<?php echo e($usuario->id); ?>"
                                                    data-usuario-nombre="<?php echo e($usuario->nombre ?? 'Usuario N/D'); ?>"
                                                    data-usuario-email="<?php echo e($usuario->email ?? ''); ?>">
                                                    <i class="fas fa-circle-plus text-success me-2"></i>Registrar depósito manual
                                                </button>
                                            </li>
                                            <li><hr class="dropdown-divider"></li>
                                            <?php $__currentLoopData = $estadoLabels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estadoKey => $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($estadoKey === ($usuario->estado ?? '')) continue; ?>
                                                <li>
                                                    <a href="#" class="dropdown-item estado-trigger <?php echo e($config['class']); ?>"
                                                        data-user-id="<?php echo e($usuario->id); ?>"
                                                        data-estado-target="<?php echo e($estadoKey); ?>">
                                                        <i class="fas fa-user-gear me-2"></i><?php echo e($config['label']); ?>

                                                    </a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <li><hr class="dropdown-divider"></li>
                                            <li>
                                                <a class="dropdown-item text-danger" href="mailto:<?php echo e($usuario->email); ?>">
                                                    <i class="fas fa-envelope me-2"></i>Enviar correo directo
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <form id="estado-form-<?php echo e($usuario->id); ?>" action="<?php echo e(route('admin.usuarios.estado', $usuario)); ?>" method="post" class="d-none">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <input type="hidden" name="estado" value="">
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted py-5">No se encontraron usuarios con los filtros aplicados.</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white border-0">
                <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-2">
                    <small class="text-muted">Verificaciones pendientes: <?php echo e(number_format($verificaciones['pendientes'])); ?></small>
                    <?php echo e($usuarios->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-3">
        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Segmentación por estado</h6>
                <span class="badge bg-dark-subtle text-dark"><?php echo e(number_format($stats['total'])); ?></span>
            </div>
            <div class="card-body">
                <?php $__empty_1 = true; $__currentLoopData = $segmentacionEstados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segmento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <span class="fw-semibold"><?php echo e(ucfirst(str_replace('_', ' ', $segmento['estado']))); ?></span>
                        <span class="badge bg-light text-dark"><?php echo e(number_format($segmento['total'])); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-muted mb-0">Sin datos disponibles.</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Top saldos disponibles</h6>
                <span class="badge bg-info-subtle text-info"><?php echo e($topClientes->count()); ?></span>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $topClientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-group-item d-flex justify-content-between align-items-start">
                            <div>
                                <div class="fw-semibold"><?php echo e($cliente->nombre ?? 'Usuario'); ?></div>
                                <small class="text-muted"><?php echo e($cliente->email ?? 'Sin correo'); ?></small>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-primary">$<?php echo e(number_format((float) ($cliente->saldo_disponible ?? 0), 0, ',', '.')); ?></span>
                                <div><small class="text-muted">Total: $<?php echo e(number_format((float) ($cliente->saldo_total ?? 0), 0, ',', '.')); ?></small></div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="list-group-item text-center text-muted py-4">Sin información disponible</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/admin/usuarios/index.blade.php ENDPATH**/ ?>