<?php $__env->startSection('title', 'Notificaciones'); ?>
<?php $__env->startSection('page-title', 'Notificaciones y avisos'); ?>

<?php $__env->startSection('page-actions'); ?>
<div class="d-flex gap-2">
    <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-sm btn-outline-secondary">
        <i class="fas fa-arrow-left me-1"></i> Dashboard
    </a>
    <a href="<?php echo e(route('admin.usuarios')); ?>" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-users me-1"></i> Usuarios
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php use Illuminate\Support\Str; ?>
<?php
    $estadoOptions = [
        'todas' => 'Todas',
        'sin_leer' => 'Sin leer',
        'leidas' => 'Leídas',
    ];

    $prioridadOptions = [
        'todas' => 'Todas',
        'alta' => 'Alta',
        'media' => 'Media',
        'baja' => 'Baja',
    ];

    $tipoOptions = collect($resumenTipos)
        ->pluck('tipo')
        ->filter()
        ->unique()
        ->mapWithKeys(fn($tipo) => [$tipo => ucfirst($tipo)])
        ->prepend('Todos', 'todos')
        ->toArray();

    if (!isset($tipoOptions['todos'])) {
        $tipoOptions = ['todos' => 'Todos'] + $tipoOptions;
    }

    $ordenOptions = [
        'recientes' => 'Más recientes',
        'prioridad' => 'Prioridad',
        'tipo' => 'Tipo',
    ];

    $iconoPrioridad = [
        'alta' => 'fa-circle-exclamation text-danger',
        'media' => 'fa-circle text-warning',
        'baja' => 'fa-circle text-muted',
    ];
?>

<div class="row g-3 mb-1">
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Total notificaciones</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['total'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-primary-subtle text-primary"><i class="fas fa-bell"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Sin leer</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['sin_leer'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-warning-subtle text-warning"><i class="fas fa-envelope-open-text"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Leídas</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['leidas'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-success-subtle text-success"><i class="fas fa-check"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Últimas 24 horas</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['ultimas_24h'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-info-subtle text-info"><i class="fas fa-bolt"></i></span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="get" class="row g-3 align-items-end">
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="estado" class="form-label small text-uppercase text-muted mb-1">Estado</label>
                <select id="estado" name="estado" class="form-select form-select-sm">
                    <?php $__currentLoopData = $estadoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['estado'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="prioridad" class="form-label small text-uppercase text-muted mb-1">Prioridad</label>
                <select id="prioridad" name="prioridad" class="form-select form-select-sm">
                    <?php $__currentLoopData = $prioridadOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['prioridad'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="tipo" class="form-label small text-uppercase text-muted mb-1">Tipo</label>
                <select id="tipo" name="tipo" class="form-select form-select-sm">
                    <?php $__currentLoopData = $tipoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['tipo'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="orden" class="form-label small text-uppercase text-muted mb-1">Orden</label>
                <select id="orden" name="orden" class="form-select form-select-sm">
                    <?php $__currentLoopData = $ordenOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['orden'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xxl-2 col-lg-3 col-md-4">
                <label for="q" class="form-label small text-uppercase text-muted mb-1">Buscar</label>
                <input type="search" id="q" name="q" value="<?php echo e($filtros['q']); ?>" class="form-control form-control-sm" placeholder="Título, mensaje, usuario">
            </div>
            <div class="col-xxl-1 col-md-2">
                <label for="por_pagina" class="form-label small text-uppercase text-muted mb-1">Por página</label>
                <input type="number" min="5" max="100" id="por_pagina" name="por_pagina" value="<?php echo e($filtros['por_pagina']); ?>" class="form-control form-control-sm">
            </div>
            <div class="col-xxl-1 col-md-2 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary flex-fill">
                    <i class="fas fa-filter me-1"></i> Aplicar
                </button>
                <a href="<?php echo e(route('admin.notificaciones')); ?>" class="btn btn-sm btn-outline-secondary" title="Limpiar filtros">
                    <i class="fas fa-rotate-right"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<div class="row g-3">
    <div class="col-xxl-9">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="mb-0">Historial de notificaciones</h6>
                    <small class="text-muted">Mostrando <?php echo e($notificaciones->firstItem() ?? 0); ?>-<?php echo e($notificaciones->lastItem() ?? 0); ?> de <?php echo e($notificaciones->total()); ?> registros</small>
                </div>
                <span class="badge bg-primary-subtle text-primary"><?php echo e(strtoupper($filtros['estado'])); ?></span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Detalle</th>
                                <th>Usuario</th>
                                <th class="text-center">Prioridad</th>
                                <th class="text-center">Estado</th>
                                <th class="text-end">Creada</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $notificaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notificacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $prioridad = $notificacion->prioridad ?? 'media';
                                $iconClass = $iconoPrioridad[$prioridad] ?? 'fa-circle text-muted';
                            ?>
                            <tr>
                                <td>
                                    <div class="fw-semibold"><?php echo e($notificacion->titulo); ?></div>
                                    <small class="text-muted"><?php echo e(Str::limit($notificacion->mensaje, 120)); ?></small>
                                    <?php if($notificacion->url_accion): ?>
                                        <div class="mt-1 small"><a href="<?php echo e($notificacion->url_accion); ?>" target="_blank">Ver acción</a></div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($notificacion->usuario->nombre ?? 'Sistema'); ?></div>
                                    <small class="text-muted"><?php echo e($notificacion->usuario->email ?? '—'); ?></small>
                                </td>
                                <td class="text-center">
                                    <span class="badge text-uppercase <?php echo e($prioridad === 'alta' ? 'bg-danger' : ($prioridad === 'media' ? 'bg-warning text-dark' : 'bg-secondary')); ?>">
                                        <i class="fas <?php echo e($iconClass); ?> me-1"></i><?php echo e(ucfirst($prioridad)); ?>

                                    </span>
                                </td>
                                <td class="text-center">
                                    <?php if($notificacion->leido): ?>
                                        <span class="badge bg-success">Leída</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">Sin leer</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end">
                                    <div class="fw-semibold"><?php echo e($notificacion->created_at?->format('d M Y H:i') ?? 'N/D'); ?></div>
                                    <small class="text-muted">
                                        <?php if($notificacion->leido && $notificacion->fecha_leido): ?>
                                            Leído <?php echo e($notificacion->fecha_leido->diffForHumans()); ?>

                                        <?php else: ?>
                                            <?php echo e($notificacion->created_at?->diffForHumans() ?? '—'); ?>

                                        <?php endif; ?>
                                    </small>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-5">
                                    No encontramos registros con los filtros aplicados.
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white border-0">
                <?php echo e($notificaciones->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>
    <div class="col-xxl-3">
        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Sin leer recientes</h6>
                <span class="badge bg-info-subtle text-info"><?php echo e($recientesSinLeer->count()); ?></span>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $recientesSinLeer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-group-item">
                            <div class="fw-semibold"><?php echo e($notif->titulo); ?></div>
                            <small class="text-muted d-block"><?php echo e($notif->created_at?->diffForHumans() ?? '—'); ?></small>
                            <small class="text-muted"><?php echo e($notif->usuario->nombre ?? 'Sistema'); ?></small>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="list-group-item text-center text-muted py-4">Sin pendientes recientes</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>

        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Resumen por tipo</h6>
                <span class="badge bg-dark-subtle text-dark"><?php echo e($resumenTipos->sum('total')); ?></span>
            </div>
            <div class="card-body">
                <?php $__empty_1 = true; $__currentLoopData = $resumenTipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resumen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <div>
                            <div class="fw-semibold"><?php echo e(ucfirst($resumen->tipo ?? 'sin tipo')); ?></div>
                        </div>
                        <span class="badge bg-light text-dark"><?php echo e($resumen->total); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-muted mb-0">Sin registros.</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Resumen por prioridad</h6>
                <span class="badge bg-dark-subtle text-dark"><?php echo e($resumenPrioridades->sum('total')); ?></span>
            </div>
            <div class="card-body">
                <?php $__empty_1 = true; $__currentLoopData = $resumenPrioridades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resumen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <div class="fw-semibold"><?php echo e(ucfirst($resumen->prioridad ?? 'sin datos')); ?></div>
                        <span class="badge bg-light text-dark"><?php echo e($resumen->total); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-muted mb-0">Sin registros.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/admin/notificaciones/index.blade.php ENDPATH**/ ?>