<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Confirmación de compra ScaWatt</title>
    <style>
        body { margin: 0; padding: 0; background: #EEF3F6; font-family: 'Helvetica Neue', Arial, sans-serif; color: #0F1D2B; }
        .wrapper { width: 100%; padding: 32px 0; }
        .container { max-width: 600px; margin: 0 auto; background: #ffffff; border-radius: 20px; overflow: hidden; box-shadow: 0 18px 38px rgba(15, 29, 43, 0.12); }
        .header { background: linear-gradient(135deg, #0F1B40, #1C5A8C); padding: 28px; text-align: center; }
        .header img { max-width: 200px; height: auto; }
        .content { padding: 36px 40px; }
        .token { display: flex; align-items: center; gap: 16px; margin-bottom: 24px; }
        .token img { width: 56px; height: 56px; }
        .title { font-size: 24px; font-weight: 700; margin: 0 0 12px; color: #163A5F; }
        .lead { margin: 0 0 18px; line-height: 1.6; }
        .badge { display: inline-block; padding: 8px 16px; border-radius: 999px; background: rgba(28, 90, 140, 0.12); color: #1C5A8C; font-weight: 600; letter-spacing: 0.4px; margin-bottom: 24px; }
        .card { background: #F7FAFC; border-radius: 16px; padding: 24px; margin: 24px 0; border: 1px solid rgba(22, 58, 95, 0.08); }
        .card h3 { margin: 0 0 16px; font-size: 18px; color: #163A5F; }
        .grid { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; font-size: 14px; }
        .grid strong { display: block; font-size: 12px; text-transform: uppercase; letter-spacing: 0.5px; color: #5A768F; margin-bottom: 4px; }
        .cta { display: inline-block; margin-top: 28px; padding: 14px 32px; border-radius: 999px; background: linear-gradient(135deg, #1C5A8C, #37B5FF); color: #ffffff; font-weight: 600; text-decoration: none; }
        .note { margin: 24px 0 0; font-size: 13px; line-height: 1.6; color: #35536D; }
        .footer { padding: 24px 40px 36px; background: #F2F6F9; font-size: 12px; color: #5A768F; line-height: 1.6; }
        @media (max-width: 620px) {
            .content { padding: 28px; }
            .grid { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <div class="container">
            <div class="header">
                <img src="<?php echo e($logo_url); ?>" alt="Scalar" />
            </div>
            <div class="content">
                <div class="token">
                    <img src="<?php echo e($token_icon); ?>" alt="Token ScaWatt" />
                    <div>
                        <span class="badge">Compra completada</span>
                        <h1 class="title">¡Tu nuevo ScaWatt ya es tuyo!</h1>
                    </div>
                </div>
                <p class="lead">Hola <?php echo e($comprador); ?>,<br>Gracias por seguir impulsando energía limpia con ScaWatts. Ya registramos tu compra y el token está disponible en tu portafolio.</p>

                <div class="card">
                    <h3>Resumen de la operación</h3>
                    <div class="grid">
                        <div>
                            <strong>Serial ScaWatt</strong>
                            <span><?php echo e($scawatt_serial); ?></span>
                        </div>
                        <div>
                            <strong>ID marketplace</strong>
                            <span>#<?php echo e($marketplace_id); ?></span>
                        </div>
                        <div>
                            <strong>Monto pagado</strong>
                            <span>$ <?php echo e($precio); ?></span>
                        </div>
                        <div>
                            <strong>Fecha de compra</strong>
                            <span><?php echo e($fecha_venta ?? '—'); ?></span>
                        </div>
                        <div>
                            <strong>Vendedor</strong>
                            <span><?php echo e($vendedor ?? 'Marketplace ScaWatts'); ?></span>
                        </div>
                    </div>
                </div>

                <p class="lead">Adjuntamos el certificado y el contrato actualizados de tu ScaWatt para que puedas descargarlos y guardarlos cuando quieras.</p>
                <a class="cta" href="<?php echo e($dashboard_url); ?>" target="_blank" rel="noopener">Ir a mi portafolio</a>
                <p class="note">Recuerda que también puedes encontrar estos documentos en tu panel de usuario dentro de la sección “Mis ScaWatts”. Si necesitas asistencia, escríbenos a <a href="mailto:soporte@escalar.app">soporte@escalar.app</a>.</p>
            </div>
            <div class="footer">
                © <?php echo e(date('Y')); ?> Scalar. Todos los derechos reservados.<br>
                Este correo se envió automáticamente a <?php echo e($comprador); ?> y se compartió con nuestro equipo de notificaciones para seguimiento.
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/emails/marketplace-compra.blade.php ENDPATH**/ ?>