<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Nueva solicitud de retiro</title>
    <style>
        body { font-family: Arial, sans-serif; color: #1f2933; margin: 0; padding: 0; background: #f5f7fa; }
        .container { max-width: 560px; margin: 0 auto; padding: 24px; background: #ffffff; border-radius: 12px; box-shadow: 0 3px 18px rgba(31, 41, 51, 0.1); }
        .header { text-align: center; margin-bottom: 24px; }
        .header h1 { color: #0d9488; margin: 0; font-size: 20px; }
        .details { background: #f0fdfa; border: 1px solid #99f6e4; border-radius: 12px; padding: 18px; margin-bottom: 18px; }
        .details p { margin: 0 0 8px 0; }
        .highlight { font-weight: bold; color: #0f172a; }
        .footer { font-size: 12px; color: #64748b; text-align: center; margin-top: 24px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Solicitud de retiro en ScaWatts</h1>
            <p>Se registró una nueva solicitud que requiere validación.</p>
        </div>

        <div class="details">
            <p><span class="highlight">Folio:</span> #<?php echo e($retiro->id); ?></p>
            <p><span class="highlight">Usuario:</span> <?php echo e($usuario->nombre); ?> (ID <?php echo e($usuario->id); ?>)</p>
            <p><span class="highlight">Correo:</span> <?php echo e($usuario->email); ?></p>
            <p><span class="highlight">Monto solicitado:</span> $<?php echo e(number_format($retiro->monto, 2, ',', '.')); ?></p>
            <p><span class="highlight">Fecha de solicitud:</span> <?php echo e(optional($retiro->created_at)->timezone('America/Bogota')->format('d/m/Y H:i:s')); ?></p>
        </div>

        <div class="details">
            <p><span class="highlight">Método:</span> <?php echo e(ucfirst($retiro->metodo_retiro)); ?></p>
            <p><span class="highlight">Banco:</span> <?php echo e($datosBancarios['banco'] ?? 'N/D'); ?></p>
            <p><span class="highlight">Tipo de cuenta:</span> <?php echo e($datosBancarios['tipo_cuenta'] ?? 'N/D'); ?></p>
            <p><span class="highlight">Número de cuenta:</span> <?php echo e($datosBancarios['numero_cuenta'] ?? 'N/D'); ?></p>
        </div>

        <p>Por favor, ingresa al panel administrativo para validar la información, aprobar o rechazar la solicitud y dar seguimiento al usuario.</p>

        <div class="footer">
            <p>Este mensaje se envió automáticamente desde la plataforma ScaWatts.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/emails/retiro-solicitado.blade.php ENDPATH**/ ?>