<?php $__env->startSection('title', 'ScaWatts'); ?>
<?php $__env->startSection('page-title', 'Inventario de ScaWatts'); ?>
<?php $__env->startSection('page-subtitle', 'Controla seriales, valorizaciones y asignaciones por granja en tiempo real'); ?>

<?php $__env->startSection('page-actions'); ?>
<div class="d-flex gap-2">
    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#modalCrearScawatt">
        <i class="fas fa-plus me-1"></i> Nuevo ScaWatt
    </button>
    <a href="<?php echo e(route('admin.marketplace')); ?>" class="btn btn-sm btn-outline-primary">
        <i class="fas fa-store me-1"></i> Marketplace
    </a>
    <a href="<?php echo e(route('admin.granjas')); ?>" class="btn btn-sm btn-secondary">
        <i class="fas fa-seedling me-1"></i> Granjas
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php
    $estadoOptions = [
        'todos' => 'Todos los estados',
        'activo' => 'Activos',
        'marketplace' => 'En marketplace',
        'reservado' => 'Reservados',
        'vendido' => 'Vendidos',
        'bloqueado' => 'Bloqueados',
    ];

    $tipoOptions = ['todos' => 'Todos los tipos'];
    foreach ($porTipo as $tipoRow) {
        $clave = $tipoRow->tipo ?: 'sin_tipo';
        $tipoOptions[$clave] = ucfirst(str_replace('_', ' ', $clave));
    }

    $ordenOptions = [
        'recientes' => 'Más recientes',
        'valor_desc' => 'Valor mayor a menor',
        'valor_asc' => 'Valor menor a mayor',
        'kwh_desc' => 'kWh mayor a menor',
        'kwh_asc' => 'kWh menor a mayor',
        'valorizacion' => 'Mayor valorización',
    ];
?>

<?php if(session('status')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-1"></i><?php echo e(session('status')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
    </div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong>Revisa el formulario:</strong>
        <ul class="mb-0 mt-2">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
    </div>
<?php endif; ?>

<?php
    $estadoUpdateOptions = [
        'activo' => 'Activo',
        'marketplace' => 'En marketplace',
        'reservado' => 'Reservado',
        'vendido' => 'Vendido',
        'bloqueado' => 'Bloqueado',
    ];

    $tipoSelectOptions = collect($tipoOptions)
        ->filter(fn($label, $value) => $value !== 'todos')
        ->mapWithKeys(fn($label, $value) => [$value => $label])
        ->toArray();

    if (empty($tipoSelectOptions)) {
        $tipoSelectOptions = ['normal' => 'Normal'];
    }
?>

<div class="row g-3 mb-1">
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Total ScaWatts</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['total'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-warning-subtle text-warning"><i class="fas fa-solar-panel"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Activos</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['activos'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-success-subtle text-success"><i class="fas fa-bolt"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">En marketplace</p>
                        <h4 class="fw-semibold mb-0"><?php echo e(number_format($stats['marketplace'])); ?></h4>
                    </div>
                    <span class="icon-circle bg-info-subtle text-info"><i class="fas fa-store"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Valor actual</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['valor_actual']); ?></h4>
                    </div>
                    <span class="icon-circle bg-secondary-subtle text-secondary"><i class="fas fa-coins"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">Valorización</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['valorizacion']); ?></h4>
                    </div>
                    <span class="icon-circle bg-dark-subtle text-dark"><i class="fas fa-chart-line"></i></span>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <p class="text-muted text-uppercase small mb-1">kWh administrados</p>
                        <h4 class="fw-semibold mb-0"><?php echo e($stats['kwh_total']); ?> kWh</h4>
                    </div>
                    <span class="icon-circle bg-primary-subtle text-primary"><i class="fas fa-battery-full"></i></span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0 mb-3">
    <div class="card-body">
        <form method="get" class="row g-3 align-items-end">
            <div class="col-xl-3 col-md-4">
                <label for="estado" class="form-label small text-uppercase text-muted mb-1">Estado</label>
                <select id="estado" name="estado" class="form-select form-select-sm">
                    <?php $__currentLoopData = $estadoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['estado'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-3 col-md-4">
                <label for="granja" class="form-label small text-uppercase text-muted mb-1">Granja</label>
                <select id="granja" name="granja" class="form-select form-select-sm">
                    <option value="todas" <?php if($filtros['granja'] === 'todas'): echo 'selected'; endif; ?>>Todas las granjas</option>
                    <?php $__currentLoopData = $granjas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $granja): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($granja->id); ?>" <?php if($filtros['granja'] == $granja->id): echo 'selected'; endif; ?>><?php echo e($granja->nombre); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="tipo" class="form-label small text-uppercase text-muted mb-1">Tipo</label>
                <select id="tipo" name="tipo" class="form-select form-select-sm">
                    <?php $__currentLoopData = $tipoOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['tipo'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-2 col-md-4">
                <label for="orden" class="form-label small text-uppercase text-muted mb-1">Orden</label>
                <select id="orden" name="orden" class="form-select form-select-sm">
                    <?php $__currentLoopData = $ordenOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($filtros['orden'] === $value): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-xl-1 col-md-4">
                <label for="por_pagina" class="form-label small text-uppercase text-muted mb-1">Por página</label>
                <input type="number" min="10" max="100" id="por_pagina" name="por_pagina" value="<?php echo e($filtros['por_pagina']); ?>" class="form-control form-control-sm">
            </div>
            <div class="col-xl-3 col-md-4">
                <label for="q" class="form-label small text-uppercase text-muted mb-1">Buscar</label>
                <input type="search" id="q" name="q" value="<?php echo e($filtros['q']); ?>" class="form-control form-control-sm" placeholder="Serial, usuario, correo...">
            </div>
            <div class="col-xl-1 col-md-3 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary flex-fill">
                    <i class="fas fa-filter me-1"></i> Aplicar
                </button>
                <a href="<?php echo e(route('admin.scawatts')); ?>" class="btn btn-sm btn-outline-secondary" title="Limpiar filtros">
                    <i class="fas fa-rotate-right"></i>
                </a>
            </div>
        </form>
    </div>
</div>

<div class="row g-3">
    <div class="col-xxl-9 col-xl-8">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="mb-0">Inventario detallado</h6>
                    <small class="text-muted">Mostrando <?php echo e($scawatts->firstItem() ?? 0); ?>-<?php echo e($scawatts->lastItem() ?? 0); ?> de <?php echo e($scawatts->total()); ?> registros</small>
                </div>
                <span class="badge bg-primary-subtle text-primary"><?php echo e(strtoupper($filtros['estado'])); ?></span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>ScaWatt</th>
                                <th>Propietario</th>
                                <th>Granja</th>
                                <th>kWh</th>
                                <th>Valor</th>
                                <th class="text-center">Estado</th>
                                <th>Inicio</th>
                                <th class="text-end">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $scawatts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scawatt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="fw-semibold"><?php echo e($scawatt->scawatt_id ?? 'Sin serial'); ?></div>
                                    <small class="text-muted">Tipo: <?php echo e(ucfirst($scawatt->tipo ?? 'N/D')); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($scawatt->usuario?->nombre ?? 'Sin asignar'); ?></div>
                                    <small class="text-muted"><?php echo e($scawatt->usuario?->email ?? 'Sin correo'); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($scawatt->granja?->nombre ?? 'Sin granja'); ?></div>
                                    <small class="text-muted"><?php echo e($scawatt->granja?->departamento ?? 'N/D'); ?> · <?php echo e($scawatt->granja?->municipio ?? 'N/D'); ?></small>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e(number_format((float) ($scawatt->kwh_asignados ?? 0), 2, ',', '.')); ?> kWh</div>
                                </td>
                                <td>
                                    <div class="fw-semibold">Actual: $<?php echo e(number_format((float) ($scawatt->valor_actual ?? 0), 0, ',', '.')); ?></div>
                                    <small class="text-muted">Inicial: $<?php echo e(number_format((float) ($scawatt->valor_inicial ?? 0), 0, ',', '.')); ?></small>
                                </td>
                                <td class="text-center">
                                    <span class="badge <?php echo e($scawatt->estado === 'activo' ? 'bg-success' : ($scawatt->estado === 'marketplace' ? 'bg-info' : ($scawatt->estado === 'vendido' ? 'bg-secondary' : 'bg-warning text-dark'))); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $scawatt->estado ?? 'N/D'))); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="fw-semibold"><?php echo e($scawatt->fecha_inicio?->format('d M Y') ?? $scawatt->created_at?->format('d M Y') ?? 'N/D'); ?></div>
                                    <small class="text-muted">Actualización: <?php echo e($scawatt->updated_at?->diffForHumans() ?? 'N/D'); ?></small>
                                </td>
                                <td class="text-end">
                                    <button type="button"
                                            class="btn btn-sm btn-outline-primary edit-scawatt-btn"
                                            data-bs-toggle="modal"
                                            data-bs-target="#modalEditarScawatt"
                                            data-action="<?php echo e(route('admin.scawatts.update', $scawatt)); ?>"
                                            data-serial="<?php echo e($scawatt->scawatt_id); ?>"
                                            data-estado="<?php echo e($scawatt->estado); ?>"
                                            data-tipo="<?php echo e($scawatt->tipo); ?>"
                                            data-granja="<?php echo e($scawatt->granja_id); ?>"
                                            data-kwh="<?php echo e($scawatt->kwh_asignados); ?>"
                                            data-valor-inicial="<?php echo e($scawatt->valor_inicial); ?>"
                                            data-valor-actual="<?php echo e($scawatt->valor_actual); ?>"
                                            data-fecha-inicio="<?php echo e(optional($scawatt->fecha_inicio)->format('Y-m-d')); ?>"
                                            data-fecha-final="<?php echo e(optional($scawatt->fecha_final)->format('Y-m-d')); ?>">
                                        <i class="fas fa-pen-to-square me-1"></i> Editar
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted py-5">No se encontraron ScaWatts con los filtros seleccionados.</td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-white border-0">
                <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-2">
                    <small class="text-muted">Valor inicial histórico: <?php echo e($stats['valor_inicial']); ?></small>
                    <?php echo e($scawatts->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
    <div class="col-xxl-3 col-xl-4">
        <div class="card shadow-sm border-0 mb-3">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Distribución por estado</h6>
                <span class="badge bg-dark-subtle text-dark"><?php echo e(number_format($stats['total'])); ?></span>
            </div>
            <div class="card-body">
                <?php $__empty_1 = true; $__currentLoopData = $porEstado; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fila): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                        <div>
                            <div class="fw-semibold"><?php echo e(ucfirst(str_replace('_', ' ', $fila['estado']))); ?></div>
                            <small class="text-muted"><?php echo e($fila['valor']); ?></small>
                        </div>
                        <span class="badge bg-light text-dark"><?php echo e(number_format($fila['total'])); ?></span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-muted mb-0">Sin datos para mostrar.</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Granjas más activas</h6>
                <span class="badge bg-info-subtle text-info"><?php echo e($topGranjas->count()); ?></span>
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $topGranjas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $granja): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-group-item d-flex justify-content-between align-items-start">
                            <div>
                                <div class="fw-semibold"><?php echo e($granja->nombre); ?></div>
                                <small class="text-muted">ScaWatts: <?php echo e(number_format($granja->scawatts_count)); ?></small>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-primary">$<?php echo e(number_format((float) $granja->scawatts_sum_valor_actual, 0, ',', '.')); ?></span>
                                <div><small class="text-muted">kWh: <?php echo e(number_format((float) ($granja->kwh_total ?? 0), 2, ',', '.')); ?></small></div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="list-group-item text-center text-muted py-4">Sin información disponible</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</div>

    <div class="modal fade" id="modalCrearScawatt" tabindex="-1" aria-labelledby="modalCrearScawattLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <form method="post" action="<?php echo e(route('admin.scawatts.store')); ?>" id="formCrearScawatt">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalCrearScawattLabel">
                            <i class="fas fa-solar-panel me-2"></i>Registrar nuevo ScaWatt
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="crear-serial" class="form-label">Serial *</label>
                                <input type="text" id="crear-serial" name="scawatt_id" class="form-control" maxlength="100" required>
                            </div>
                            <div class="col-md-3">
                                <label for="crear-estado" class="form-label">Estado *</label>
                                <select id="crear-estado" name="estado" class="form-select" required>
                                    <?php $__currentLoopData = $estadoUpdateOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value); ?>" <?php if($value === 'activo'): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="crear-tipo" class="form-label">Tipo</label>
                                <input type="text" id="crear-tipo" name="tipo" class="form-control" list="tiposScawatt" placeholder="Normal">
                                <datalist id="tiposScawatt">
                                    <?php $__currentLoopData = $tipoSelectOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($value); ?>"><?php echo e($label); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </datalist>
                            </div>
                            <div class="col-md-4">
                                <label for="crear-granja" class="form-label">Granja asociada</label>
                                <select id="crear-granja" name="granja_id" class="form-select">
                                    <option value="">Sin asignar</option>
                                    <?php $__currentLoopData = $granjas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $granja): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($granja->id); ?>"><?php echo e($granja->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="crear-usuario" class="form-label">Propietario (ID)</label>
                                <input type="number" min="1" id="crear-usuario" name="usuario_id" class="form-control" placeholder="Opcional">
                                <div class="form-text">Déjalo vacío para registrarlo sin propietario.</div>
                            </div>
                            <div class="col-md-4">
                                <label for="crear-kwh" class="form-label">kWh asignados *</label>
                                <input type="number" step="0.01" min="0" id="crear-kwh" name="kwh_asignados" class="form-control" required>
                            </div>
                            <div class="col-md-4">
                                <label for="crear-valor-inicial" class="form-label">Valor inicial (COP) *</label>
                                <input type="number" step="0.01" min="0" id="crear-valor-inicial" name="valor_inicial" class="form-control" required>
                            </div>
                            <div class="col-md-4">
                                <label for="crear-valor-actual" class="form-label">Valor actual (COP)</label>
                                <input type="number" step="0.01" min="0" id="crear-valor-actual" name="valor_actual" class="form-control" placeholder="Se iguala al valor inicial">
                            </div>
                            <div class="col-md-4">
                                <label for="crear-fecha-inicio" class="form-label">Fecha inicio</label>
                                <input type="date" id="crear-fecha-inicio" name="fecha_inicio" class="form-control">
                            </div>
                            <div class="col-md-4">
                                <label for="crear-fecha-final" class="form-label">Fecha final</label>
                                <input type="date" id="crear-fecha-final" name="fecha_final" class="form-control">
                            </div>
                        </div>
                        <p class="text-muted small mt-3 mb-0"><i class="fas fa-shield-check me-1"></i>Solo Master puede crear ScaWatts manuales desde este panel.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Registrar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalEditarScawatt" tabindex="-1" aria-labelledby="modalEditarScawattLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <form method="post" action="#" id="formEditarScawatt">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditarScawattLabel">
                        <i class="fas fa-pen-to-square me-2"></i>Editar ScaWatt <span class="text-primary" data-field="serial"></span>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="editar-estado" class="form-label">Estado</label>
                            <select id="editar-estado" name="estado" class="form-select" required>
                                <?php $__currentLoopData = $estadoUpdateOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value); ?>"><?php echo e($label); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="editar-tipo" class="form-label">Tipo</label>
                            <select id="editar-tipo" name="tipo" class="form-select">
                                <?php $__currentLoopData = $tipoSelectOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value); ?>"><?php echo e(ucfirst(str_replace('_', ' ', $label))); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <option value="">Sin tipo</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="editar-granja" class="form-label">Granja asociada</label>
                            <select id="editar-granja" name="granja_id" class="form-select">
                                <option value="">Sin asignar</option>
                                <?php $__currentLoopData = $granjas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $granja): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($granja->id); ?>"><?php echo e($granja->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="editar-kwh" class="form-label">kWh asignados</label>
                            <input type="number" step="0.01" min="0" id="editar-kwh" name="kwh_asignados" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="editar-valor-inicial" class="form-label">Valor inicial (COP)</label>
                            <input type="number" step="0.01" min="0" id="editar-valor-inicial" name="valor_inicial" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="editar-valor-actual" class="form-label">Valor actual (COP)</label>
                            <input type="number" step="0.01" min="0" id="editar-valor-actual" name="valor_actual" class="form-control" required>
                        </div>
                        <div class="col-md-6">
                            <label for="editar-fecha-inicio" class="form-label">Fecha inicio</label>
                            <input type="date" id="editar-fecha-inicio" name="fecha_inicio" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label for="editar-fecha-final" class="form-label">Fecha final</label>
                            <input type="date" id="editar-fecha-final" name="fecha_final" class="form-control">
                        </div>
                    </div>
                    <div class="alert alert-info mt-3 mb-0" id="valorizacionPreview">
                        <i class="fas fa-chart-line me-1"></i>
                        Valorización estimada: <span data-field="valorizacion">$0</span>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar cambios</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const modalCrear = document.getElementById('modalCrearScawatt');
    if (modalCrear) {
        const formCrear = modalCrear.querySelector('#formCrearScawatt');
        const estadoCrear = formCrear.querySelector('#crear-estado');
        const valorInicialCrear = formCrear.querySelector('#crear-valor-inicial');
        const valorActualCrear = formCrear.querySelector('#crear-valor-actual');
        const usuarioInput = formCrear.querySelector('#crear-usuario');

        const limpiarFormularioCrear = () => {
            formCrear.reset();
            estadoCrear.value = 'activo';
            valorActualCrear.dataset.userEdited = '';
            valorActualCrear.value = '';
        };

        if (valorInicialCrear && valorActualCrear) {
            valorInicialCrear.addEventListener('input', () => {
                if (!valorActualCrear.dataset.userEdited || valorActualCrear.dataset.userEdited === '0' || valorActualCrear.value === '') {
                    valorActualCrear.value = valorInicialCrear.value;
                }
            });

            valorActualCrear.addEventListener('input', () => {
                if (valorActualCrear.value === '' || valorActualCrear.value === valorInicialCrear.value) {
                    valorActualCrear.dataset.userEdited = '';
                } else {
                    valorActualCrear.dataset.userEdited = '1';
                }
            });
        }

        if (usuarioInput) {
            usuarioInput.addEventListener('input', () => {
                if (usuarioInput.value && Number(usuarioInput.value) < 1) {
                    usuarioInput.value = '';
                }
            });
        }

        modalCrear.addEventListener('show.bs.modal', () => {
            limpiarFormularioCrear();
        });

        modalCrear.addEventListener('hidden.bs.modal', () => {
            limpiarFormularioCrear();
        });
    }

    const modalEditar = document.getElementById('modalEditarScawatt');
    if (!modalEditar) {
        return;
    }

    const form = modalEditar.querySelector('#formEditarScawatt');
    const serialField = modalEditar.querySelector('[data-field="serial"]');
    const valorizacionField = modalEditar.querySelector('[data-field="valorizacion"]');
    const estadoSelect = modalEditar.querySelector('#editar-estado');
    const tipoSelect = modalEditar.querySelector('#editar-tipo');
    const granjaSelect = modalEditar.querySelector('#editar-granja');
    const kwhInput = modalEditar.querySelector('#editar-kwh');
    const valorInicialInput = modalEditar.querySelector('#editar-valor-inicial');
    const valorActualInput = modalEditar.querySelector('#editar-valor-actual');
    const fechaInicioInput = modalEditar.querySelector('#editar-fecha-inicio');
    const fechaFinalInput = modalEditar.querySelector('#editar-fecha-final');

    const formatoCOP = (valor) => {
        const numero = Number(valor);
        if (Number.isNaN(numero)) {
            return '$0';
        }
        return '$' + numero.toLocaleString('es-CO', { minimumFractionDigits: 0, maximumFractionDigits: 0 });
    };

    const actualizarValorizacionPreview = () => {
        const valorInicial = Number(valorInicialInput.value || 0);
        const valorActual = Number(valorActualInput.value || 0);
        const diferencia = valorActual - valorInicial;
        valorizacionField.textContent = formatoCOP(diferencia);
    };

    modalEditar.addEventListener('show.bs.modal', (event) => {
        const trigger = event.relatedTarget;
        if (!trigger) {
            return;
        }

        form.action = trigger.getAttribute('data-action');
        serialField.textContent = trigger.getAttribute('data-serial') || '';

        const estado = trigger.getAttribute('data-estado') || 'activo';
        const tipo = trigger.getAttribute('data-tipo') || '';
        const granjaId = trigger.getAttribute('data-granja') || '';
        const kwh = trigger.getAttribute('data-kwh') || '';
        const valorInicial = trigger.getAttribute('data-valor-inicial') || '';
        const valorActual = trigger.getAttribute('data-valor-actual') || '';
        const fechaInicio = trigger.getAttribute('data-fecha-inicio') || '';
        const fechaFinal = trigger.getAttribute('data-fecha-final') || '';

        estadoSelect.value = estado;

        if (tipo) {
            const optionExists = Array.from(tipoSelect.options).some(option => option.value === tipo);
            if (!optionExists) {
                const option = document.createElement('option');
                option.value = tipo;
                option.textContent = tipo.replace(/_/g, ' ').replace(/\b\w/g, (char) => char.toUpperCase());
                tipoSelect.insertBefore(option, tipoSelect.firstChild);
            }
            tipoSelect.value = tipo;
        } else if (tipoSelect.querySelector('option[value=""]')) {
            tipoSelect.value = '';
        }

        granjaSelect.value = granjaId;
        if (!granjaId) {
            granjaSelect.value = '';
        }

        kwhInput.value = kwh;
        valorInicialInput.value = valorInicial;
        valorActualInput.value = valorActual;
        fechaInicioInput.value = fechaInicio;
        fechaFinalInput.value = fechaFinal;

        actualizarValorizacionPreview();
    });

    modalEditar.addEventListener('hidden.bs.modal', () => {
        form.action = '#';
        serialField.textContent = '';
        estadoSelect.value = 'activo';
        tipoSelect.value = '';
        granjaSelect.value = '';
        kwhInput.value = '';
        valorInicialInput.value = '';
        valorActualInput.value = '';
        fechaInicioInput.value = '';
        fechaFinalInput.value = '';
        actualizarValorizacionPreview();
    });

    valorInicialInput.addEventListener('input', actualizarValorizacionPreview);
    valorActualInput.addEventListener('input', actualizarValorizacionPreview);
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/scalarapp/public_html/scadmin/backend/resources/views/admin/scawatts/index.blade.php ENDPATH**/ ?>